


#include"boost_1_30_2/timer.hpp"
#include"boost_1_30_2/random.hpp"

#include<iostream>

#include<cstdlib>

#include "quick_rand.hpp"

const int num = 10000000;

template<class PRNG>
void validate(unsigned long *array,boost::timer &t,const std::string & name, const PRNG &)
{
	std::cout << name << std::endl;
	PRNG rng;
	t.restart();
	for(int i = 0;i<num;i++){
		array[i] = rng();
	}
	std::cout << t.elapsed() << std::endl;
}



int main(){
	using namespace boost;
	using namespace std;
	
	
	int seed = 51;
	
	unsigned long *array = new unsigned long[num];
	
	timer t;
	
	cout << "c_rand" <<endl;
	srand(seed);
	t.restart();
	for(int i = 0;i<num;i++){
		array[i] = rand();
	}
	std::cout << t.elapsed() << std::endl;
	//validate(array,t,"c_rand",rand);
	validate(array,t,"quick_rand", tempest::quick_rand());
	validate(array,t,"minstd_rand", minstd_rand());
	validate(array,t,"minstd_rand0", minstd_rand0());
  	validate(array,t,"ecuyer combined", ecuyer1988());
  	validate(array,t,"mt11213b", mt11213b());
  	validate(array,t,"mt19937", mt19937());
  	validate(array,t,"kreutzer1986", kreutzer1986());
  	validate(array,t,"ranlux3", ranlux3());
  	validate(array,t,"ranlux4", ranlux4());
 	//validate(array,t,"ranlux3_01", ranlux3_01());
  	//validate(array,t,"ranlux4_01", ranlux4_01());
  	//validate(array,t,"ranlux64_3_01", ranlux64_3_01());
  	//validate(array,t,"ranlux64_4_01", ranlux64_4_01());
  	validate(array,t,"taus88", taus88());
  	validate(array,t,"lagged_fibonacci607", lagged_fibonacci607());
	
/*
	tempest::quick_rand r;
	mt19937 r2;
	for(int i=0;i<30;i++){
		cout << r()<<","<<r2() <<endl;		
	}
	
*/
}

