
#include "../pointer/slisted_ptr.hpp"
#include "../pointer/dlisted_ptr.hpp"
#include "../pointer/counted_ptr.hpp"
#include<iostream>
#include<string>

class test{
private:
	std::string _m;
public:
	test(const char * cstr):_m(cstr){std::cout<<"constructor!"<<_m<<std::endl;}
	~test(){std::cout<<"destructor!"<<_m<<std::endl;}
};

using namespace tempest;

int main(){
	{
	slisted_ptr<test> p1(new test("p1"));
	{
		slisted_ptr<test> p2(p1);
		{
			slisted_ptr<test> p3(p1);	
			p3.reset( new test("p31"));
			p3.reset( new test("p32"));
		}
	}
	}
	
	std::cout<<std::endl;
	
	{
	dlisted_ptr<test> p1(new test("p1"));
	{
		dlisted_ptr<test> p2(p1);
		{
			dlisted_ptr<test> p3(p1);	
			p3.reset( new test("p31"));
			p3.reset( new test("p32"));
		}
	}
	}
	
	std::cout<<std::endl;
	
	{
	counted_ptr<test> p1(new test("p1"));
	{
		counted_ptr<test> p2(p1);
		{
			counted_ptr<test> p3(p1);	
			p3.reset( new test("p31"));
			p3.reset( new test("p32"));
		}
	}
	}
	
	std::cout<<std::endl;
	
	{
	direct_counted_ptr<test> p1(new test("p1"));
	{
		direct_counted_ptr<test> p2(p1);
		{
			direct_counted_ptr<test> p3(p1);	
			p3.reset( new test("p31"));
			p3.reset( new test("p32"));
		}
	}
	}
	
	return 0;	
}

