#ifndef _TM_PACK_VECTOR_HPP
#define _TM_PACK_VECTOR_HPP
/** 
	@file packed_vector.hpp
	@brief Defines vector compresser.
	@author ototoi / Toru Matsuoka
	@date 2004/05/16 
	
̃t@CɂāEEE
ɂĉl[Xy[XɈ͂܂Ă܂Ãt@C̕EρEzz͎RłB

̊֐`Ă܂A悤͐KxN^[iPjPUrbgARQrbg̐Ɂij߂܂B
񐸓x͂PUrbgRQrbgłB

@code
//16bitɊi[@΂Ȃ@ŜƂČ덷PackVector16傫B
//A inside component.
//|  packed_vector16   |	
//|FED|C|BA9876|543210| 
//|-------------------|
//|3bt|1| 6bit |  6bit|
//|-------------------|		
//|sgn|_|_value|_value|
//|XYZ|_|xxxxxy|yyyyyy|

packed_vector16 PackVector16x(float x,float y,float z);
//WJ
void UnpackVector16x(packed_vector16 val,float *x,float *y,float *z);

//32bitɊi[
//΂Ȃ
//ŜƂČ덷PackVector32傫B

//A inside component.
//|           packed_vector32            |
//|111|1|11111111111100|00000000000000|	              
//|FED|C|BA9876543210FE|DCBA9876543210| 
//|-----------------------------------|
//|3bt|1|         14bit|         14bit| -> 32bit
//|-----------------------------------|		
//|sgn|_|_________value|_________value|
//|XYZ|_|xxxxxxxxxxxxxx|yyyyyyyyyyyyyy|
packed_vector32 PackVector32x(float x,float y,float z);
//WJ
void UnpackVector32x(packed_vector32 val,float *x,float *y,float *z);



//16bitɊi[
//΂肠
//ŜƂČ덷PackVector16x菬B
//A inside component.
//|  packed_vector16  |	
//|FED|CBA9876|543210| 
//|------------------|
//|3bt|  6bit|   7bit|
//|------------------|		
//|sgn|_value|__value|
//|XYZ|xxxxxx|yyyyyyy|
packed_vector16 PackVector16(float x,float y,float z);
//WJ
void UnpackVector16(packed_vector16 val,float *x,float *y,float *z);

//32bitɊi[
//΂肠
//ŜƂČ덷PackVector32x菬B
//A inside component.
//|           packed_vector32           |
//|111|11111111111110|000000000000000|	               
//|FED|CBA9876543210F|EDCBA9876543210| 
//|----------------------------------|
//|3bt|         14bit|          15bit| -> 32bit
//|----------------------------------|		
//|sgn|_________value|__________value|
//|XYZ|xxxxxxxxxxxxxx|yyyyyyyyyyyyyyy|
packed_vector32 PackVector32(float x,float y,float z);
//WJ
void UnpackVector32(packed_vector32 val,float *x,float *y,float *z);
@endcode

*/
namespace tempest{
typedef unsigned short	packed_vector16;
typedef unsigned int	packed_vector32;
	
packed_vector16 PackVector16x(float x,float y,float z);
void UnpackVector16x(packed_vector16 val,float *x,float *y,float *z);
	
packed_vector32 PackVector32x(float x,float y,float z);
void UnpackVector32x(packed_vector32 val,float *x,float *y,float *z);
	
packed_vector16 PackVector16(float x,float y,float z);
void UnpackVector16(packed_vector16 val,float *x,float *y,float *z);
	
packed_vector32 PackVector32(float x,float y,float z);
void UnpackVector32(packed_vector32 val,float *x,float *y,float *z);
	
}

#endif
