#ifndef _TMANOTHER_MATRIX_FUNCTIONS_HPP
#define _TMANOTHER_MATRIX_FUNCTIONS_HPP

/** 
 *  @file another_matrix_functions.hpp
 *  @brief Defines operators for anoter type matrix.
 *  @author ototoi / Toru Matsuoka
 *  @date 2004/12/25 
 */


#include "../meta/operation_result.hpp"

namespace tempest{
	
	
#define DECLARE_OP( OP )																\
	template<class T,class X, std::size_t RowSz, std::size_t ColSz>						\
	inline matrix<typename operation_result<T,X>::type,RowSz,ColSz>						\
	operator OP (const matrix<T,RowSz,ColSz> &lhs,const matrix<X,RowSz,ColSz> & rhs){	\
		typedef matrix<typename operation_result<T,X>::type,RowSz,ColSz> matrix_type;	\
		return matrix_type(lhs) OP ## = rhs;											\
	}
	
	DECLARE_OP(+)
	DECLARE_OP(-)
	DECLARE_OP(*)
	DECLARE_OP(/)
	
#undef DECLARE_OP
	
	template<class T,class X, std::size_t RowSz, std::size_t ColSz>
	inline matrix<typename operation_result<T,X>::type,RowSz,ColSz>
	operator* (const matrix<T,RowSz,ColSz> &lhs, X rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef matrix<r_type,RowSz,ColSz> matrix_type;
		return matrix_type(lhs) *= r_type(rhs);
	}
	
	template<class T,class X, std::size_t Sz>
	inline vector<typename operation_result<T,X>::type,Sz> operator* (T lhs,const matrix<X,RowSz,ColSz> &rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef matrix<r_type,RowSz,ColSz> matrix_type;
		return matrix_type(rhs) *= r_type(lhs);
	}
	
	template<class T,class X, std::size_t Sz>
	inline vector<typename operation_result<T,X>::type,Sz> operator/ (const matrix<T,RowSz,ColSz> &lhs, X rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef matrix<r_type,RowSz,ColSz> matrix_type;
		return matrix_type(lhs) / r_type(rhs);
	}
	
}

#endif

