#ifndef _TMSSE_TRANSFORM_HPP
#define _TMSSE_TRANSFORM_HPP

#include <cstdlib>
#include "sse_vector.hpp"
#include "sse_matrix.hpp"

namespace tempest{
	

//vout = v*m
//            [a,b,c,d]
//[x,y,z,w] * [e,f,g,h]
//            [i,j,k,l]
//            [n,o,p,q]
inline sse_vector operator* (const sse_vector & lhs,const sse_matrix &rhs){
	using namespace detail;
	
	sse_matrix temp(rhs);
	temp.transpose();
	
	return CVT424(
		SUM_128(_mm_mul_ps(temp.get(0),lhs.get()) ),
		SUM_128(_mm_mul_ps(temp.get(1),lhs.get()) ),
		SUM_128(_mm_mul_ps(temp.get(2),lhs.get()) ),
		SUM_128(_mm_mul_ps(temp.get(3),lhs.get()) )	
	);
}
	
//vout = m*v
//[a,b,c,d]   [x]
//[e,f,g,h] * [y] 
//[i,j,k,l]   [z]
//[n,o,p,q]   [w]
inline sse_vector operator* (const sse_matrix &lhs,const sse_vector & rhs){
	using namespace detail;
	
	return CVT424(
		SUM_128(_mm_mul_ps(lhs.get(0),rhs.get()) ),
		SUM_128(_mm_mul_ps(lhs.get(1),rhs.get()) ),
		SUM_128(_mm_mul_ps(lhs.get(2),rhs.get()) ),
		SUM_128(_mm_mul_ps(lhs.get(3),rhs.get()) )	
	);
}
	
inline void transform(sse_vector *out,const sse_matrix &lhs,const sse_vector & rhs){
	*out = lhs*rhs;
	return;
}
	

}

#endif

