/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.ExportControl;
import com.sun.net.ssl.internal.ssl.MAC;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Vector;

public class CipherSpec
implements ExportControl {
    public byte v_major = (byte)3;
    public byte v_minor = 1;
    public static final boolean useDHE_DSS = true;
    public static final boolean useDH_anon = true;
    public static final boolean useRSA = true;
    public boolean is_exportable;
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 4;
    public static final int f = 5;
    public static final int g = 6;
    public static final int h = 7;
    public int key_exchange_algorithm;
    public static final int i = 0;
    public static final int j = 1;
    public static final int k = 0;
    public static final int l = 1;
    public static final int m = 2;
    public static final int n = 3;
    public static final int o = 4;
    public static final int p = 5;
    public static final int q = 7;
    public CipherBox algCipher;
    public byte[] clntWriteKey;
    public byte[] svrWriteKey;
    public byte[] clntWriteIV;
    public byte[] svrWriteIV;
    public static final int maca_null = 0;
    public static final int maca_md5 = 1;
    public static final int maca_sha = 2;
    public MAC algMAC;
    public byte[] clntMacSecret;
    public byte[] svrMacSecret;
    public static String[] r;
    public String[] enabledCipherSuites;
    public static SecureRandom s;
    public byte cipherSuite_b1;
    public byte cipherSuite_b2;

    static {
        s = new SecureRandom();
    }

    public CipherSpec() {
        try {
            this.is_exportable = true;
            this.key_exchange_algorithm = 0;
            this.setCipherType(0);
            this.setMAC(0);
        }
        catch (Exception exception) {}
    }

    public byte[] getCipherSuite() {
        byte[] byArray = new byte[]{this.cipherSuite_b1, this.cipherSuite_b2};
        return byArray;
    }

    public static String[] getSupportedCipherSuites() {
        if (r == null) {
            Vector<String> vector = new Vector<String>(3, 3);
            vector.addElement("SSL_DH_anon_WITH_DES_CBC_SHA");
            vector.addElement("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
            vector.addElement("SSL_DHE_DSS_WITH_DES_CBC_SHA");
            vector.addElement("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
            vector.addElement("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
            vector.addElement("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
            vector.addElement("SSL_RSA_WITH_RC4_128_MD5");
            vector.addElement("SSL_RSA_WITH_RC4_128_SHA");
            vector.addElement("SSL_RSA_WITH_DES_CBC_SHA");
            vector.addElement("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
            vector.addElement("SSL_DH_anon_WITH_RC4_128_MD5");
            vector.addElement("SSL_RSA_EXPORT_WITH_RC4_40_MD5");
            vector.addElement("SSL_RSA_WITH_NULL_MD5");
            vector.addElement("SSL_RSA_WITH_NULL_SHA");
            vector.addElement("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
            int n2 = vector.size();
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = (String)vector.elementAt(n3);
                ++n3;
            }
            r = stringArray;
        }
        return (String[])r.clone();
    }

    public boolean isEnabled(String string) {
        int n2 = 0;
        while (n2 < this.enabledCipherSuites.length) {
            if (this.enabledCipherSuites[n2].equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public CipherBox newClntCipher() throws NoSuchAlgorithmException {
        return this.algCipher.newCipherBox(this.clntWriteKey, this.clntWriteIV);
    }

    public MAC newClntMAC() throws NoSuchAlgorithmException {
        return this.algMAC.newMAC(this.clntMacSecret);
    }

    public CipherBox newSvrCipher() throws NoSuchAlgorithmException {
        return this.algCipher.newCipherBox(this.svrWriteKey, this.svrWriteIV);
    }

    public MAC newSvrMAC() throws NoSuchAlgorithmException {
        return this.algMAC.newMAC(this.svrMacSecret);
    }

    public void setCipherType(int n2) {
        this.algCipher = CipherBox.newCipher(n2, this.is_exportable);
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public void setMAC(int n2) throws NoSuchAlgorithmException {
        this.algMAC = new MAC(n2, this.v_major, this.v_minor);
    }

    public String toString() {
        String string;
        switch (this.key_exchange_algorithm) {
            case 0: {
                string = "NULL";
                break;
            }
            case 1: {
                string = "RSA";
                break;
            }
            case 2: {
                string = "RSA";
                break;
            }
            case 4: {
                string = "DH_DSS";
                break;
            }
            case 3: {
                string = "DH_RSA";
                break;
            }
            case 6: {
                string = "DHE_DSS";
                break;
            }
            case 5: {
                string = "DHE_RSA";
                break;
            }
            case 7: {
                string = "DH_anon";
                break;
            }
            default: {
                string = "<illegal>";
            }
        }
        return "SSL_" + string + (this.is_exportable && this.algCipher.keySize() != 0 ? "_EXPORT" : "") + "_WITH_" + this.algCipher + "_" + this.algMAC;
    }
}

