#!/bin/sh

# from AuroraFox, modified for TenFourFox, modified for Tenfourbird

local_prefix="/opt/local"

if [ $# -ne 3 ]
then
	echo "usage:" >&2
	echo "$0 lib_installed_dir source_app dest_app" >&2
	exit 1
fi

_pwd="${PWD}"
cd "$1"
lib_installed_dir="${PWD}"
cd "${_pwd}"

src_app=$2
dest_app=$3

dest_dir="${dest_app}/Contents/MacOS"

if [ -e "${dest_app}" ]
then
	echo "Error count: 1" >&2
        echo "destination directory already existed: ${dest_app}" >&2
	exit 1
fi

cp -RL "${src_app}" "${dest_app}" || exit
test -e "${dest_dir}" || exit

libstdcxx_name="libstdc++.6.dylib"
libgcc_name="libgcc_s.1.dylib"

ditto -v "${lib_installed_dir}/${libstdcxx_name}" "${dest_dir}" || exit
ditto -v "${lib_installed_dir}/${libgcc_name}" "${dest_dir}" || exit

eval "${local_prefix}/bin/strip" -x "${dest_dir}/${libstdcxx_name}"

install_name_tool -change "${lib_installed_dir}/${libgcc_name}" "@executable_path/${libgcc_name}" \
                  -id "@executable_path/${libgcc_name}" \
                  "${dest_dir}/${libgcc_name}"

install_name_tool -change "${lib_installed_dir}/${libgcc_name}" "@executable_path/${libgcc_name}" \
                  -change "${lib_installed_dir}/${libstdcxx_name}" "@executable_path/${libstdcxx_name}" \
                  -id "@executable_path/${libstdcxx_name}" \
                  "${dest_dir}/${libstdcxx_name}"

libstdcxx_path="${local_prefix}/lib/libgcc/${libstdcxx_name}"
libgcc_path="${local_prefix}/lib/libgcc/${libgcc_name}"

change_sharelib()
	{
	errcnt=0
	while read file
	do
	libs=`otool -L "${file}" | sed -E -e 's/[[:space:]]+([^[:space:]](.+[^[:space:]])?)[[:space:]]+\([^(]+/\1/p' -e d`
	if [ -z "${libs}" ]
	then
		continue
	fi

	opt_libs=`echo "${libs}" | grep -E -e '^/opt/local/'`

	if [ -n "${opt_libs}" ]
	then
		echo "file: ${file}"
	else
		continue
	fi

	rv=`echo "${opt_libs}" | grep -x -F "${libgcc_path}"`
	if [ -n "${rv}" ]
	then
		echo "	change: ${rv}"
		install_name_tool -change "${libgcc_path}" "@executable_path/${libgcc_name}" "${file}"
	fi

	rv=`echo "${opt_libs}" | grep -x -F "${libstdcxx_path}"`
	if [ -n "${rv}" ]
	then
		echo "	change: ${rv}"
		install_name_tool -change "${libstdcxx_path}" "@executable_path/${libstdcxx_name}" "${file}"
	fi

	rv=`echo "${opt_libs}" | grep -v -x -F "${libstdcxx_path}" | grep -v -x -F "${libgcc_path}"`
	if [ -n "${rv}" ]
	then
		errcnt=$(($errcnt + 1))
		echo "error: unknown shared libraries found" >&2 
		echo "	file: ${file}" >&2
		echo "${rv}" | sed -E -e 's/.+/	shared_lib: &/p' -e d >&2
		echo >&2
	fi
	echo
	done
	if [ "$errcnt" -ne 0 ]
	then
		echo "Error count: $errcnt" >&2
	fi
	}

find "${dest_dir}" -type f | change_sharelib
