#!/bin/sh

# from AuroraFox, modified for TenFourFox and Tenfourbird

libgcc_dylibs="libstdc++.6.dylib libgcc_s.1.dylib"

local_prefix="/opt/local"

if [ $# -ne 3 ]
then
	echo "usage:" >&2
	echo "$0 libgcc_dir source_dir dest_dir" >&2
	echo "	Skip copying libgcc dylibs if libgcc_dir is empty string" >&2
	exit 1
fi

if [  -n "$1" ]
then
	_pwd="${PWD}"
	cd "$1"
	libgcc_dir="${PWD}"
	cd "${_pwd}"
else
	libgcc_dir=""
fi

src_dir=$2
dest_dir=$3

function exit_err() {
	cnt=$1
	msg=$2
	echo "Error count: ${cnt}" >&2
	echo "${msg}" >&2
	exit $1
}

if [ -e "${dest_dir}" ]
then
	exit_err 1 "destination directory already existed: ${dest_dir}"
fi

cp -RL "${src_dir}" "${dest_dir}"
if [ $? -ne 0 ]
then
	echo "Failed to copy directory:" >&2
	echo "	from: ${src_dir}" >&2
	echo "	to: ${dest_dir}" >&2
	exit 1
fi
test -d "${dest_dir}" || exit_err 1 "'${dest_dir}' is not directory."

if [ -n "${libgcc_dir}" ]
then
	bin_dir="${dest_dir}/Contents/MacOS"
	if [ ! -d "${bin_dir}" ]
	then
		echo "Failed to copy dylibs" >&2
		echo "Can't find directory: ${dest_dir}/Contents/MacOS" >&2
		exit 1
	fi

	for dylib in ${libgcc_dylibs}
	do
		ditto -v "${libgcc_dir}/${dylib}" "${bin_dir}" || exit_err 1 "Failed to copy dylib: ${libgcc_dir}/${dylib}"
		install_name_tool -change "${libgcc_dir}/${dylib}" "@executable_path/${dylib}" -id "@executable_path/${dylib}" "${bin_dir}/${dylib}"
		if [ $? -ne 0 ]
		then
			echo "Failed to change dylib install names:" >&2
			echo "	id: @executable_path/${dylib}" >&2
			echo "	change: '${libgcc_dir}/${dylib}' '@executable_path/${dylib}'" >&2
			exit 1
		fi
	done
fi


function change_sharelib() {
	errcnt=0
	while read file
	do
		libs=`otool -L "${file}" | sed -E -e 's/[[:space:]]+([^[:space:]](.+[^[:space:]])?)[[:space:]]+\([^(]+/\1/p' -e d`
		if [ -z "${libs}" ]
		then
			continue
		fi

		opt_libs=`echo "${libs}" | grep -E -e '^/opt/'`

		if [ -n "${opt_libs}" ]
		then
			echo "file: ${file}"
		else
			continue
		fi

		libgcc_prefix=`echo "${opt_libs}" | sed -E -e 's#^[[:space:]]*(/opt/[^/]+/lib/[^/]*gcc[^/]*)/.+$#\1#p' -e d | head -1`

		if [ -n "${libgcc_prefix}" ]
		then
			for dylib in ${libgcc_dylibs}
			do
				if [ -n "`echo "${opt_libs}" | grep -xF "${libgcc_prefix}/${dylib}"`" ]
				then
					echo "  change: ${libgcc_prefix}/${dylib}"
					install_name_tool -change "${libgcc_prefix}/${dylib}" "@executable_path/${dylib}" "${file}"
					opt_libs=`echo "${opt_libs}" | grep -vxF "${libgcc_prefix}/${dylib}"`
				fi
			done
		fi

		if [ -n "${opt_libs}" ]
		then
			errcnt=$(($errcnt + 1))
			echo "error: unknown shared libraries found" >&2
			echo "  file: ${file}" >&2
			echo "${opt_libs}" | sed -E -e 's/.+/   shared_lib: &/p' -e d >&2

			echo >&2
		fi
		echo
	done
	if [ "$errcnt" -ne 0 ]
	then
		echo "Error count: $errcnt" >&2
	fi
}

find "${dest_dir}" -type f | change_sharelib
