/* teo2pnm
   TEO $B$N%U%)!<%^%C%H$+$i(B PNM $B%U%)!<%^%C%H$KJQ49$9$k(B
   */
 
#include        <stdio.h>
#include        <stdlib.h>
#include        <teo.h>		/* Header File of libteo */

int main(int argc,char *argv[]){
    TEOFILE     *fileIn,*fileOut;
    TEOIMAGE    *img;
    int		frame;
  
    if((argc != 2)&&(argc !=3)){
	fprintf(stderr,"Usage: %s FrameNumber [TeoFileName]\n",argv[0]);
	return (-1);
    }

    frame = atoi(argv[1]);

    if (argc==3){
	if ((fileIn = TeoOpenFile(argv[2]))==NULL) TeoError();
    } else {
	if ((fileIn = TeoOpenFile("-"))==NULL) TeoError();
    }

    img  = TeoAllocSimilarImage(fileIn);

    TeoSetAbsFrame(fileIn,frame);
    TeoReadFrame(fileIn,img);

    /* $BHs05=L$N(Bpnm$B%U%!%$%k$rI8=`=PNO$K=q$-=P$9(B */
    if((fileOut = PnmCreateNonGzSimilarFile("-",fileIn))==NULL) TeoError();
    TeoWriteFrame(fileOut,img);

   
    /* $B2hA|$N$?$a$N%a%b%j$r2rJ|(B */
    TeoFreeImage(img);

    /* $B2hA|%U%!%$%k$r%/%m!<%:(B */
    TeoCloseFile(fileIn);
    TeoCloseFile(fileOut);

    return 0;
}
