#include <cstdio>
#include <cstdlib>
#include <teopp.h>
#include <teopp/util.h>

void usage(char *pname){
  fprintf(stderr,"usage: %s maskfile [teofile]\n",pname);
  exit(-1);
}

TeoImage<TeoFloat64> CreateMaskFromChar(char *fname){
  FILE *fp;
  int snum;

  if((fp=fopen(fname,"r")) ==NULL) return TeoImage<TeoFloat64>();
  
  char line[256];
  int cc;
  int width,height,xoffset,yoffset;

  cc = getc(fp);
  ungetc(cc,fp);

  if(char(cc) == 'T' || char(cc) == '\037') {
    fclose(fp);
    return TeoImage<TeoFloat64>(fname);
  }

  if(fgets(line,256,fp) == NULL) return TeoImage<TeoFloat64>();

  if((snum = sscanf(line,"%d%d%d%d",
                    &width,&height,
                    &xoffset,&yoffset)) < 2){
    return TeoImage<TeoFloat64>();
  } else if (snum < 4){
    xoffset = 0;
    yoffset = 0;
  }

  TeoImage<TeoFloat64> ret(width,height,xoffset,yoffset,1);

  TeoFloat64 *dat=(TeoFloat64 *)ret.Data();

  int i=0;
  char buf[256];
  while(i<width*height && fscanf(fp,"%s",buf) != EOF){
    *(dat++) = atof(buf);
    i++;
  }
  while(i<width*height){
    *(dat++) = 0.0;
    i++;
  }
  fclose(fp);

  return ret;
}

TeoImage<TeoFloat64> convol(const TeoImage<TeoFloat64> &img,
			    const TeoImage<TeoFloat64> &mask){
  TeoImage<TeoFloat64> ret(img.Width() - (mask.Width() - 1),
			   img.Height() - (mask.Height() - 1),
			   img.Xoffset() - mask.Xoffset(),
			   img.Yoffset() - mask.Yoffset(),
			   img.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++){
	TeoFloat64 val=0.0;
	for(int my=mask.Ystart();my<=mask.Yend();my++)
	  for(int mx=mask.Xstart();mx<=mask.Xend();mx++)
	    val += mask(mx,my)*img(x+mx,y+my,p);
	ret(x,y,p) = val;
      }
  return ret;
}

int main(int argc,char **argv){
  TeoFile input;
  if(argc<2) usage(argv[0]);

  TeoImage<TeoFloat64> mask;

  mask = CreateMaskFromChar(argv[1]);
  if(mask.Data() == NULL ) usage(argv[0]);

  if(argc<3) input = TeoFile("-");
  else input = TeoFile(argv[2]);

  TeoFile output("-",
		 input.Width() - (mask.Width() - 1),
		 input.Height() - (mask.Height() - 1),
		 input.Xoffset() - mask.Xoffset(),
		 input.Yoffset() - mask.Yoffset(),
		 TEO_FLOAT,64,
		 input.Plane(),input.Frame());

  TeoImage<TeoFloat64> inimg;
  TeoImage<TeoFloat64> outimg;

  for(int f=0;f<input.Frame();f++){
    inimg = input.GetImage();
    outimg = convol(inimg,mask);
    output.PutImage(outimg);
  }
  return 0;
}
