//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOBIT_H_
#define _TEOPP_TEOBIT_H_
// 1bit$B%G!<%?$r07$&$?$a$N%/%i%9(B
class TeoBit {
public:
  // $B%3%s%9%H%i%/%?(B
  TeoBit();
  TeoBit(const TeoBit &value);
  TeoBit(TeoUint8      value);
  TeoBit(TeoSint8      value);
  TeoBit(TeoUint16     value);
  TeoBit(TeoSint16     value);
  TeoBit(TeoUint32     value);
  TeoBit(TeoSint32     value);
  TeoBit(TeoFloat32    value);
  TeoBit(TeoFloat64    value);
  TeoBit(char value, int offset);
  TeoBit(char *pointer, int offset);
  TeoBit(const char *pointer, int offset);

  // $B%G%9%H%i%/%?(B
  ~TeoBit();

  // $B%S%C%H%;%C%H(B
  bool IsSetBit()const;
  TeoBit &Set();
  TeoBit &Unset();
  TEO_BIT GetBit()const;

  TeoBit &operator()(const TeoBit &value);

  // $B3F<o1i;;;R(B
  // $BBeF~1i;;;R(B
  TeoBit &operator= (const TeoBit &value);
  TeoBit &operator= (TEO_BIT       value);
  TeoBit &operator|=(const TeoBit &value);
  TeoBit &operator+=(const TeoBit &value);
  TeoBit &operator&=(const TeoBit &value);
  TeoBit &operator*=(const TeoBit &value);
  TeoBit &operator-=(const TeoBit &value);
  TeoBit &operator/=(const TeoBit &value);
  // $BC19`1i;;;R(B
  TeoBit operator~()const;
  TeoBit operator-()const;
  // $B;MB'1i;;(B
  TeoBit operator|(const TeoBit &value)const;
  TeoBit operator+(const TeoBit &value)const;
  TeoBit operator&(const TeoBit &value)const;
  TeoBit operator*(const TeoBit &value)const;
  TeoBit operator-(const TeoBit &value)const;
  TeoBit operator/(const TeoBit &value)const;
  // $BHf3S1i;;;R(B
  bool operator==(const TeoBit &value)const;
  bool operator!=(const TeoBit &value)const;
  bool operator< (const TeoBit &value)const;
  bool operator<=(const TeoBit &value)const;
  bool operator> (const TeoBit &value)const;
  bool operator>=(const TeoBit &value)const;
  // $B%-%c%9%H1i;;;R(B
  operator TeoUint8()const;
  operator TeoSint8()const;
  operator TeoUint16()const;
  operator TeoSint16()const;
  operator TeoUint32()const;
  operator TeoSint32()const;
  operator TeoFloat32()const;
  operator TeoFloat64()const;

private:
  char data;
  char *ptr;
  char mask;
};
// $B%$%s%i%$%s4X?t$NDj5A(B
#include <teopp/teobit_inline.h>

#endif
