#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "teopp/teobin.h"
#include "teopp/teoanyimage.h"
#include "teopp/teoimage.h"

extern char TEO_ERROR_MESSAGE[];
TeoImage<TeoBin>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoBin>"){}
TeoImage<TeoUint8>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoUint8>"){}
TeoImage<TeoSint8>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoSint8>"){}
TeoImage<TeoUint16>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoUint16>"){}
TeoImage<TeoSint16>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoSint16>"){}
TeoImage<TeoUint32>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoUint32>"){}
TeoImage<TeoSint32>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoSint32>"){}
TeoImage<TeoFloat32>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoFloat32>"){}
TeoImage<TeoFloat64>::Error::Error()
  :TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoImage<TeoFloat64>"){}

bool TeoImage<TeoBin>::TypeCheck()const{
  return (teoimage == NULL || Bit() == 1);
}
bool TeoImage<TeoUint8>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_UNSIGNED && Bit() == 8));
}
bool TeoImage<TeoSint8>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_SIGNED && Bit() == 8));
}
bool TeoImage<TeoUint16>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_UNSIGNED && Bit() == 16));
}
bool TeoImage<TeoSint16>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_SIGNED && Bit() == 16));
}
bool TeoImage<TeoUint32>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_UNSIGNED && Bit() == 32));
}
bool TeoImage<TeoSint32>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_SIGNED && Bit() == 32));
}
bool TeoImage<TeoFloat32>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_FLOAT && Bit() == 32));
}
bool TeoImage<TeoFloat64>::TypeCheck()const{
  return (teoimage == NULL || (Type() == TEO_FLOAT && Bit() == 64));
}

TeoImage<TeoBin> &TeoImage<TeoBin>::operator=(TeoBin e){
  if(e.IsSetBit())
    memset(Data(),255,Fsize());
  else
    memset(Data(),0,Fsize());
  return *this;
}
TeoImage<TeoUint8> &TeoImage<TeoUint8>::operator=(TeoUint8 e){
  memset(Data(),int(e),Fsize());
  return *this;
}
TeoImage<TeoSint8> &TeoImage<TeoSint8>::operator=(TeoSint8 e){
  int tmp = int(*(unsigned char *)(&e));
  memset(Data(),tmp,Fsize());
  return *this;
}
TeoImage<TeoUint16> &TeoImage<TeoUint16>::operator=(TeoUint16 e){
  unsigned char *tmp = (unsigned char *)(&e);
  if(*tmp == *(tmp+1)){
    memset(Data(),int(*tmp),Fsize());
  } else {
    TeoUint16 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}
TeoImage<TeoSint16> &TeoImage<TeoSint16>::operator=(TeoSint16 e){
  unsigned char *tmp = (unsigned char *)(&e);
  if(*tmp == *(tmp+1)){
    memset(Data(),int(*tmp),Fsize());
  } else {
    TeoSint16 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}
TeoImage<TeoUint32> &TeoImage<TeoUint32>::operator=(TeoUint32 e){
  if(e == 0){
    memset(Data(),0,Fsize());
  } else {
    TeoUint32 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}
TeoImage<TeoSint32> &TeoImage<TeoSint32>::operator=(TeoSint32 e){
  if(e == 0){
    memset(Data(),0,Fsize());
  } else {
    TeoSint32 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}
TeoImage<TeoFloat32> &TeoImage<TeoFloat32>::operator=(TeoFloat32 e){
  if(e == 0.0){
    memset(Data(),0,Fsize());
  } else {
    TeoFloat32 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}
TeoImage<TeoFloat64> &TeoImage<TeoFloat64>::operator=(TeoFloat64 e){
  if(e == 0.0){
    memset(Data(),0,Fsize());
  } else {
    TeoFloat64 *ptr=Data();
    int size = Width()*Height()*Plane();
    for(int i=0;i<size;i++)
      *(ptr++) = e;
  }
  return *this;
}


template <class ETYPE>
void TeoImage<ETYPE>::Conversion(){
  TeoAnyImage img(*this);
  TeoImage<ETYPE> ret(Width(),Height(),Xoffset(),Yoffset(),Plane());
  switch(img.Bit()){
  case 1:
    for(int j=0;j<Height();j++)
      for(int i=0;i<Width();i++)
	for(int k=0;k<Plane();k++)
	  ret(i,j,k) = ETYPE(TeoBin((char *)img.Address(i,j,k),(7-i%8)));
    break;
  case 8:
    if(Type() == TEO_UNSIGNED) {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoUint8 *)img.Address(i,j,k));
    } else {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoSint8 *)img.Address(i,j,k));
    }
    break;
  case 16:
    if(img.Type() == TEO_UNSIGNED) {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoUint16 *)img.Address(i,j,k));
    } else {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoSint16 *)img.Address(i,j,k));
    }
    break;
  case 32:
    if(img.Type() == TEO_UNSIGNED) {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoUint32 *)img.Address(i,j,k));
    } else if(img.Type() == TEO_SIGNED){
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoSint32 *)img.Address(i,j,k));
    } else {
      for(int j=0;j<Height();j++)
	for(int i=0;i<Width();i++)
	  for(int k=0;k<Plane();k++)
	    ret(i,j,k) = ETYPE(*(TeoFloat32 *)img.Address(i,j,k));
    }
    break;
  case 64:
    for(int j=0;j<Height();j++)
      for(int i=0;i<Width();i++)
	for(int k=0;k<Plane();k++)
	  ret(i,j,k) = ETYPE(*(TeoFloat64 *)img.Address(i,j,k));
    break;
  }
  (*this) = ret;
}

// specializations
template class TeoImage<TeoBin>;
template class TeoImage<TeoUint8>;
template class TeoImage<TeoSint8>;
template class TeoImage<TeoUint16>;
template class TeoImage<TeoSint16>;
template class TeoImage<TeoUint32>;
template class TeoImage<TeoSint32>;
template class TeoImage<TeoFloat32>;
template class TeoImage<TeoFloat64>;
