/* ************************************************************ loader.c *** *
 * ؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/03/17 18:27:45 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <dlfcn.h>
#include "teoeyes_loader.h"
#include <libgnomevfs/gnome-vfs-mime-handlers.h>

/* եإå⥸塼򤹤ؿ ****************************** */
TeoeyesImageModule*
teoeyesloader_select_from_file (GList		*loader,
				const gchar	*uri_text) {
  TeoeyesImageModule	*module;
  GnomeVFSHandle 	*handle;
  GnomeVFSResult	result;
  GList			*list;

  result = gnome_vfs_open(&handle, uri_text, GNOME_VFS_OPEN_READ);

  for (list = loader; list; list = g_list_next(list)) {
    module = dlsym(list->data, "module");
    if (module->check(handle)) {
      gnome_vfs_close(handle);
      return module;
    }
  }
  gnome_vfs_close(handle);
  
  return NULL;
}

/* MIMEפ⥸塼򤹤ؿ ********************************** */
TeoeyesImageModule*
teoeyesloader_select_from_mime (GList		*loader,
				const gchar	*uri_text) {
  TeoeyesImageModule	*module;
  GnomeVFSFileInfo	*info;
  GnomeVFSResult	result;
  GList			*list;
  int			n;
  
  info = gnome_vfs_file_info_new ();
  result = gnome_vfs_get_file_info (uri_text, info,
				    GNOME_VFS_FILE_INFO_GET_MIME_TYPE);
  if (result != GNOME_VFS_OK) return NULL;
  
  for (list = loader; list; list = g_list_next(list)) {
    module = dlsym(list->data, "module");
    for (n = 0; module->info->mime_types[n]; n++) {
      if (strcmp (info->mime_type, module->info->mime_types[n]) == 0) {
	gnome_vfs_file_info_unref(info);
	return module;
      }
    }
  }
  gnome_vfs_file_info_unref(info);  
  
  return NULL;
}

/* ĥҤ⥸塼򤹤ؿ ************************************** */
TeoeyesImageModule*
teoeyesloader_select_from_extension (GList		*loader,
				     const gchar	*uri_text) {
  TeoeyesImageModule	*module;
  GnomeVFSFileInfo	*info;
  GnomeVFSResult	result;
  GList			*list;
  gchar			*ext = NULL;
  int			n;

  ext = strrchr(uri_text, '.');
  if (!ext) {
    return NULL;
  }
  for (ext++, list = loader; list; list = g_list_next(list)) {
    module = dlsym(list->data, "module");
    for (n = 0; module->info->extensions[n]; n++) {
      if (strcmp (ext, module->info->extensions[n]) == 0) {
	return module;
      }
    }
  }
  return NULL;
}

/* ***************************************************** End of loader.c *** */
