/* **************************************************** teoeyes_loader.h *** *
 * $B%F%*%"%$%:2hA|%m!<%@%i%$%V%i%j(B $B%X%C%@%U%!%$%k(B
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/03/31 14:00:04 sugaya>
 * ************************************************************************* */
#ifndef	__TEOEYES_LOADER_H__
#define	__TEOEYES_LOADER_H__

#include <libgnomevfs/gnome-vfs.h>
#include <gnome.h>

/* ************************************************************************* */
typedef enum {
  IMAGE_FORMAT_WRITABLE = 1 << 0
} ImageFormatFlags;

typedef	struct _ImageFormat {
  gchar			*name;
  gchar			*description;
  gchar			**mime_types;
  gchar			**extensions;
  guint32		flags;
} ImageFormat;

typedef struct _TeoeyesImageModule TeoeyesImageModule;
struct _TeoeyesImageModule {
  gchar			*module_name;
  gchar			*version;
  gchar			*author;
  ImageFormat		*info;
  GdkPixbuf		*icon;

  gboolean		(* check)	(GnomeVFSHandle		*handle);
  GdkPixbuf*		(* load)	(const gchar		*filename,
					 gpointer		data);
  gboolean		(* save)	(const gchar		*filename,
					 gpointer		data);
  void			(* load_info)	(TeoeyesImageModule	*module);
  
};

/* ************************************************************************* */
GdkPixbuf*	gdk_pixbuf_remove_alpha		(const GdkPixbuf	*src);
GdkPixbuf*	gdk_pixbuf_align_rowstride	(const GdkPixbuf	*src);

TeoeyesImageModule*
teoeyesloader_select_from_file 		(GList		*loader,
					 const gchar	*filename);
TeoeyesImageModule*
teoeyesloader_select_from_mime 		(GList		*loader,
					 const gchar	*filename);
TeoeyesImageModule*
teoeyesloader_select_from_extension	(GList		*loader,
					 const gchar	*filename);

#endif /* __TEOEYES_LOADER_H__ */

/* ********************************************** End of teoyes_loader.h *** */
