/* ************************************************************ io-bmp.c *** *
 * BMP⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:26:38 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "bmp.h"
#include "format_bmp.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/bmp",
  "image/x-bmp",
  "image/x-MS-bmp",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "bmp",
  NULL
};

/* ************************************************************************* */
gboolean
check_bmp (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[2];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 2, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (!(buf[0] == 'B' && buf[1] == 'N')) {
    return FALSE;
  }
  return TRUE;

}
/* ************************************************************************* */
GdkPixbuf*
load_bmp (const gchar	*filename,
	  gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
gboolean
save_bmp (const gchar	*filename,
	  gpointer	data) {
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*aligned = NULL, *dst = NULL;
  gchar		*localname;

  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  if (gdk_pixbuf_get_rowstride (src) !=
      gdk_pixbuf_get_width (src) * gdk_pixbuf_get_n_channels (src)) {
    aligned = gdk_pixbuf_align_rowstride (src);
  }
  if ((aligned && gdk_pixbuf_get_has_alpha (aligned)) ||
      gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha ((aligned) ? aligned : src);
  }
  WriteBMP (localname, (dst) ? dst : ((aligned) ? aligned : src));
  if (aligned) gdk_pixbuf_unref (aligned);
  if (dst)     gdk_pixbuf_unref (dst);
  g_free(localname);
  
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "BMP";
  module->info->description	= _("The BMP image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_bmp, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("BMP Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_bmp,
  load_bmp,
  save_bmp,
  load_info
};

/* ***************************************************** End of io-bmp.c *** */
