/* *********************************************************** io-jpeg.c *** *
 * JPEG⥸塼
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:27:39 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_jpeg.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/jpeg",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "jpg",
  "jpeg",
  "jpe",
  NULL
};

/* ************************************************************************* */
gboolean
check_jpeg (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[2];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 2, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (buf[0] != 0xff || buf[1] != 0xd8) {
    return FALSE;
  } else {
    return TRUE;
  }
}

/* ************************************************************************* */
GdkPixbuf*
load_jpeg (const gchar	*filename,
	   gpointer	data) {
  return gnome_gdk_pixbuf_new_from_uri (filename);
}

/* ************************************************************************* */
gboolean
save_jpeg (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*dst = NULL;
  gchar		*localname;

  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  if (gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha (src);
  }
  gdk_pixbuf_save ((dst != NULL) ? dst : src, localname, "jpeg", NULL, NULL);
  if (dst) gdk_pixbuf_unref (dst);
  g_free(localname);
  
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "JPEG";
  module->info->description	= _("The JPEG image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_jpeg, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("JPEG Image Loader"),
  "1.0",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_jpeg,
  load_jpeg,
  save_jpeg,
  load_info
};

/* **************************************************** End of io-jpeg.c *** */
