/* *********************************************************** io-tiff.c *** *
 * TIFF⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:28:49 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_tiff.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/tiff",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "tiff",
  "tif",
  NULL
};

/* ************************************************************************* */
gboolean
check_tiff (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[2];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 2, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if ((buf[0] == 'M' && buf[1] == 'M') || (buf[0] == 'l' && buf[1] == 'l')) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ************************************************************************* */
GdkPixbuf*
load_tiff (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
gboolean
save_tiff (const gchar	*filename,
	   gpointer	data) {
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "TIFF";
  module->info->description	= _("The TIFF image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_tiff, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("TIFF Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_tiff,
  load_tiff,
  save_tiff,
  load_info
};

/* **************************************************** End of io-tiff.c *** */
