/* ************************************************************ io-xpm.c *** *
 * XPM⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:29:27 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_xpm.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/x-xpixmap",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "xpm",
  NULL
};

/* ************************************************************************* */
gboolean
check_xpm (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[9];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 9, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (buf[0] == '/' && buf[1] == '*' &&
      buf[2] == ' ' && buf[3] == 'X' && buf[4] == 'P' && buf[5] == 'M' &&
      buf[6] == ' ' && buf[7] == '*' && buf[8] == '/') {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ************************************************************************* */
GdkPixbuf*
load_xpm (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
gboolean
save_xpm (const gchar	*filename,
	   gpointer	data) {
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "XPM";
  module->info->description	= _("The XPM image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_xpm, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("XPM Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_xpm,
  load_xpm,
  save_xpm,
  load_info
};

/* ***************************************************** End of io-xpm.c *** */
