/* ****************************************************** edge_detect.c *** *
 * Teoeyes Plugin Collection ($B%(%C%88!=P(B)
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/01 08:48:27 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "teoeyes_plugin.h"

#define		MIN_VAL		1
#define		MAX_VAL		32
#define		STEP_SIZE	1
#define		PAGE_SIZE	5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	1

/* RGB$B2hA|$+$i(BY$B2hA|$r@8@.$9$k4X?t(B ****************************************** */
static GdkPixbuf*
_create_y_image (GdkPixbuf	*src) {
  GdkPixbuf	*dst;
  int		row, col;
  guchar	r, g, b, Y;

  dst = gdk_pixbuf_new (GDK_COLORSPACE_RGB, 0, 8, 
			gdk_pixbuf_get_width (src), 
			gdk_pixbuf_get_height (src));
  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_width (src); col++) {
      r = gdk_pixbuf_get_pixel (src, col, row, 0);
      g = gdk_pixbuf_get_pixel (src, col, row, 0);
      b = gdk_pixbuf_get_pixel (src, col, row, 0);
      Y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      gdk_pixbuf_put_pixel (dst, col, row, 0, Y);
      gdk_pixbuf_put_pixel (dst, col, row, 1, Y);
      gdk_pixbuf_put_pixel (dst, col, row, 2, Y);
    }
  }
  return dst;
}

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
plugin_edge_detect (GdkPixbuf	*src,
		    GdkPixbuf	*dst,
		    gpointer	data) {
  GdkPixbuf	*Y;
  int		col, row;
  guchar	val;

  Y = _create_y_image (src);

  for (row = 1; row < gdk_pixbuf_get_height (Y) - 1; row++) {
    for (col = 1; col <= gdk_pixbuf_get_width (Y) - 1; col++) {
      val = 255 - (gdk_pixbuf_get_pixel (Y, col, row, 0) -
		   (gdk_pixbuf_get_pixel (Y, col  , row-1, 0) +
		    gdk_pixbuf_get_pixel (Y, col-1, row  , 0) +
		    gdk_pixbuf_get_pixel (Y, col+1, row  , 0) +
		    gdk_pixbuf_get_pixel (Y, col  , row+1, 0)) / 4);
      gdk_pixbuf_put_pixel (dst, col, row, 0, val);
      gdk_pixbuf_put_pixel (dst, col, row, 1, val);
      gdk_pixbuf_put_pixel (dst, col, row, 2, val);
    }
  }
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
TeoeyesPluginInfo plugin_info = {
  {
    GNOME_APP_UI_ITEM, N_("Edge Detection"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  N_("Edge Detection Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.1",
  N_("This plugin detects the edges from the input image."),
  plugin_edge_detect
};

/* ************************************************ End of edge_detect.c *** */
