/* ********************************************************** gaussian.c *** *
 * Teoeyes Plugin Collection ($B%,%&%7%"%s%U%#%k%?(B)
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/06/27 18:10:46 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "teoeyes_plugin.h"

#define		MIN_VAL		1
#define		MAX_VAL		32
#define		STEP_SIZE	1
#define		PAGE_SIZE	5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   $B%,%&%7%"%s4X?t(B
 * ************************************************************************* */
double
func_gaussian (double sigma, int x) {
  return exp (-0.5 * (x * x) / (sigma * sigma));
}

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
exec_gaussian (GdkPixbuf	*src,
	       GdkPixbuf	*dst,
	       double		param1,
	       double		param2,
	       double		param3) {
  GdkPixbuf	*work;
  int		row, col, p, n;
  int		rs, re, cs, ce;
  int		scope, kernel_size;
  double	sigma, *filter;
  double	sum, gsum;

  sigma = param1;
  scope = (int) sigma;
  kernel_size = scope * 2 + 1;
  cs	= 0;
  ce 	= gdk_pixbuf_get_width (src) - 1;
  rs	= 0;
  re 	= gdk_pixbuf_get_height(src) - 1;

  work = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8,
			 gdk_pixbuf_get_width (src),
			 gdk_pixbuf_get_height (src));
  /* $BF~NO2hA|$N%3%T!<(B */
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {    
      for (p = 0; p < 3; p++) {
	gdk_pixbuf_put_pixel (work, col, row, p, 
			      gdk_pixbuf_get_pixel (src, col, row, p));
      }
    }
  }
  /* $B%,%&%94X?t$NCM$r3JG<$9$kNN0h$N3NJ](B */  
  filter = (double *) malloc (sizeof (double) * kernel_size) + scope;
  for (n = -scope; n <= scope; n++) {
    filter[n] = func_gaussian (sigma, n);
  }
  /* X$BJ}8~$N%,%&%7%"%s%U%#%k%?$rE,MQ$9$k(B */
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {    
      for (p = 0; p < 3; p++) {
	sum  = 0.0;
	gsum = 0.0;
	for (n = -scope; n <= scope; n++) {
	  if (((col + n) >= cs) && ((col + n) <= ce)) {
	    gsum += filter[n];
	    sum  += filter[n] * gdk_pixbuf_get_pixel (src, col+n, row, p);
	  }
	}
	if ((sum / gsum) > 255) {
	  gdk_pixbuf_put_pixel (work, col, row, p, (guint8) 255);
	} else {
	  gdk_pixbuf_put_pixel (work, col, row, p, (guint8) (sum / gsum));
	}
      }
    }
  }
  /* Y$BJ}8~$N%,%&%7%"%s%U%#%k%?$rE,MQ$9$k(B */    
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {    
      for (p = 0; p < 3; p++) {
	sum  = 0.0;
	gsum = 0.0;
	for (n = -scope; n <= scope; n++) {
	  if (((row + n) >= rs) && ((row + n) <= re)) {
	    gsum += filter[n];
	    sum  += filter[n] * gdk_pixbuf_get_pixel (work, col, row+n, p);
	  }
	}
	if ((sum / gsum) > 255) {
	  gdk_pixbuf_put_pixel (work, col, row, p, (guint8) 255);
	} else {
	  gdk_pixbuf_put_pixel (dst, col, row, p, (guint8) (sum / gsum));
	}
      }
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
    teoeyes_plugin_progressbar_update ((double) (row - rs) / (re - rs + 1));
#endif
  }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
  teoeyes_plugin_progressbar_update (0.0);
#endif
  filter -= scope;
  free (filter);
  gdk_pixbuf_unref (work);
}

/* ************************************************************************* *
   $B%W%i%0%$%s<B9TMQ4X?t(B
 * ************************************************************************* */
void
plugin_gaussian (GdkPixbuf	*src,
		 GdkPixbuf	*dst,
		 gpointer	data) {
  /* $B%W%i%0%$%s%@%$%"%m%0$NI=<((B */
  teoeyes_plugin_dialog_new (_("Gaussian Filter"),
			     exec_gaussian,	/* $B%W%i%0%$%s4X?tK\BN(B */
			     src,		/* $BF~NO2hA|(B */
			     dst,		/* $B=PNO2hA|(B */		      
			     _("Sigma"),	/* $B%Q%i%a!<%?%i%Y%k(B */
			     MIN_VAL,		/* $B%Q%i%a!<%?:G>.CM(B */
			     MAX_VAL,		/* $B%Q%i%a!<%?:GBgCM(B */
			     STEP_SIZE,		/* $B%Q%i%a!<%?A}2CNL(B1 */
			     PAGE_SIZE,		/* $B%Q%i%a!<%?A}2CNL(B2 */
			     TRUE,	        /* $B%W%l%S%e!<2hLL$N;HMQ(B */
			     TRUE);		/* $B%W%m%0%l%9%P!<$N;HMQ(B */
  gtk_main ();
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
TeoeyesPluginInfo plugin_info = {  
  {
    GNOME_APP_UI_ITEM, N_("Gaussian Filter"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  N_("Gaussian Filter Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.3",
  N_("This plugin applies the gaussian filter to the image."),
  plugin_gaussian
};

/* *************************************************** End of gaussian.c *** */

