/* ********************************************************* assistant.c *** *
 * Ȥ˴ؤؿ
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/05/24 14:31:10 sugaya>
 * ************************************************************************* */
#include <gdk/gdkkeysyms.h>
#include <libgtkhtml/gtkhtml.h>
#include "teoeyes.h"
#include "assistant.h"
#include "glib-fileutil-extension.h"

/* ************************************************************************* */
static void	cb_html_destroy		(GtkWidget	*widget,
					 gpointer	data);
static void	cb_html_close		(GtkWidget	*widget,
					 gpointer	data);
static void	cb_html_go_back		(GtkWidget	*widget,
					 gpointer	data);
static void	cb_html_go_forward	(GtkWidget	*widget,
					 gpointer	data);
static void	cb_html_go_index	(GtkWidget	*widget,
					 gpointer	data);

/* ************************************************************************* *
 * HTMLɥ
 * ************************************************************************* */

/* ************************************************************************* */
static GtkItemFactoryEntry menu_items[] = {
  {N_("/_File"),        	NULL, NULL, 0, "<Branch>", NULL},
  {N_("/_File/_Close"),		"<Control>W",
   cb_html_close,		0, "<StockItem>", GTK_STOCK_CLOSE},
  
  {N_("/_Jump"),        	NULL, NULL, 0, "<Branch>", NULL},
  {N_("/_Jump/Go _Index"), 	"<Control>I", 
   cb_html_go_index, 		0, "<StockItem>", GTK_STOCK_INDEX},
  {N_("/_Jump/separator"), 	NULL, NULL, 0, "<Separator>", NULL},
  {N_("/_Jump/Go _Back"), 	"<Control>B",
   cb_html_go_back, 		0, "<StockItem>", GTK_STOCK_GO_BACK},
  {N_("/_Jump/Go _Forward"),	"<Control>F", 
   cb_html_go_forward, 		0, "<StockItem>", GTK_STOCK_GO_FORWARD},
};

/* ************************************************************************* */
static void
cb_html_destroy (GtkWidget	*widget,
		 gpointer	data) {
  gtk_widget_hide    (html_window);
  gtk_widget_destroy (html_window);
  html_window = NULL;
}

/* ************************************************************************* */
static void
cb_html_close (GtkWidget	*widget,
	       gpointer		data) {
  gtk_widget_hide (html_window);
}

/* ************************************************************************* */
static void
cb_html_go_back (GtkWidget	*widget,
		 gpointer	data) {
  DhHtml	*document;
  GtkWidget	*button;
  GList		*list;
  gchar		*url;

  /* URL */
  document = (DhHtml *) g_object_get_data (G_OBJECT (html_window), "document");
  url = g_strdup ((gchar *) document->back_list->data);

  /* ߤURLֿʤץꥹȤɲ */
  document->forward_list
    = g_list_append (document->forward_list, 
		     g_strdup (document->priv->base_url));
  document->forward_list = g_list_last (document->forward_list);

  /* ץꥹȤι */
  if (!g_list_previous (document->back_list)) {
    /* ⤦ʤХꥹȤ򥯥ꥢơץܥ̵ */
    g_list_foreach (document->back_list, (GFunc) g_free, NULL);
    document->back_list = NULL;
    
    button = (GtkWidget *)
      g_object_get_data (G_OBJECT (html_window), "back_button");
    gtk_widget_set_sensitive (button, FALSE);
  } else {
    /* ꥹȤ򹹿 */
    document->back_list = g_list_previous (document->back_list);
    list = g_list_next (document->back_list);
    document->back_list->next = NULL;
    g_list_foreach (list, (GFunc) g_free, NULL);
  }
  /* URLɽ */
  dh_html_open_uri (document, url);
  g_free (url);

  /* ֿʤץܥͭ */
  button = G_GET_WIDGET (html_window, "forward_button");
  if (!GTK_WIDGET_SENSITIVE (button)) gtk_widget_set_sensitive (button, TRUE);
}

/* ************************************************************************* */
static void
cb_html_go_forward (GtkWidget	*widget,
		    gpointer	data) {
  DhHtml	*document;
  GtkWidget	*button;
  GList		*list;
  gchar		*url;

  /* URL */
  document = (DhHtml *) g_object_get_data (G_OBJECT (html_window), "document");
  url = g_strdup ((gchar *) document->forward_list->data);

  /* ߤURLץꥹȤɲ */
  document->back_list
    = g_list_append (document->back_list, 
		     g_strdup (document->priv->base_url));
  document->back_list = g_list_last (document->back_list);
  
  /* ֿʤץꥹȤι */
  if (!g_list_previous (document->forward_list)) {
    /* ⤦ʤʤХꥹȤ򥯥ꥢơֿʤץܥ̵ */
    g_list_foreach (document->forward_list, (GFunc) g_free, NULL);
    document->forward_list = NULL;
    
    button = G_GET_WIDGET (html_window, "forward_button");
    gtk_widget_set_sensitive (button, FALSE);
  } else {
    /* ꥹȤ򹹿 */
    document->forward_list = g_list_previous (document->forward_list);
    list = g_list_next (document->forward_list);
    document->forward_list->next = NULL;
    g_list_foreach (list, (GFunc) g_free, NULL);
  }
  /* URLɽ */
  dh_html_open_uri (document, url);
  g_free (url);

  /* ץܥͭ */
  button = G_GET_WIDGET (html_window, "back_button");
  if (!GTK_WIDGET_SENSITIVE (button)) gtk_widget_set_sensitive (button, TRUE);
}

/* ************************************************************************* */
static void
cb_html_go_index (GtkWidget	*widget,
		  gpointer	data) {
  gchar	*index;

  index = g_strconcat ("file://", TEOEYES_HTML_DIR, G_DIR_SEPARATOR_S,
		     "index.html", NULL);
  if (!index) return;

  assistant_set_document ((DhHtml *) 
			  g_object_get_data (G_OBJECT (html_window),
					     "document"), index);
  g_free (index);
}

/* ************************************************************************* */
void
assistant_set_document (DhHtml		*document,
			const gchar	*uri) {
  dh_html_open_uri (document, uri);
}

/* ************************************************************************* */
GtkWidget*
html_window_new (void) {
  DhHtml		*document;
  GtkWidget		*window;
  GtkWidget		*vbox;
  GtkWidget		*menubar;
  GtkWidget		*toolbar;
  GtkWidget		*button;
  GtkWidget		*widget;
  GtkWidget		*html_widget;
  GtkItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;
  gint			nmenu_items;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("TeoEyes HTML Browser"));
  gtk_window_set_resizable (GTK_WINDOW (window), TRUE);
  gtk_window_set_icon (GTK_WINDOW (window), teoeyes_icon);
  g_signal_connect (G_OBJECT (window),
		    "destroy", G_CALLBACK (cb_html_destroy), NULL);
  g_signal_connect (G_OBJECT (window),
		    "delete_event", G_CALLBACK (cb_html_destroy), NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  G_SET_OBJECT(window, "vbox1", vbox);
  {
    /* ˥塼С */
    nmenu_items  = sizeof (menu_items) / sizeof (menu_items[0]);
    accel_group  = gtk_accel_group_new ();
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
					 "<main>", accel_group);
    gtk_item_factory_set_translate_func 
      (item_factory, (GtkTranslateFunc) gettext, NULL, NULL);
    
    gtk_item_factory_create_items (item_factory,
				   nmenu_items, menu_items, NULL);
    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

    menubar = gtk_item_factory_get_widget (item_factory, "<main>");
    gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, FALSE, 0);
    G_SET_OBJECT (window, "menubar", menubar);

    /* ġС */
    toolbar = gtk_toolbar_new ();
    gtk_box_pack_start (GTK_BOX (vbox), toolbar, FALSE, FALSE, 0);
    G_SET_OBJECT (window, "toolbar", toolbar);
   
    button = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
				       GTK_STOCK_GO_BACK, NULL, NULL,
				       G_CALLBACK (cb_html_go_back), NULL, -1);
    gtk_widget_set_sensitive (button, FALSE);
    G_SET_OBJECT (window, "back_button", button);

    button = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
				       GTK_STOCK_GO_FORWARD, NULL, NULL,
				       G_CALLBACK (cb_html_go_forward), 
				       NULL, -1);
    gtk_widget_set_sensitive (button, FALSE);    
    G_SET_OBJECT (window, "forward_button", button);
 
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
			      GTK_STOCK_INDEX, NULL, NULL,
			      G_CALLBACK (cb_html_go_index), NULL, -1);

    widget = gtk_hseparator_new();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 3);
    
    /* HTMLɥ */
    document = dh_html_new ();	
    html_widget = dh_html_get_widget (document);
    gtk_box_pack_start (GTK_BOX (vbox), html_widget, TRUE, TRUE, 0);
    g_object_set_data (G_OBJECT (window), "document", document);
    G_SET_OBJECT (window, "html_widget", html_widget);
  }
  return window;
}

/* ************************************************************************* *
 * ᥤ󥦥ɥΥХåؿ
 * ************************************************************************* */

/* ȤΥ ************************************************** */
static void
assistant_cb_close (GtkWidget	*widget,
		    gpointer	data) {
  gtk_widget_hide (GTK_WIDGET (data));
  gtk_widget_hide (widget);
}

/* ޥܥ󤬲줿ν ****************************************** */
static void
assistant_cb_mouse_press (GtkWidget		*widget,
			  GdkEventButton	*ev) {
  AssistantSkinData	*skin;
  GtkWidget		*msgbox;
  int			wx, wy;

  if (ev->type == GDK_2BUTTON_PRESS) {
    skin = (AssistantSkinData *) g_object_get_data (G_OBJECT (widget), "skin");
    msgbox = G_GET_WIDGET (widget, "msg_box");
    gdk_window_get_root_origin (widget->window, &wx, &wy);    
    gtk_widget_show (msgbox);
    gtk_widget_set_uposition (msgbox, wx + skin->xoffset, wy + skin->yoffset);
  } else if (ev->button == 1) {
    G_SET_PARAMETER (widget, "move_x_pos", (gint) ev->x);
    G_SET_PARAMETER (widget, "move_y_pos", (gint) ev->y);
  } else {
    msgbox = G_GET_WIDGET (widget, "msg_box");
    gtk_widget_hide (msgbox);
    gtk_widget_hide (widget);
  }
}

/* ޥưν ************************************************** */
static void
assistant_cb_mouse_motion (GtkWidget		*widget,
			   GdkEventMotion	*ev) {
  AssistantSkinData	*skin;
  GtkWidget		*msgbox;
  GdkModifierType	state;
  gint			x, y, ox, oy;

  gdk_window_get_pointer (NULL, &x, &y, &state);

  if ((state & GDK_BUTTON1_MASK) != 0) {
    skin = (AssistantSkinData *) g_object_get_data (G_OBJECT (widget), "skin");
    msgbox = G_GET_WIDGET (widget, "msg_box");
    ox = (gint) G_GET_PARAMETER (widget, "move_x_pos");
    oy = (gint) G_GET_PARAMETER (widget, "move_y_pos");  
    gdk_window_move (widget->window, x - ox, y - oy);
    gdk_window_move (msgbox->window,
		     x - ox + skin->xoffset, y - oy + skin->yoffset);
  }
}

/* ************************************************************************* *
 * åɥΥХåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
assistant_cb_msg_query (GtkWidget	*widget,
			gpointer	*data) {
  GtkEntry	*entry;
  GSList	*list;
  FILE		*src_fp, *dst_fp;
  gchar		*cmd, *keyword, *file, *euc_file, *uri;
  gchar		*euc_tag = "<meta content=\"text/html; charset=EUC-JP\" http-equiv=\"Content-Type\">";
  gchar		buf[1024];
  gint		n;


  /* ɤγ */
  entry = GTK_ENTRY (G_GET_WIDGET (data, "entry"));
  keyword = g_locale_from_utf8 ((gchar *) gtk_entry_get_text (entry),
				-1, NULL, NULL, NULL);
  if (!keyword) return;

  /* ̽ϥե(ƥݥ) */
  file = g_build_filename (g_get_home_dir(), ".teoeyes/tmp.html", NULL);
  if (!file) return;
 
  /* ޥɤĹ׻ */
  for (list = tc->assistant_doc_folders, n = 0;
       list; list = g_slist_next(list)) {
    n += strlen (list->data) + 1;
  }
  n += strlen (file) + 1;
  n += strlen (keyword) + 1;
  n += 14;
  cmd = g_new (gchar, n);
  if (!cmd) {
    g_free (file);
    return;
  }
  /* ޥɤ¹ */
  sprintf (cmd, "namazu -h -o %s %s", file, keyword);
  for (list = tc->assistant_doc_folders, n = strlen (cmd); list;
       list = g_slist_next (list)) {
    strcat (cmd + n, " ");
    strcat (cmd + n + 1, list->data);
    n += strlen (list->data) + 1;
  }
  system (cmd);
  g_free (cmd);
  g_free (keyword);

  /* ̥եʸɤ */
  src_fp = fopen (file, "r");
  if (!src_fp) {
    g_free (file);
    return;
  }
  euc_file = g_build_filename (g_get_home_dir(), ".teoeyes/search_result.html",
			       NULL);
  if (!euc_file) {
    g_free (file);
    fclose (src_fp);
    return;
  }
  dst_fp = fopen (euc_file, "w");
  if (!dst_fp) {
    g_free (file);
    g_free (euc_file);
    fclose (src_fp);    
    return;
  }
  for (n = 0; n < 4; n++) {
    fgets (buf, 1024, src_fp);
    fprintf (dst_fp, "%s", buf);
  }
  fprintf (dst_fp, "%s\n", euc_tag);
  while (fgets (buf, 1024, src_fp)) fprintf (dst_fp, "%s", buf);

  g_file_remove (file);
  fclose (src_fp);
  fclose (dst_fp);
  g_free (file);

  /* ̤ɽ */
  if (g_file_exist (euc_file)) {
    if (!html_window) html_window = html_window_new ();
    gtk_widget_set_size_request (html_window, HTML_WINDOW_W, HTML_WINDOW_H);
    gtk_widget_show_all (html_window);
    uri = g_strconcat ("file://", euc_file, NULL);
    assistant_set_document ((DhHtml *) 
			    g_object_get_data (G_OBJECT (html_window), 
					       "document"), 
			    uri);
    g_free (uri);
  }
  g_free (euc_file);
}

/* ************************************************************************* */
static void
assistant_cb_none (GtkWidget	*widget,
		   gpointer	data) {
  return;
}

/* ************************************************************************* */
static void
assistant_cb_msg_cancel (GtkWidget	*widget,
			 gpointer	data) {
  gtk_widget_hide (GTK_WIDGET (data));
}

/* ************************************************************************* *
 * ؿ
 * ************************************************************************* */

/* ǡ ****************************************************** */
static AssistantSkinData*
assistant_skin_new (const gchar	*skin_data) {
  AssistantSkinData	*skin;
  FILE			*fp;
  GdkPixbuf		*pbuf;
  GdkPixmap		*pixmap;
  GdkBitmap		*mask;
  gchar			*skin_path, *file, *data_file;
  gchar			name[1024];
  int			n;
  
  /* ǡեΥץ */
  fp = fopen (skin_data, "r");
  if (!fp) {
    g_printerr (_("Could not open assistant skin data.\n"));
    return NULL;
  }
  /* ǡѥγ */
  g_separate_path (skin_data, &skin_path, &file);
  g_free (file);
  
  /* ¤Τΰ */
  skin = (AssistantSkinData *) g_malloc (sizeof (AssistantSkinData));

  /* ΤΥǡ */
  fscanf (fp, "%s", name);
  data_file = g_build_filename (skin_path, name, NULL);
  pbuf = gdk_pixbuf_new_from_file (data_file, NULL);
  gdk_pixbuf_render_pixmap_and_mask (pbuf,
				     &(skin->body), &(skin->body_mask), 255);
  gdk_pixbuf_unref (pbuf);
  g_free (data_file);
  
  /* åܥå(塦) */
  for (n = 0; n < 4; n++) {
    fscanf (fp, "%s", name);
    data_file = g_build_filename (skin_path, name, NULL);
    pbuf = gdk_pixbuf_new_from_file (data_file, NULL);
    gdk_pixbuf_render_pixmap_and_mask (pbuf, &(skin->msg_box[n]), &mask, 255);
    if (mask) gdk_bitmap_unref (mask);
    g_free (data_file);
  }
  /* åܥåޥ */
  fscanf (fp, "%s", name);
  data_file = g_build_filename (skin_path, name, NULL);
  pbuf = gdk_pixbuf_new_from_file (data_file, NULL);
  gdk_pixbuf_render_pixmap_and_mask (pbuf, &pixmap, &(skin->msg_box_mask),255);
  gdk_pixmap_unref (pixmap);
  g_free (data_file);
  
  /* ΤȥåܥåȤΥեå */
  fscanf (fp, "%d %d", &(skin->xoffset), &(skin->yoffset));
  
  fclose (fp);
  
  return skin;
}

/* ǡΥå ************************************************** */
static void
assistant_attach_skin (GtkWidget	*canvas,
		       GdkPixmap	*pixmap) {
  int	w, h;
  
  gdk_window_get_size  (pixmap, &w, &h);
  gtk_widget_set_size_request (canvas, w, h);
  gdk_window_set_back_pixmap (canvas->window, pixmap, FALSE);
  gdk_window_clear (canvas->window);
}

/* åܥå ************************************************ */
static GtkWidget*
assistant_msgbox_new (GtkWidget		*parent,
		      AssistantSkinData	*skin) {
  GtkWidget	*msgbox;
  GtkWidget	*table;
  GtkWidget	*canvas;
  GtkWidget	*vbox, *hbox;
  GtkWidget	*widget;
  gint		w, h;

  /* ɥ */
  msgbox = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (msgbox), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (msgbox), 0);
  gtk_widget_realize (msgbox);
  gdk_window_set_decorations (msgbox->window, FALSE);
  g_signal_connect (G_OBJECT (msgbox), "destroy",
		    G_CALLBACK (assistant_cb_none), NULL);
  g_signal_connect (G_OBJECT (msgbox), "delete_event",
		    G_CALLBACK (assistant_cb_none), NULL);
  
  /* ơ֥ */
  table = gtk_table_new (3, 3, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (msgbox), table);
  G_SET_OBJECT (parent, "table", table);

  /* Х */
  canvas = gtk_drawing_area_new ();
  gtk_widget_show (canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 0, 1, 0, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  assistant_attach_skin (canvas, skin->msg_box[0]);
  G_SET_OBJECT (msgbox, "canvas_left", canvas);
			    
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 2, 3, 0, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  assistant_attach_skin (canvas, skin->msg_box[1]);  
  G_SET_OBJECT (msgbox, "canvas_right", canvas);
  
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  assistant_attach_skin (canvas, skin->msg_box[2]);    
  G_SET_OBJECT (msgbox, "canvas_top", canvas);

  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  assistant_attach_skin (canvas, skin->msg_box[3]);
  G_SET_OBJECT (msgbox, "canvas_bottom", canvas);

  /* ȥꥦåȤ */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_table_attach (GTK_TABLE (table), vbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  G_SET_OBJECT (msgbox, "vbox", vbox);
  {
    widget = gtk_label_new (_("What keyword do you want to know about ?"));
    gtk_widget_show (widget);
    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    gtk_widget_set_size_request (widget, -1, 30);
    G_SET_OBJECT (msgbox, "label1", widget);

    widget = gtk_entry_new ();
    gtk_widget_show (widget);
    gtk_box_pack_start (GTK_BOX (vbox), widget, TRUE, TRUE, 0);    
    gtk_widget_set_size_request (widget, -1, 22);
    g_object_set_data (G_OBJECT (msgbox), "entry", widget);
    G_SET_OBJECT (msgbox, "entry", widget);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
    G_SET_OBJECT (msgbox, "hbox", hbox);
    {
      widget = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
      gtk_widget_show (widget);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_size_request (widget, 120, 28);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (assistant_cb_msg_cancel),
			(gpointer) msgbox);
      G_SET_OBJECT (msgbox, "button1", widget);

      widget = gtk_button_new_from_stock (GTK_STOCK_FIND);
      gtk_widget_ref (widget);          
      gtk_widget_show (widget);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_size_request (widget, 120, 28);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (assistant_cb_msg_query),
			(gpointer) msgbox);
      G_SET_OBJECT (msgbox, "button2", widget);
    }
  }
  gdk_window_get_size (skin->msg_box_mask, &w, &h);
  gtk_widget_set_size_request (msgbox, w, h);
  gtk_widget_shape_combine_mask (msgbox, skin->msg_box_mask, 0, 0);
  gdk_window_clear (msgbox->window);
  
  return msgbox;
}

/* Ȥ ****************************************************** */
GtkWidget*
assistant_new (const gchar	*skin_file) {
  GtkWidget		*window;
  GtkWidget		*canvas;
  GtkWidget		*msgbox;
  AssistantSkinData	*skin;
  gint			w, h;
  
  /* ɤ߹ */
  skin = assistant_skin_new (skin_file);

  /* Ȥ礭 */
  gdk_window_get_size (skin->body, &(skin->width), &(skin->height));  
  
  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_ref (window);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);

  gtk_widget_set_events (window,
			 GDK_ENTER_NOTIFY_MASK | 
			 GDK_LEAVE_NOTIFY_MASK |
			 GDK_POINTER_MOTION_MASK |
			 GDK_BUTTON_PRESS_MASK |
			 GDK_BUTTON_RELEASE_MASK);

  g_signal_connect (G_OBJECT (window), "motion_notify_event",
		    G_CALLBACK (assistant_cb_mouse_motion), NULL);
  g_signal_connect (G_OBJECT (window), "button_press_event",
		    G_CALLBACK (assistant_cb_mouse_press), NULL);
  gtk_widget_realize (window);
  gdk_window_set_decorations (window->window, FALSE);
  
  /* Х */
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref  (canvas);
  gtk_widget_show (canvas);
  gtk_container_add (GTK_CONTAINER (window), canvas);
  G_SET_OBJECT (window, "canvas", canvas);

  gdk_window_get_size (skin->body, &w, &h);
  gtk_widget_set_size_request (window, w, h);
  gtk_drawing_area_size (GTK_DRAWING_AREA (canvas), w, h);  
  gtk_widget_shape_combine_mask (window, skin->body_mask, 0, 0);
  gdk_window_set_back_pixmap (canvas->window, skin->body, FALSE);
  gdk_window_clear (canvas->window);

  /* åܥå */
  msgbox = assistant_msgbox_new (window, skin);
  G_SET_OBJECT    (window, "msg_box", msgbox);
  G_SET_PARAMETER (window, "skin",    skin);
  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (assistant_cb_close), (gpointer) msgbox);
  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (assistant_cb_close), (gpointer) msgbox);
  
  return window;  
}

/* ************************************************************************* */
void
assistant_destroy (GtkWidget	*assistant) {
  AssistantSkinData	*skin;

  skin = (AssistantSkinData *) G_GET_PARAMETER (assistant, "skin");
  if (skin) {
    gdk_pixmap_unref (skin->body);
    gdk_pixmap_unref (skin->msg_box[0]);
    gdk_pixmap_unref (skin->msg_box[1]);
    gdk_pixmap_unref (skin->msg_box[2]);
    gdk_pixmap_unref (skin->msg_box[3]);
    gdk_bitmap_unref (skin->body_mask);
    gdk_bitmap_unref (skin->msg_box_mask);
  }
  gtk_widget_destroy (assistant);
}	

/* ************************************************** End of assistant.c *** */
