/* ************************************************************** edit.c *** *
 * $B2hA|%(%G%#%C%H%@%$%"%m%0(B
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/18 04:40:53 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gdk/gdkkeysyms.h>
#include "teoeyes.h"
#include "cripping.h"
#include "edit.h"
#include "grab.h"
#include "operation.h"
#include "gtkiconbutton.h"
#include "list_window.h"

#include "book_open.icon"
#include "book_close.icon"
#include "curve.icon"
#include "brightness.icon"
#include "contrast.icon"

enum {
  VALUE_ALL,
  VALUE_RED,
  VALUE_GREEN,
  VALUE_BLUE
};

#define	STOCK_ICON_DIR	"stock"

static GdkPixbuf	*book_open;
static GdkPixbuf	*book_close;
static gboolean		keep_aspect;

/* ************************************************************************* */
static void	icon_new		(GtkWidget		*parent);
static void	set_page_image 		(GtkNotebook		*notebook,
					 gint			page_num,
					 GdkPixbuf		*pixbuf);
static void	cb_page_switch 		(GtkWidget		*widget,
					 GtkNotebookPage 	*page,
					 gint			page_num);
static void	cb_destroy		(GtkWidget		*widget,
					 GtkWidget		*parent);

/* ************************************************************************* */
static void color_balance_render_mod 	(GtkWidget		*a,
					 GdkPixbufModifier	*modifier,
					 gint			channel,
					 gint			br);
static void update_graphs		(GtkWidget		*w);
static void color_balance_channel	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_gamma		(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_bright 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_cont		(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_gamma	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_bright (GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_cont 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_apply 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_reset	(GtkWidget		*widget,
					 gpointer		data);

/* ************************************************************************* */
static gboolean geometry_enter_width	(GtkWidget		*widget,
					 GdkEventKey		*key, 
					 gpointer		data);
static gboolean geometry_enter_height	(GtkWidget		*widget,
					 GdkEventKey		*key, 
					 gpointer		data);
static void geometry_keep_aspect 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_apply 	(GtkWidget		*widget,
					 gpointer		parent);
static void geometry_button_half 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_down 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_reset 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_up 		(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_double 	(GtkWidget		*widget,
					 gpointer		data);
static void normal_button_best		(GtkWidget		*widget,
					 gpointer		data);
static void normal_button_apply 	(GtkWidget		*widget,
					 gpointer		parent);

/* ************************************************************************* */
static void crip_change_x 		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_y 		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_width		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_height		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_button_apply		(GtkWidget		*widget,
					 gpointer		parent);
static void grab_start	 		(GtkWidget		*widget,
					 gpointer		parent);

/* ************************************************************************* */
static GtkWidget* tab_label_widget_new	(const gchar		*label,
					 GtkWidget		*parent);
static GtkWidget* color_balance_widget_new (GtkWidget		*parent);
static void notebook_color		(GtkWidget		*parent,
					 GtkWidget		*notebook);
static void notebook_geometry		(GtkWidget		*parent,
					 GtkWidget		*notebook);
static void notebook_crip_grab		(GtkWidget		*parent,
					 GtkWidget		*notebook);

/* ************************************************************************* *
 * $B%(%G%#%C%H%&%#%s%I%&$G;HMQ$9$k%m!<%+%k4X?t(B
 *    	($B%&%#%s%I%&MQ4X?t(B)
 * ************************************************************************* */

/* $B%N!<%H%V%C%/MQ$N%"%$%3%s@8@.(B ******************************************** */
static void
icon_new (GtkWidget	*parent) {
  book_open  = gdk_pixbuf_new_from_inline (-1, book_open_icon,  FALSE, NULL);
  book_close = gdk_pixbuf_new_from_inline (-1, book_close_icon, FALSE, NULL);
}

/* $B%N!<%H%V%C%/$N%Z!<%82hA|$N%;%C%H(B **************************************** */
static void
set_page_image (GtkNotebook	*notebook,
		gint		page_num,
		GdkPixbuf	*pixbuf) {
  GtkWidget	*page_widget;
  GtkWidget	*pixwid;

  page_widget = gtk_notebook_get_nth_page (notebook, page_num);
  pixwid = G_GET_WIDGET (page_widget, "tab_icon");
  gtk_image_set_from_pixbuf (GTK_IMAGE (pixwid), pixbuf);
}

/* $B%Z!<%8@Z$jBX$(;~$N%"%$%3%s$N@Z$jBX$((B ************************************ */
static void
cb_page_switch (GtkWidget		*widget,
		GtkNotebookPage 	*page,
		gint			page_num) {
  GtkNotebook	*notebook    = GTK_NOTEBOOK (widget);
  gint		old_page_num = gtk_notebook_get_current_page (notebook);

  if (page_num == old_page_num) return;
  set_page_image (notebook, page_num, book_open);
  if (old_page_num != -1) {
    set_page_image (notebook, old_page_num, book_close);
  }
}

/* $B%(%G%#%C%H%&%#%s%I%&$rJD$8$k(B ******************************************** */
static void
cb_destroy (GtkWidget	*widget,
	    GtkWidget	*parent) {
  gtk_widget_hide (edit_window);
  gtk_widget_destroy (edit_window);
  edit_window = NULL;
}

/* ************************************************************************* *
 * $B%(%G%#%C%H%&%#%s%I%&$G;HMQ$9$k%m!<%+%k4X?t(B
 *    	($B%+%i!<%P%i%s%9MQ%3!<%k%P%C%/4X?t(B)
 * ************************************************************************* */
static void
color_balance_render_mod (GtkWidget		*a,
			  GdkPixbufModifier 	*modifier,
			  gint			channel,
			  gint			br) {
  guchar		modr[256], modg[256], modb[256], mod[256];
  guchar		*ptr;
  gint			i, val, x, y;
  static GdkPixbuf	*curve = NULL;
  GdkPixbuf		*scurve;
  GdkPixmap		*pmap;
  
  if (!curve) {
    ptr = g_new (guchar, 64 * 64 * 3);
    curve = gdk_pixbuf_new_from_data (ptr, GDK_COLORSPACE_RGB, FALSE,
				      8, 64, 64, 64 * 3, 
				      gdk_pixbuf_free_buffer, NULL);
  }
  switch (channel) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_red_curve   (modifier->map, modr);
    gdk_pixbuf_get_image_green_curve (modifier->map, modg);
    gdk_pixbuf_get_image_blue_curve  (modifier->map, modb);
    for (i = 0; i < 256; i++)
      mod[i] = (unsigned char)
	(((int) modr[i] + (int) modg[i] + (int) modb[i]) / 3);
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_red_curve   (modifier->map, mod);
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_green_curve (modifier->map, mod);
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_blue_curve  (modifier->map, mod);
    break;
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      *ptr++ = 0;
      *ptr++ = 0;
      *ptr++ = 0;
    }
  }
  for (i = 0; i < 64; i++) {
    val = mod[i << 2] >> 2;
    ptr = gdk_pixbuf_get_pixels (curve) + (64 * 3 * 63) + (i * 3);
    for (y = 0; y < val; y++) {
      switch (channel) {
      case VALUE_ALL:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      case VALUE_RED:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case VALUE_GREEN:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case VALUE_BLUE:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      }
      ptr -= (64 * 3);
    }
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      if ((!(x % 8)) || (!(y % 8))) {
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
      } else {
	ptr += 3;
      }
    }
  }
  scurve = gdk_pixbuf_scale_simple (curve, 80, 80, GDK_INTERP_TILES);
  gdk_pixbuf_render_pixmap_and_mask (scurve, &pmap, NULL, 255);
  if (pmap) {
    gdk_window_set_back_pixmap (a->window, pmap, FALSE);
    gdk_pixmap_unref (pmap);
    gdk_window_clear (a->window);
    gdk_flush ();
  }
  gdk_pixbuf_unref (scurve);
}

/* $B%+%i!<%A%c!<%H%\%?%s$N99?7(B ********************************************** */
void
update_graphs (GtkWidget	*w) {
  GtkWidget	*a, *b;
  gint		n;
  gchar		buf[256];
  
  if (!w) return;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "draw_area%d", n);
    a = G_GET_WIDGET (w, buf);
    if (!a) return;
    sprintf (buf, "channel_button%d", n);
    b = G_GET_WIDGET (w, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (b))) {
      color_balance_render_mod (a, ti_get_mod (image_list), n, 255);
    } else {
      color_balance_render_mod (a, ti_get_mod (image_list), n, 63);
    }
  }
  edit_draw_preview ();
}

/* $B%+%i!<%A%c%s%M%k%\%?%s$,2!$5$l$?;~$N=hM}(B ******************************** */
static void
color_balance_channel (GtkWidget	*widget,
		       gpointer		data) {
  GdkPixbufColorModifier mod;
  GObject		*obj_gamma;
  GObject		*obj_bright;
  GObject		*obj_cont;
  GtkWidget		*b;
  gint			n;
  gchar			buf[256];

  obj_gamma  = G_GET_OBJECT (edit_window, "adj_gamma");
  obj_bright = G_GET_OBJECT (edit_window, "adj_bright");
  obj_cont   = G_GET_OBJECT (edit_window, "adj_cont");

  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
    for (n = 0; n < 4; n++) {
      sprintf (buf, "channel_button%d", n);
      b = G_GET_WIDGET (data, buf);
      if (b != widget)
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b), 0);
      else {
	switch (n) {
	case VALUE_ALL:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_RED:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->rmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_GREEN:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->gmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_BLUE:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->bmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	}
      }
    }
  }
  update_graphs (GTK_WIDGET (data));
}

/* ************************************************************************* */
static void
color_balance_gamma (GtkWidget	*widget,
		     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;

  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_bright (GtkWidget	*widget,
		      gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_cont (GtkWidget	*widget,
		    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_button_gamma (GtkWidget	*widget,
			    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GObject		*obj_gamma;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  obj_gamma = G_GET_OBJECT (edit_window, "adj_gamma");
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma), 256.0);
}

/* ************************************************************************* */
static void
color_balance_button_bright (GtkWidget	*widget,
			     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_bright;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
}

/* ************************************************************************* */
static void
color_balance_button_cont (GtkWidget	*widget,
			   gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_cont;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = G_GET_WIDGET (edit_window, buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont), 256.0);
}

/* $B%+%i!<%P%i%s%9$N%0%i%U$rI8=`CM$KLa$9(B ************************************ */
static void
color_balance_clear (void) {
  GdkPixbufColorModifier mod;
  GObject		*obj_gamma;
  GObject		*obj_bright;
  GObject		*obj_cont;

  obj_gamma  = G_GET_OBJECT (edit_window, "adj_gamma");
  obj_bright = G_GET_OBJECT (edit_window, "adj_bright");
  obj_cont   = G_GET_OBJECT (edit_window, "adj_cont");
  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod),
				 &mod);
  mod.gamma      = 256.0;
  mod.brightness = 256.0;
  mod.contrast   = 256.0;
  gdk_pixbuf_set_image_modifier (&mod,
				 ti_get_mod (image_list));
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma),  256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont),   256.0);  
}

/* $B%+%i!<%P%i%s%9$NJQ99$rE,MQ$9$k(B ****************************************** */
static void
color_balance_button_apply (GtkWidget	*widget,
			    gpointer	data) {
  GdkPixbuf		*pbuf;
  GdkPixbufModifier	*mod;
  
  pbuf = ti_get_pixbuf (image_list);
  mod  = ti_get_mod (image_list);
  if (pbuf && mod) gdk_pixbuf_apply_modifiers_to_rgb (pbuf, mod, 1);
  draw_image (image_list,
	      ti_get_width (image_list), ti_get_height (image_list));
  color_balance_clear ();
}

/* $B%*%j%8%J%k2hA|$KLa$9(B **************************************************** */
static void
color_balance_button_reset (GtkWidget	*widget,
			    gpointer	data) {
  original_image (image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
  color_balance_clear ();
}

/* ************************************************************************* *
 * $B%(%G%#%C%H%&%#%s%I%&$G;HMQ$9$k%m!<%+%k4X?t(B
 *    	($B%8%*%a%H%jMQ%3!<%k%P%C%/4X?t(B)
 * ************************************************************************* */

/* $B2hA|$NI}$NJQ99(B ********************************************************** */
static gboolean
geometry_enter_width (GtkWidget		*widget,
		      GdkEventKey	*key, 
		      gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  gint		ow, oh, nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  if (keep_aspect) {
    ow = ti_get_width  (image_list);
    oh = ti_get_height (image_list);
    spin_width  = G_GET_WIDGET (parent, "spin_size_width");
    spin_height = G_GET_WIDGET (parent, "spin_size_height");
    nw = (gint) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nh = oh * nw / ow;
    if (nh != (gint)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_height))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_height), (gfloat) nh);
    }
  }
  return TRUE;
}

/* $B2hA|$N9b$5$NJQ99(B ******************************************************** */
static gboolean
geometry_enter_height (GtkWidget	*widget,
		       GdkEventKey	*key, 
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  int		ow, oh, nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  if (keep_aspect) {
    ow = ti_get_width  (image_list);
    oh = ti_get_height (image_list);
    spin_width  = G_GET_WIDGET (parent, "spin_size_width");
    spin_height = G_GET_WIDGET (parent, "spin_size_height");
    nh = (gint) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nw = ow * nh / oh;
    if (nw != (gint)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_width))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_width), (gfloat) nw);
    }
  }
  return TRUE;
}

/* $B%"%9%Z%/%HHf$NJ];}(B ****************************************************** */
static void
geometry_keep_aspect (GtkWidget	*widget,
		      gpointer	data) {
  keep_aspect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
}

/* $B2hA|%5%$%:$NJQ99E,MQ(B **************************************************** */
static void
geometry_button_apply (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  gint		w, h;

  spin_width  = G_GET_WIDGET (parent, "spin_size_width");
  spin_height = G_GET_WIDGET (parent, "spin_size_height");
  w = (gint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (spin_width));
  h = (gint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (spin_height));

  do_backup (image_list);  
  scaling_by_size (image_list, w, h);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
  
}

/* $B2hA|%5%$%:$NJQ99(B($B%O!<%U%5%$%:(B) ****************************************** */
static void
geometry_button_half (GtkWidget	*widget,
		      gpointer	data) {
  do_backup (image_list);  
  scaling_by_scale (image_list, 0.5, 0.5);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* $B2hA|%5%$%:$NJQ99(B(-10%) ************************************************** */
static void
geometry_button_down (GtkWidget	*widget,
		      gpointer	data) {
  do_backup (image_list);
  scaling_by_scale (image_list, 0.9, 0.9);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* $B2hA|%5%$%:$NJQ99(B($B%*%j%8%J%k%5%$%:(B) ************************************** */
static void
geometry_button_reset (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;

  original_image(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));

  spin_width  = G_GET_WIDGET (parent, "spin_size_width");
  spin_height = G_GET_WIDGET (parent, "spin_size_height");
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_width),
			     (gfloat) ti_get_width (image_list));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_height),
			     (gfloat) ti_get_height (image_list));
}

/* $B2hA|%5%$%:$NJQ99(B(+10%) ************************************************** */
static void
geometry_button_up (GtkWidget	*widget,
		    gpointer	data) {
  do_backup (image_list);
  scaling_by_scale (image_list, 1.1, 1.1);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));  
}

/* $B2hA|%5%$%:$NJQ99(B($B%@%V%k%5%$%:(B) ****************************************** */
static void
geometry_button_double (GtkWidget	*widget,
			gpointer	data) {
  do_backup (image_list);  
  scaling_by_scale (image_list, 2.0, 2.0);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));  
}

/* $B2hA|$N@55,2=(B ($B:GE,CM$G@55,2=(B) ******************************************* */
static void
normal_button_best (GtkWidget	*widget,
		    gpointer	data) {
  do_backup (image_list);    
  normalize_image (image_list, -1, -1);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);  
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* $B2hA|$N@55,2=(B ($B;XDj$7$?HO0O$G@55,2=(B) ************************************* */
static void
normal_button_apply (GtkWidget	*widget,
		     gpointer	parent) {
  GtkWidget	*widget_min;
  GtkWidget	*widget_max;
  gdouble	min, max;

  /* $B2hAGCM$NHO0O(B */  
  widget_min = G_GET_WIDGET (parent, "spin_norm_min");
  widget_max = G_GET_WIDGET (parent, "spin_norm_max");
  min = (gdouble)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_min));
  max = (gdouble)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_max));
  
  /* $B;XDj$7$?HO0O$G@55,2=(B */
  do_backup (image_list);  
  normalize_image (image_list, min, max);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ************************************************************************* *
 * $B%(%G%#%C%H%&%#%s%I%&$G;HMQ$9$k%m!<%+%k4X?t(B
 *    	($B%/%m%C%W!u%0%i%VMQ%3!<%k%P%C%/4X?t(B)
 * ************************************************************************* */

/* $B%/%m%C%WNN0h$NJQ99(B $B#X(B *************************************************** */
static void
crip_change_x (GtkWidget	*widget,
	       gpointer		parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  gint		x, w;

  widget_x = G_GET_WIDGET (parent, "spin_crip_x");
  widget_w = G_GET_WIDGET (parent, "spin_crip_width");

  x = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > ti_get_width (image_list)) {
    x = ti_get_width (image_list) - w;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) x);
  }
  crip_clear_area ();
  G_SET_PARAMETER (image_window, "crip_x", x);
  crip_draw_area ();
}

/* $B%/%m%C%WNN0h$NJQ99(B $B#Y(B *************************************************** */
static void
crip_change_y (GtkWidget	*widget,
	       gpointer		parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  gint		y, h;

  widget_y = G_GET_WIDGET (parent, "spin_crip_y");
  widget_h = G_GET_WIDGET (parent, "spin_crip_height");

  y = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > ti_get_height (image_list)) {
    y = ti_get_height (image_list) - h;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) y);
  }
  crip_clear_area ();
  G_SET_PARAMETER (image_window, "crip_y", y);
  crip_draw_area ();
}

/* $B%/%m%C%WNN0h$NJQ99(B $BI}(B *************************************************** */
static void
crip_change_width (GtkWidget	*widget,
		   gpointer	parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  gint		w, x;

  widget_x = G_GET_WIDGET (parent, "spin_crip_x");
  widget_w = G_GET_WIDGET (parent, "spin_crip_width");

  x = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > ti_get_width (image_list)) {
    w = ti_get_width (image_list) - x;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) w);
  }
  crip_clear_area ();
  G_SET_PARAMETER (image_window, "crip_w", w);
  crip_draw_area ();
}

/* $B%/%m%C%WNN0h$NJQ99(B $B9b$5(B ************************************************* */
static void
crip_change_height (GtkWidget	*widget,
		    gpointer	parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  gint		y, h;

  widget_y = G_GET_WIDGET (parent, "spin_crip_y");
  widget_h = G_GET_WIDGET (parent, "spin_crip_height");  

  y = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > ti_get_height (image_list)) {
    h = ti_get_height (image_list) - y;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) h);
  }
  crip_clear_area ();
  G_SET_PARAMETER (image_window, "crip_h", h);
  crip_draw_area ();
}

/* $B%/%m%C%W$N<B9T(B ********************************************************** */
static void
crip_button_apply (GtkWidget	*widget,
		   gpointer	parent) {
  crip_do_crip ();
}

/* $B%0%i%V%b!<%I3+;O(B ******************************************************** */
static void
grab_start (GtkWidget	*widget,
	    gpointer	parent) {
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (G_GET_WIDGET (parent, "check_hide_dialog")))) {
    gtk_widget_hide (GTK_WIDGET (parent));
  }
  grab_do_grab ();
}

/* $B%9%/%j!<%s%7%g%C%H(B ****************************************************** */
static void
screenshot (GtkWidget	*widget,
	    gpointer	data) {
  TEImage	*image;
  GtkSpinButton	*spin;
  GdkPixbuf	*shot;
  gint		width, height, interval;
  
  spin = GTK_SPIN_BUTTON(data);
  interval = (gint) gtk_spin_button_get_value(spin);
  
  width  = gdk_screen_width();
  height = gdk_screen_height();
  
  sleep(interval);
  shot = gdk_pixbuf_get_from_drawable(NULL, gdk_get_default_root_window(),
				      NULL, 0, 0, 0, 0, width, height);

  image = teoeyes_image_new("screenshot", GNOME_VFS_FILE_MEMORY);
  teoeyes_image_set_memory(image, shot);
  image_list = g_list_append(image_list, image);
  image_list = g_list_last (image_list);

  /* $B2hA|$NBg$-$5$N@_Dj(B */
  gtk_window_set_title(GTK_WINDOW(image_window), "screenshot");
  image_window_set_size(image_window,
			ti_get_width(image_list),
			ti_get_height(image_list));

  /* $B2hA|%j%9%H%&%#%s%I%&$,3+$$$F$k>l9g$O%5%`%M%$%k$r99?7$9$k(B */
  if (list_window && GTK_WIDGET_VISIBLE(list_window)) {
    list_window_refresh_list(list_window);
  }
}

/* ************************************************************************* *
 * $B%(%G%#%C%H%&%#%s%I%&$N%&%#%s%I%&@8@.4X?t(B
 * ************************************************************************* */

/* ************************************************************************* */
static GtkWidget*
tab_label_widget_new (const gchar	*label,
		      GtkWidget		*parent) {
  GtkWidget	*box;
  GtkWidget	*icon;
  GtkWidget	*widget;
  
  box  = gtk_hbox_new (FALSE, 0);
  icon = gtk_image_new_from_pixbuf (book_close);

  gtk_box_pack_start (GTK_BOX (box), icon, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (icon), 5, 1);
  widget = gtk_label_new (label);
  gtk_box_pack_start (GTK_BOX (box), widget, FALSE, TRUE, 0);  

  G_SET_OBJECT(parent, label, widget);
  G_SET_OBJECT(parent, "tab_icon", icon);

  return box;
}

/* ************************************************************************* */
static GtkWidget*
color_balance_widget_new (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*sbox;
  GtkWidget	*hbox;
  GtkWidget	*frame;
  GtkWidget	*canvas;  
  GtkWidget	*widget;
  GtkWidget	*button;
  GtkObject	*obj;
  gchar		buf[256];
  gint		n;

  /* $B%\%C%/%9$N@8@.(B */
  box = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (box);
  {
    /* $B%U%l!<%`$N@8@.(B */
    frame = gtk_frame_new (NULL);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    G_SET_OBJECT(parent, "frame1_cb", frame);
    {
      /* $B%-%c%s%P%9$N@8@.(B */
      widget = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
      gtk_container_add (GTK_CONTAINER (frame), widget);
      G_SET_OBJECT(parent, "align1_cb", widget);
      {
	canvas = gtk_drawing_area_new ();
	gtk_widget_set_size_request (canvas, 160, 120);
	gtk_container_add (GTK_CONTAINER (widget), canvas);
	gtk_widget_set_events (canvas, GDK_EXPOSURE_MASK);
	G_SET_OBJECT(parent, "canvas", canvas);
      }
    }
    /* $B%\%C%/%9$N@8@.(B */
    sbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box), sbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "vbox1_cb", sbox);    
    {
      /* $B?eJ?%\%C%/%9$N@8@.(B */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "hbox1_cb", hbox);    
      {
	for (n = 0; n < 4; n++) {

	  /* $B%\%?%s$N@8@.(B */
	  button = gtk_toggle_button_new();
	  g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK (color_balance_channel),
			    (gpointer) parent);
	  sprintf (buf, "channel_button%d", n);
	  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	  G_SET_OBJECT(parent, buf, button);
	  {
	    /* $B%U%l!<%`$N@8@.(B */
	    frame = gtk_frame_new (NULL);
	    gtk_container_border_width (GTK_CONTAINER (frame), 2);
	    gtk_container_add (GTK_CONTAINER (button), frame);
	    G_SET_OBJECT(parent, "frame2_cb", frame);
	    {
	      /* $B%-%c%s%P%9$N@8@.(B */
	      widget = gtk_drawing_area_new ();
	      sprintf (buf, "draw_area%d", n);
	      gtk_widget_set_size_request (widget, 77, 77);
	      gtk_container_add (GTK_CONTAINER (frame), widget);
	      G_SET_OBJECT(parent, buf, widget);
	    }
	  }
	}
      }
      /* $B%;%Q%l!<%?$N@8@.(B */
      widget = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (sbox), widget, FALSE, FALSE, 5);
      G_SET_OBJECT(parent, "separator1_cb", widget);
       
      /* $B?eJ?%\%C%/%9$N@8@.(B */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "hbox2_cb", hbox);
      {
	/* $B%,%s%^Jd@5%&%#%8%'%C%H(B */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);      
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_gamma), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_gamma",   obj);
	G_SET_OBJECT(parent, "scale_gamma", widget);

	widget = gtk_icon_button_new_from_inline (curve_icon);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_gamma), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_OBJECT(parent, "button1_cb", widget);	
      }
      /* $B?eJ?%\%C%/%9$N@8@.(B */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      G_SET_OBJECT(parent, "hbox3_cb", hbox);
      {
	/* $B%V%i%$%H%M%9Jd@5%&%#%8%'%C%H(B */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_bright), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_bright",   obj);
	G_SET_OBJECT(parent, "scale_bright", widget);


	widget = gtk_icon_button_new_from_inline (brightness_icon);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_bright), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_OBJECT(parent, "button2_cb", widget);	
      }
      /* $B?eJ?%\%C%/%9$N@8@.(B */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      G_SET_OBJECT(parent, "hbox4_cb", hbox);
      {
	/* $B%3%s%H%i%9%HJd@5%&%#%8%'%C%H(B */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_cont), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_cont",   obj);
	G_SET_OBJECT(parent, "scale_cont", widget);

	widget = gtk_icon_button_new_from_inline (contrast_icon);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_cont), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_OBJECT(parent, "button3_cb", widget);	
      }
    }
  }
  return box;
}
 
/* $B%N!<%H%V%C%/$N%Z!<%8(B1 ($B%+%i!<%P%i%s%9(B)$B$N@8@.(B **************************** */
static void
notebook_color (GtkWidget	*parent,
		GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  gchar		*name;
  
  /* $B%\%C%/%9$N@8@.(B */
  box = gtk_hbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Color Balance"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_OBJECT(parent, "box1_2", box);    
  {
    /* $B%U%l!<%`$N@8@.(B */ 
    frame = gtk_frame_new (NULL); 
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 2); 
    G_SET_OBJECT(parent, "frame1_2", frame);    
    {
      /* $B?bD>%\%C%/%9$N@8@.(B */
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);      
      G_SET_OBJECT(parent, "vbox1_2", vbox);
    }
  }
  /* $B?bD>%\%C%/%9$X$N%Q%C%/(B */
  {
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    widget = color_balance_widget_new (parent);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "cb_widget_2", widget);    
    
    /* $B%;%Q%l!<%?$N@8@.(B */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 3);
    G_SET_OBJECT(parent, "separator1_2", widget);    

    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "hbox1_2", hbox);    
  }
  /* $B?eJ?%\%C%/%9$X$N%Q%C%/(B */
  {
    name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			    "reset.png", NULL);
    widget = gtk_icon_button_new_with_label (name, _("Reset"),
					     GTK_ICON_BUTTON_TEXT_RIGHT, 5);
    g_free(name);    

    g_signal_connect (G_OBJECT (widget), "clicked",
		      G_CALLBACK (color_balance_button_reset), NULL);
    gtk_widget_set_size_request (widget, 120, -1);
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "button1_2", widget);    
    
    widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
    g_signal_connect (G_OBJECT (widget), "clicked",
		      G_CALLBACK (color_balance_button_apply), NULL);
    gtk_widget_set_size_request (widget, 120, -1);    
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "button2_2", widget);    
  }
}
  
/* $B%N!<%H%V%C%/$N%Z!<%8(B2 ($B%8%*%a%H%j(B)$B$N@8@.(B ******************************** */
static void
notebook_geometry (GtkWidget	*parent,
		   GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;  
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkObject	*obj;
  gchar		*name;
  
  /* $B%\%C%/%9$N@8@.(B */
  box = gtk_vbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Geometry"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_OBJECT(parent, "box_2", box);
  G_SET_OBJECT(parent, "label_box_2", label_box);
  {
    /* $B%U%l!<%`$N@8@.(B */ 
    frame = gtk_frame_new (_("Size"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_OBJECT(parent, "frame1_2", frame);
    {
      /* $B?bD>%\%C%/%9$N@8@.(B */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 2);
      G_SET_OBJECT(parent, "vbox1_2", vbox1);
    }
    /* $B%;%Q%l!<%?$N@8@.(B */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    G_SET_OBJECT(parent, "separator1_2", widget);    

    /* $B%U%l!<%`$N@8@.(B */ 
    frame = gtk_frame_new (_("Normalization"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_OBJECT(parent, "frame2_2", frame);
    {
      /* $B?bD>%\%C%/%9$N@8@.(B */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
      G_SET_OBJECT(parent, "vbox2_2", vbox2);
    }
  }
  /* $B?bD>%\%C%/%9(B1$B$X$N%Q%C%-%s%0(B */
  {
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_OBJECT(parent, "hbox1_2", hbox);
    {
      gint	nw, nh;
      
      /* $B8=:_$N2hA|%5%$%:$rD4$Y$k(B */
      nw = ti_get_width  (image_list);
      nh = ti_get_height (image_list);

      /* $B%i%Y%k(B (Width)$B$N@8@.(B */
      widget = gtk_label_new (_("Width"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT(parent, "label1_2", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (nw, 1, 9999, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      g_signal_connect (G_OBJECT (widget), "key_press_event",
			G_CALLBACK (geometry_enter_width),
			(gpointer) parent);
      G_SET_OBJECT (parent, "adj_size_width", obj);
      G_SET_OBJECT(parent, "spin_size_width", widget);

      /* $B%i%Y%k(B (Height)$B$N@8@.(B */      
      widget = gtk_label_new (_("Height"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT(parent, "label2_2", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */      
      obj = gtk_adjustment_new (nh, 1, 9999, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (widget), "key_press_event",
			G_CALLBACK (geometry_enter_height),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_size_height", obj);
      G_SET_OBJECT(parent, "spin_size_height", widget);
    }
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);    
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "hbox2_2", hbox);
    {
      /* $B%A%'%C%/%\%?%s$N@8@.(B */
      widget = gtk_check_button_new_with_label (_("Keep aspect"));
      g_signal_connect (G_OBJECT (widget), "toggled",
			G_CALLBACK (geometry_keep_aspect), NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "check_aspect", widget);

      /* $B%\%?%s$N@8@.(B */
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_apply),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button1_2", widget);
    }
    /* $B?eJ?%\%?%s$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "hbox3_2", hbox);
    {
      /* $B%\%?%s$N@8@.(B (Reset) */
    name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			    "reset.png", NULL);
    widget = gtk_icon_button_new_with_label (name, _("Reset"),
					     GTK_ICON_BUTTON_TEXT_RIGHT, 5);
    g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_reset),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button_size_org", widget);

      /* $B%\%?%s$N@8@.(B (x 2) */
      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "size_double.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("x 2"),
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);      

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_double), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button_size_double", widget);

      /* $B%\%?%s$N@8@.(B (+10%) */
      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "size_up.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("+10%"),
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_up), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button_size_up", widget);

      /* $B%\%?%s$N@8@.(B (-10%) */
      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "size_down.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("-10%"),
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_down), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button_size_down", widget);

      /* $B%\%?%s$N@8@.(B (x 1/2)  */
      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "size_half.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("x 1/2"),
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);      

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_half), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button_size_half", widget);
    }    
  }
  /* $B?bD>%\%C%/%9(B2$B$X$N%Q%C%-%s%0(B */
  {
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, TRUE, TRUE, 0);
    G_SET_OBJECT(parent, "hbox4_2", hbox);    
    {
      /* $B8=:_$N2hA|$K9g$o$;$F@55,2=$NHO0O$r7hDj(B */
      gdouble	min = 0, max = 255;
    
      /* $B%i%Y%k$N@8@.(B (Min Value) */
      widget = gtk_label_new (_("Min Value"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label3_2", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (min, min, max, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_norm_min", obj);
      G_SET_OBJECT(parent, "spin_norm_min", widget);

      /* $B%i%Y%k$N@8@.(B (Max Value) */      
      widget = gtk_label_new (_("Max Value"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label4_2", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */      
      obj = gtk_adjustment_new (max, min, max, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_norm_max", obj);
      G_SET_OBJECT(parent, "spin_norm_max", widget);
    }
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
    G_SET_OBJECT(parent, "hbox5_2", hbox);    
    {
      /* $B%\%?%s$N@8@.(B (Apply) */            
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (normal_button_apply), parent);
      gtk_widget_set_size_request (widget, 120, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button2_2", widget);    

      /* $B%\%?%s$N@8@.(B (Best) */
      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "normalize.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("Best"), 
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (normal_button_best), NULL);
      gtk_widget_set_size_request (widget, 120, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button3_2", widget);    
    }
  }
}

/* $B%N!<%H%V%C%/$N%Z!<%8(B3 ($B%/%m%C%W(B&$B%0%i%V(B)$B$N@8@.(B *************************** */
static void
notebook_crip_grab (GtkWidget	*parent,
		    GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkWidget	*spin;
  GtkObject	*obj;
  gchar		*name;
    
  /* $B%\%C%/%9$N@8@.(B */
  box = gtk_vbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Cripping & Grab"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_OBJECT(parent, "box_3", box);
  G_SET_OBJECT(parent, "label_box_3", label_box);
  {
    /* $B%U%l!<%`$N@8@.(B */ 
    frame = gtk_frame_new (_("Cripping"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_OBJECT(parent, "frame_3", frame);
    {
      /* $B?bD>%\%C%/%9(B */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 2);
      G_SET_OBJECT(parent, "vbox1_3", vbox1);
    }
    /* $B%;%Q%l!<%?$N@8@.(B */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    G_SET_OBJECT(parent, "separator_3", widget);
    
    /* $B%U%l!<%`$N@8@.(B */ 
    frame = gtk_frame_new (_("Grab"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_OBJECT(parent, "frame2_3", frame);
    {
      /* $B?bD>%\%C%/%9(B */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
      G_SET_OBJECT(parent, "vbox2_3", vbox2);
    }
  }
  /* $B?bD>%\%C%/%9(B1$B$X$N%Q%C%-%s%0(B */
  {
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_OBJECT(parent, "hbox1_3", hbox);
    {
      gint	w, h;
      
      /* $B2hA|%5%$%:$N3MF@(B */
      w = ti_get_width  (image_list);
      h = ti_get_height (image_list);
      
      /* $B%i%Y%k$N@8@.(B X */
      widget = gtk_label_new (_("X"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label1_3", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_x), (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_x", obj);
      G_SET_OBJECT(parent, "spin_crip_x", widget);

      /* $B%i%Y%k$N@8@.(B Y */      
      widget = gtk_label_new (_("Y"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label2_3", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_y), (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_y", obj);
      G_SET_OBJECT(parent, "spin_crip_y", widget);
    }
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_OBJECT(parent, "hbox2_3", hbox);
    {
      gint	w, h;
      
      /* $B2hA|%5%$%:$N3MF@(B */
      w = ti_get_width  (image_list);
      h = ti_get_height (image_list);

      /* $B%i%Y%k$N@8@.(B Width */            
      widget = gtk_label_new (_("Width"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label3_3", widget);
      
      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_width),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_width", obj);
      G_SET_OBJECT(parent, "spin_crip_width", widget);

      /* $B%i%Y%k$N@8@.(B Height */                  
      widget = gtk_label_new (_("Height"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "label4_3", widget);

      /* $B%9%T%s%\%?%s$N@8@.(B */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_height),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_height", obj);
      G_SET_OBJECT(parent, "spin_crip_height", widget);
    }
    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);        
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "hbox3_3", hbox);
    {
      /* $B%\%?%s(B Apply */
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (crip_button_apply),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "button1_3", widget);
    }
  }
  /* $B?bD>%\%C%/%9(B2$B$X$N%Q%C%-%s%0(B */
  {
    /* $B%i%Y%k$N@8@.(B */
    widget = gtk_label_new (_("Left button grabs a rectanguler area,\n"
			      "Middle butotn grabs a window,\n"
			      "Right button cancels."));
    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 3);
    gtk_label_set_line_wrap (GTK_LABEL (widget), TRUE);
    G_SET_OBJECT(parent, "label5_3", widget);

    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);    
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
    G_SET_OBJECT(parent, "hbox5_3", hbox);
    {
      widget = gtk_check_button_new_with_label (_("Hide this dialog"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "check_hide_dialog", widget);

      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "grab.png", NULL);
      widget =
	gtk_icon_button_new_with_label (name, _("Grab Start"),
					GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (grab_start), (gpointer) parent);
      gtk_widget_set_size_request (widget, 180, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_OBJECT(parent, "grab_start", widget);
    }
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);    
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
    {
      widget = gtk_label_new(_("Screen Shot Interval(sec) :"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 3);

      obj = gtk_adjustment_new(1, 0, 100, 1, 10, 10);
      spin = gtk_spin_button_new(GTK_ADJUSTMENT(obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), spin, FALSE, FALSE, 3);

      name = g_build_filename(tc->icon_folder, STOCK_ICON_DIR,
			      "screenshot.png", NULL);
      widget = gtk_icon_button_new_with_label(name, _("Screen Shot"),
					      GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      g_free(name);

      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (screenshot), (gpointer) spin);
      
      gtk_widget_set_size_request (widget, 180, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 3);
    }
  }
}

/* $B%(%G%#%C%H%@%$%"%m%0$N@8@.(B ********************************************** */
GtkWidget*
edit_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*notebook;
  GtkWidget	*button;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;

  /* $B%&%#%s%I%&$N@8@.(B */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title    (GTK_WINDOW (window), _("Teoeyes Image Editor"));
  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  gtk_window_set_icon	  (GTK_WINDOW (window), teoeyes_icon);  
  g_signal_connect (G_OBJECT (window),
		    "destroy", G_CALLBACK (cb_destroy), NULL);
  g_signal_connect (G_OBJECT (window),
		    "delete_event", G_CALLBACK (cb_destroy), NULL);

  /* $B%U%l!<%`$N@8@.(B */
  widget = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER (widget), 2);
  gtk_container_add (GTK_CONTAINER (window), widget);
  G_SET_OBJECT(window, "frame", widget);
  {
    /* $B?bD>%\%C%/%9$N@8@.(B */
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (widget), vbox);
    G_SET_OBJECT(window, "vbox", vbox);
  }
  /* $B?eJ?%\%C%/%9$X$N%Q%C%-%s%0(B */
  {
    /* $B%N!<%H%V%C%/$N@8@.(B */
    notebook = gtk_notebook_new ();
    g_signal_connect (G_OBJECT (notebook),
		      "switch_page", G_CALLBACK (cb_page_switch), NULL);
    gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
    G_SET_OBJECT(window, "notebook", notebook);

    icon_new (window);
    {
      notebook_color    (window, notebook);
      notebook_geometry (window, notebook);
      notebook_crip_grab(window, notebook);
    }
    /* $B%;%Q%l!<%?$N@8@.(B */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 5);
    G_SET_OBJECT(window, "separator", widget);

    /* $B?eJ?%\%C%/%9$N@8@.(B */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);      
    G_SET_OBJECT(window, "hbox", hbox);
    {
      button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
      g_signal_connect (G_OBJECT (button),
			"clicked", G_CALLBACK (cb_destroy), window);
      gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      gtk_widget_set_size_request (button, 120, -1);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
      gtk_widget_grab_default (button);
      G_SET_OBJECT(window, "button", button);
    }
  }
  return window;
}

/* ************************************************************************* */
void
edit_draw_preview (void) {
  GtkWidget	*canvas;
  GdkWindow	*window;
  GdkPixbuf	*back, *pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  static gint	pw = 160;	/* $B%W%l%S%e!<2hA|$N:GBgI}(B */
  static gint	ph = 120;	/* $B%W%l%S%e!<2hA|$N:GBg9b$5(B */
  gint		w, h;
  
  canvas = G_GET_WIDGET (edit_window, "canvas");
  if (!canvas) return;
  window = canvas->window;
  
  if ((w = ti_get_width (image_list)) > pw ||
      (h = ti_get_height(image_list)) > ph) {
    w = pw;
    h = (w * ti_get_height (image_list)) / ti_get_width (image_list);
    if (h == 0) h = 2;
    if (h > ph) {
      h = ph;
      w = (h * ti_get_width (image_list)) / ti_get_height (image_list);
      if (w == 0) w = 2;      
    }
  }
  gtk_widget_set_size_request (canvas, w, h);

  pbuf = gdk_pixbuf_scale_simple (ti_get_pixbuf (image_list), w, h,
				  GDK_INTERP_TILES);
  gdk_pixbuf_apply_modifiers_to_rgb (pbuf, ti_get_mod (image_list), 0);
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  gdk_pixbuf_composite_color (pbuf, back, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES,
			      255, 0, 0, 8, 0xaaaaaa, 0x555555);
  /* $B%T%C%/%9%^%C%W$N@8@.(B */
  gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

  /* $B%&%#%s%I%&$X$NIA2h(B */
  gdk_window_set_back_pixmap (window, pixmap, FALSE);
  gdk_window_clear (window);
  gdk_window_shape_combine_mask (window, mask, 0, 0);
  gdk_flush ();
  
  gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (back);
  gdk_pixmap_unref (pixmap);
  if (mask) gdk_bitmap_unref (mask);
}

/* ******************************************************* End of edit.c *** */
