/* *************************************************** gnome-file-list.h *** *
 * եꥹȥå إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/03/31 16:05:36 sugaya>
 * ************************************************************************* */
#ifndef	__GNOME_FILE_LIST_H__
#define	__GNOME_FILE_LIST_H__

#include <gtk/gtk.h>
#include <libgnome/libgnome.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_TYPE_FILE_LIST (gnome_file_list_get_type())
#define GNOME_FILE_LIST(obj) (GTK_CHECK_CAST((obj), GNOME_TYPE_FILE_LIST, GnomeFileList))
#define GNOME_FILE_LIST_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_FILE_LIST, GnomeFileListClass))
#define GNOME_IS_FILE_LIST(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_FILE_LIST))
#define GNOME_IS_FILE_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_FILE_LIST))
#define GNOME_FILE_LIST_GET_CLASS(obj) (GTK_CHECK_GET_CLASS((obj), GNOME_TYPE_FILE_LIST, GnomeFileListClass))

enum {
  GNOME_FILE_LIST_FOLDER,
  GNOME_FILE_LIST_FILE,
  GNOME_FILE_LIST_PS,
  GNOME_FILE_LIST_PDF,
  GNOME_FILE_LIST_TEX,  
  GNOME_FILE_LIST_HTML,
  GNOME_FILE_LIST_PHP,  
  GNOME_FILE_LIST_C,
  GNOME_FILE_LIST_O,    
  GNOME_FILE_LIST_H,
  GNOME_FILE_LIST_MAKE,
  GNOME_FILE_LIST_JAVA,
  GNOME_FILE_LIST_EXEC,
  GNOME_FILE_LIST_BMP,
  GNOME_FILE_LIST_GIF,
  GNOME_FILE_LIST_JPEG,
  GNOME_FILE_LIST_PNG,
  GNOME_FILE_LIST_PNM,
  GNOME_FILE_LIST_SVG,
  GNOME_FILE_LIST_TEO,
  GNOME_FILE_LIST_TIFF,
  GNOME_FILE_LIST_XPM,    
  GNOME_FILE_LIST_BZ2,
  GNOME_FILE_LIST_GZ,
  GNOME_FILE_LIST_RPM,
  GNOME_FILE_LIST_TAR,  
  GNOME_FILE_LIST_MP3,
  GNOME_FILE_LIST_OGG,
  GNOME_FILE_LIST_WAV,  
  GNOME_FILE_LIST_AVI,
  GNOME_FILE_LIST_MPEG,
  GNOME_FILE_LIST_WMV,    
};
  
enum {
  GNOME_FILE_LIST_SORT_NAME,
  GNOME_FILE_LIST_SORT_TYPE
};
  
typedef struct _GnomeFileListType	GnomeFileListType;
typedef struct _GnomeFileListItem	GnomeFileListItem;    
typedef struct _GnomeFileList		GnomeFileList;
typedef struct _GnomeFileListClass	GnomeFileListClass;

struct _GnomeFileListType {
  gchar		*extension;
  gint		type;
};
  
struct _GnomeFileListItem {
  gchar		*filename;
  gint		type;
  gboolean	is_dir;
  gboolean	is_link;
};

struct _GnomeFileList {
  GnomeIconList	parent;

  gchar		*path;
  gint		sort_mode;
  gint		ntypes;
  gboolean	show_folder;
  gboolean	show_hidden;
  GList		*filter;
  GList		*pixmaps;
  GList		*types;
};

struct _GnomeFileListClass {
  GnomeIconListClass	parent_class;
};

GtkType    gnome_file_list_get_type	(void);
GtkWidget* gnome_file_list_new		(const gchar		*path,
					 guint			icon_width,
					 GtkAdjustment		*adj,
					 GtkSelectionMode	mode,
					 int			flags);
GtkWidget* gnome_file_list_new_from_file(const gchar		*path,
					 const gchar		*icon_folder,
					 guint			icon_width,
					 GtkAdjustment		*adj,
					 GtkSelectionMode	mode,
					 int			flags);
gint gnome_file_list_add_type_from_file(GnomeFileList		*filelist,
					const gchar		*icon_foler);
void	   gnome_file_list_add_type_filter(GnomeFileList	*filelist,
					   gint 		type,
					   const gchar 		*filter);
gboolean   gnome_file_list_create_list	(GnomeFileList		*filelist,
					 const gchar 		*path,
					 gboolean		reload_flag);
gchar*	   gnome_file_list_get_path 	(GnomeFileList		*filelist);
gchar*	   gnome_file_list_get_filename (GnomeFileList		*filelist);
gint       gnome_file_list_get_filetype (GnomeFileList		*filelist);
void	   gnome_file_list_set_filter	(GnomeFileList		*filelist,
					 const gchar		*filter_string);
void       gnome_file_list_set_show_folder(GnomeFileList        *filelist,
					   gboolean		show_folder);
void       gnome_file_list_set_show_hidden(GnomeFileList        *filelist,
					   gboolean		show_hidden);
gboolean   gnome_file_list_get_show_folder(GnomeFileList        *filelist);
gboolean   gnome_file_list_get_show_hidden(GnomeFileList        *filelist);  
  
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __GNOME_FILE_LIST_H__ */

/* ******************************************** End of gnome-file-list.h *** */
