/* ********************************************** gnome-vfs-extensions.h *** *
 * VFSեؿ 
 *
 * Copyright (C) 2004-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/03/03 20:54:08 sugaya>
 * ************************************************************************* */
#ifndef	__GNOME_VFS_EXTENSIONS_H__
#define	__GNOME_VFS_EXTENSIONS_H__

#include <string.h>
#include <libgnome/libgnome.h>
#include <libgnomevfs/gnome-vfs.h>

/* ************************************************************************* */
#define	DEFAULT_DIRECTORY_MODE	(GNOME_VFS_PERM_USER_ALL|GNOME_VFS_PERM_GROUP_READ|GNOME_VFS_PERM_GROUP_EXEC|GNOME_VFS_PERM_OTHER_READ|GNOME_VFS_PERM_OTHER_EXEC)

/* ************************************************************************* */
typedef enum {
  GNOME_VFS_FILE_LOCAL,
  GNOME_VFS_FILE_NETWORK,
  GNOME_VFS_FILE_MEMORY
} GnomeVFSFileLocation;

GnomeVFSFileLocation	gnome_vfs_ext_get_location (const char	*filename);
gboolean	gnome_vfs_ext_is_local_uri	(const char	*filename);
gboolean	gnome_vfs_ext_is_network_uri 	(const char	*filename);
gboolean	gnome_vfs_ext_is_local_path 	(const char	*filename);
gchar*		gnome_vfs_ext_get_uri 		(const char	*filename);
GList*		gnome_vfs_ext_ls_dir		(const char	*path);

#endif /* __GNOME_VFS_EXTENSIONS_H__ */
