/* ************************************************************* image.c *** *
 * TEImage˴ؤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/05/24 14:26:39 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include <teo.h>
#include "teo_pixel.h"
#include "teo_range.h"

/* URIƥȤե̾ڤФؿ ********************************* */
const gchar*
ti_get_filename (GList	*list) {
  const gchar	*filename = NULL;

  filename = strrchr(ti_get_uri(list), '/');
  return (filename) ? filename + 1 : ti_get_uri(list);
}

/* ꥹȤURIƥȤ˹פǡФؿ ***************** */
GList*
ti_get_list_from_uri (GList		*list,
		      const gchar	*uri) {
  GList	*work;

  for (work = g_list_first(list); work; work = g_list_next(work)) {
    if (strcmp(uri, ti_get_uri(work)) == 0) return work;
  }
  return NULL;
}

/* ꤵ줿ͥβؿ ********************************** */
GdkPixbuf*
ti_get_nth_plane (GList		*list,
		  gint		plane) {
  GdkPixbuf	*pixbuf;
  gint		row, col;
  guchar	val;
  
  if (plane >= ti_get_nchannels(list)) plane = 0;

  pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 
			   ti_get_width(list), ti_get_height(list));

  for (row = 0; row < ti_get_height(list); row++) {
    for (col = 0; col < ti_get_width(list); col++) {
      val = gdk_pixbuf_get_pixel(ti_get_pixbuf(list), col, row, plane);
      gdk_pixbuf_put_pixel(pixbuf, col, row, 0, val);
      gdk_pixbuf_put_pixel(pixbuf, col, row, 1, val);
      gdk_pixbuf_put_pixel(pixbuf, col, row, 2, val);
    }
  }
  return pixbuf;
}

/* ͤϰϤĴ٤ؿ ************************************************ */
void
ti_get_pixel_range (GList	*list,
		    gdouble	*min,
		    gdouble	*max) {
  guchar 	*data;
  gint		n, size;
  gdouble	val;
  
  if (!ti_get_original_list(list)) {

    data = gdk_pixbuf_get_pixels(ti_get_pixbuf(list));
    size = (ti_get_width(list) * ti_get_height(list) *
	    gdk_pixbuf_get_n_channels(ti_get_pixbuf(list)));
    *min = *max = (gdouble) *data;
    if (ti_get_has_alpha(list)) {
      for (n = size/4; n > 0; n--) {
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	data++;
      }
    } else {
      for (n = size; n > 0; n--) {
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
      }
    }
  } else {
    TEOIMAGE	*img = NULL;

    img = (TEOIMAGE *) g_list_nth_data(ti_get_original_list(list),
				       ti_get_frame(list));
    if (img) {
      TeoGetPixelRange(img, min, max);
    } else {
      *min = *max = -1;
    }
  }
}

/* ************************************************************************* */
double
ti_get_pixel_from_original(GList	*list,
			   gint		x,
			   gint		y,
			   gint		p) {
  TEOIMAGE	*current;

  current = (TEOIMAGE *) g_list_nth_data(ti_get_original_list(list),
					 ti_get_frame(list));
  return TeoGetAnyPixel(current, x, y, p);
  
}

/* TEImageκ *********************************************************** */
TEImage*
teoeyes_image_new (const gchar		*uri_text,
		   GnomeVFSFileLocation	location) {
  TEImage	*image = NULL;

  image = g_new0(TEImage, 1);
  if (image) {
    image->uri		= g_strdup(uri_text);
    image->location	= location;
    image->pixbuf	= NULL;
    image->pixbuf_list	= NULL;
    image->pixmap	= NULL;
    image->pixmap_list	= NULL;
    image->loader	= NULL;
    image->backup	= NULL;
    image->xoffset	= 0;
    image->yoffset	= 0;
    image->width	= 0;
    image->height	= 0;
    image->nframes	= 1;
    image->nchannels	= 3;
    image->type		= TI_PIXEL_UNSIGNED;
    image->bit		= 8;
    image->has_alpha	= FALSE;
    image->frame	= 0;
    image->channel	= -1;
    image->min		= -1;
    image->max		= -1;
    image->fp		= NULL;
    image->original_list= NULL;
    image->mod = g_new0(GdkPixbufModifier, 1);
    image->mod->mod.gamma       = 256;
    image->mod->mod.brightness  = 256;
    image->mod->mod.contrast    = 256;    
    image->mod->rmod.gamma      = 256;
    image->mod->rmod.brightness = 256;
    image->mod->rmod.contrast   = 256;    
    image->mod->gmod.gamma      = 256;
    image->mod->gmod.brightness = 256;
    image->mod->gmod.contrast   = 256;    
    image->mod->bmod.gamma      = 256;
    image->mod->bmod.brightness = 256;
    image->mod->bmod.contrast   = 256;
    image->mod->map             = NULL;
    gdk_pixbuf_calc_map_tables(image->mod);
  }
  return image;
}

/* TEImageΰ ******************************************************* */
void
teoeyes_image_free (TEImage	*image) {
  GList	*list;
  
  if (image->uri) g_free(image->uri);
  if (image->pixbuf_list) {
    g_list_foreach(image->pixbuf_list, (GFunc) gdk_pixbuf_unref, NULL);
    g_list_free(image->pixbuf_list);
    image->pixbuf_list = NULL;
    image->pixbuf      = NULL;
  }
  if (image->pixmap_list) {
    g_list_foreach(image->pixmap_list, (GFunc) gdk_pixmap_unref, NULL);
    g_list_free(image->pixmap_list);
    image->pixmap_list = NULL;
    image->pixmap      = NULL;
  }
  if (image->fp) {
    TeoCloseFile((TEOFILE *) image->fp);
    image->fp = NULL;
  }
  if (image->original_list) {
    for (list = image->original_list; list; list = g_list_next(list)) {
      TeoFreeImage((TEOIMAGE *) list->data);
    }
    g_list_free(image->original_list);
    image->original_list = NULL;
  }
  if (image->mod) {
    g_free(image->mod->map);
    g_free(image->mod);
    image->mod = NULL;
  }
  g_free(image);
}

/* ************************************************************************* */
void
teoeyes_image_set (GList	*list,
		   gint		frame) {
  TEImage	*image;
  GdkPixbuf	*pixbuf;
  GdkPixmap	*pixmap;

  if ((pixmap = g_list_nth_data(ti_get_pixmap_list(list), frame))) {
    ti_set_pixmap(list, pixmap);
    pixbuf = g_list_nth_data(ti_get_pixbuf_list(list), frame);
    ti_set_pixbuf(list, pixbuf);
  } else if ((pixbuf = g_list_nth_data(ti_get_pixbuf_list(list), frame))) {
    ti_set_pixbuf(list, pixbuf);
  }
  image = ti_get_image(list);
  if (image->backup) {
    gdk_pixbuf_unref(image->backup);
    image->backup = NULL;
  }
}

/* ************************************************************************* */
void
modify_pixbuf (GList		*list,
	       GdkPixbuf	*pixbuf) {
  TEImage	*ti;
  GList		*pixbuf_list;

  if (g_list_length(ti_get_pixbuf_list(list)) == 1) {
    pixbuf_list = ti_get_pixbuf_list(list);
  } else {
    pixbuf_list = g_list_nth(ti_get_pixbuf_list(list), ti_get_frame(list));
  }
  gdk_pixbuf_unref(pixbuf_list->data);
  pixbuf_list->data = pixbuf;
  ti = ti_get_image(list);
  ti->pixbuf = pixbuf_list->data;
  ti->width  = gdk_pixbuf_get_width(ti->pixbuf);
  ti->height = gdk_pixbuf_get_height(ti->pixbuf);  
}

/* ************************************************************************* */
void
modify_pixmap (GList	*list) {
  TEImage	*ti;
  GList		*pixmap_list;

  if (g_list_length(ti_get_pixbuf_list(list)) == 1) {
    pixmap_list = ti_get_pixmap_list(list);
  } else {
    pixmap_list = g_list_nth(ti_get_pixmap_list(list), ti_get_frame(list));
  }
  gdk_pixmap_unref(pixmap_list->data);
  pixmap_list->data = create_pixmap_data(ti_get_pixbuf(list));
  ti = ti_get_image(list);
  ti->pixmap = pixmap_list->data;
}

/* ****************************************************** End of image.c *** */
