/* ************************************************************* loope.c *** *
 * 롼(ɽɥ)˴ؤؿ
 *
 * Copyright (C) 1998-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/20 11:36:10 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "draw.h"
#include "pixel_window.h"

/* ************************************************************************* */


/* ؿ ************************************************************ */
static gint	scale_to_index 			(gint		scale);
static void	loope_scale_change 		(GtkWidget	*widget,
						 gpointer	scale);

/* 롼ڤγΨ˥塼 ************************************************** */
static GnomeUIInfo loope_uiinfo[] = {
  {
    GNOME_APP_UI_ITEM, N_("x   2"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 2, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x   4"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 4, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x   8"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 8, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  16"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 16, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  32"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 32, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  64"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 64, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x 128"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 128, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo loope_menu_uiinfo[] = {
  {
    GNOME_APP_UI_RADIOITEMS, NULL, NULL, loope_uiinfo,
    NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,
    (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

/* ************************************************************************* *
 * Хåؿ
 *
 * cb_close
 * cb_configure
 * cb_expose
 * cb_mouse_press
 * cb_mouse_motion
 * ************************************************************************* */

/* ٥ ******************************************************** */
static void
cb_close (GtkWidget	*widget,
	  gpointer	data) {
  gtk_widget_hide (widget);
}

/* ѹ٥ ****************************************************** */
static int
cb_configure (GtkWidget		*widget,
	      GdkEventConfigure	*ev) {
  gint	x, y, lx, ly, scale;

  x     = (gint) G_GET_PARAMETER(image_window, "x");
  y     = (gint) G_GET_PARAMETER(image_window, "y");
  lx    = (gint) G_GET_PARAMETER(image_window, "lx");
  ly    = (gint) G_GET_PARAMETER(image_window, "ly");
  scale = (gint) G_GET_PARAMETER(image_window, "scale");

  draw_loope_image(widget, image_list, x, y, lx, ly, scale);
  
  return TRUE;
}

/* 襤٥ ********************************************************** */
static int
cb_expose (GtkWidget		*widget,
	   GdkEventExpose	*ev) {
  gint	x, y, lx, ly, scale;
  
  x	= (gint) G_GET_PARAMETER(image_window, "x");
  y	= (gint) G_GET_PARAMETER(image_window, "y");
  lx	= (gint) G_GET_PARAMETER(image_window, "lx"); 
  ly	= (gint) G_GET_PARAMETER(image_window, "ly"); 
  scale = (gint) G_GET_PARAMETER(image_window, "scale");

  draw_loope_image(widget, image_list, x, y, lx, ly, scale);
  
  return FALSE;
}

/* ܥ󤬲줿ν ************************************************ */
static int
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*ev) {
  gint	x, y, lx, ly, ox, oy, scale;
  gint	param;
  GtkWidget	*menu;
  
  switch (ev->button) {
  case MOUSE_BUTTON_LEFT:	/* ܥ */
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
    param = LOOPE_WINDOW_SIZE / (scale * 2) - 1;
    x	  = (gint) ev->x / scale - param;
    y     = (gint) ev->y / scale - param;
    param = LOOPE_WINDOW_SIZE / 2;
    lx    = param - (1 - x) * scale; 
    ly    = param - (1 - y) * scale; 
    ox    = (gint) G_GET_PARAMETER (image_window, "x");
    oy    = (gint) G_GET_PARAMETER (image_window, "y");

    if (ox + x >= 0 && ox + x < ti_get_width  (image_list) &&
	oy + y >= 0 && oy + y < ti_get_height (image_list)) {
      draw_loope_image (widget, image_list, ox, oy, lx, ly, scale);
      pixel_window_show (image_list, ox + x, oy + y,
			 (ev->state == 1) ?
			 PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL,
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);
    }
    break;
  case MOUSE_BUTTON_CENTER:	/* ܥ */
    gtk_widget_hide (loope);
    break;
  case MOUSE_BUTTON_RIGHT:	/* ܥ */
    scale = (gint) G_GET_PARAMETER (image_window, "scale");    
    menu = gtk_menu_new();
    gnome_app_fill_menu(GTK_MENU_SHELL(menu), loope_menu_uiinfo,
			NULL, FALSE, 0);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(loope_uiinfo[scale_to_index(scale)].widget), TRUE);
    gtk_menu_popup (GTK_MENU (menu),
		    NULL, NULL, NULL, NULL, ev->button, ev->time);
    break;
  case MOUSE_WHEEL_DOWN:
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
    if (scale != 2) loope_scale_change (widget, (gpointer) (scale / 2));
    break;
  case MOUSE_WHEEL_UP:
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
    if (scale != 128) loope_scale_change (widget, (gpointer) (scale * 2));
    break;
  }
  return FALSE;
}

/* ޥưν **************************************** */
static gboolean
cb_mouse_motion (GtkWidget		*widget,
		 GdkEventMotion 	*ev) {
  gint			x, y, lx, ly, ox, oy, scale, param;
  GdkModifierType	state;
  
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
  } else {
    x	  = (gint) ev->x;
    y	  = (gint) ev->y;
    state = ev->state;
  }
  if ((state & GDK_BUTTON1_MASK) != 0) {
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
    param = LOOPE_WINDOW_SIZE  / (scale * 2) - 1;
    x	  = x / scale - param;
    y     = y / scale - param; 
    param = LOOPE_WINDOW_SIZE / 2;
    lx    = param - (1 - x) * scale; 
    ly    = param - (1 - y) * scale;
    ox	  = (gint) G_GET_PARAMETER (image_window, "x");
    oy	  = (gint) G_GET_PARAMETER (image_window, "y");

    if (ox + x >= 0 && ox + x < ti_get_width  (image_list) &&
	oy + y >= 0 && oy + y < ti_get_height (image_list)) {
      draw_loope_image (widget, image_list, ox, oy, lx, ly, scale);
      pixel_window_show (image_list, ox + x, oy + y,
			 (ev->state == 257) ?
			 PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL,
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);
    }
  }
  return FALSE;
}

/* Ψѹ ************************************************************ */
static void
loope_scale_change (GtkWidget	*widget,
		    gpointer	scale) {
  gint	lx, ly;

  /* 롼ڥѹ */
  G_SET_PARAMETER (image_window, "scale", scale);

  /* ɸη׻ */
  lx = ly = LOOPE_WINDOW_SIZE / 2 - (gint) scale;
  G_SET_PARAMETER (image_window, "lx", lx);
  G_SET_PARAMETER (image_window, "ly", ly);

  /*  */
  draw_loope_image (G_GET_WIDGET (loope, "canvas"),
		    image_list, -1, -1, lx, ly, (gint) scale);
}

/* Ψ˥塼Υǥå ******************************** */
static gint
scale_to_index (gint	scale) {
  gint	n = 0;

  while (scale != 2) {
    scale = scale >> 1;
    n++;
  }
  return n;
}

/* 祦ɥ **************************************************** */
GtkWidget*
loope_new (gchar	*title,
	   gint		w,
	   gint		h) {
  GtkWidget	*window;
  GtkWidget	*canvas;
  
  /* ɥ */  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_signal_connect(G_OBJECT(window),
		   "delete_event", G_CALLBACK(cb_close), NULL);
  g_signal_connect(G_OBJECT(window),
		   "destroy", G_CALLBACK(cb_close), NULL);
  /* ȥ */
  gtk_window_set_title(GTK_WINDOW(window), title);

  /* ɥ */
  gtk_widget_set_size_request(window, w, h);

  /* ɥꥵ */
  gtk_window_set_resizable(GTK_WINDOW(window), FALSE);

  /* ɥꥢ åȤ */
  {
    /* åȤ */
    canvas = gtk_drawing_area_new();

    /*  */
    gtk_drawing_area_size(GTK_DRAWING_AREA(canvas), w, h);

    /* ɥåȤإѥå */
    gtk_widget_show(canvas);
    gtk_container_add(GTK_CONTAINER(window), canvas);

    /* ̾Ͽ */
    G_SET_OBJECT(window, "canvas", canvas);

    /* ٥ȥϥɥ */
    gtk_widget_set_events(canvas,
			  GDK_BUTTON_PRESS_MASK |
			  GDK_POINTER_MOTION_MASK |
			  GDK_POINTER_MOTION_HINT_MASK |
			  GDK_KEY_PRESS_MASK);

    g_signal_connect(G_OBJECT(canvas),
		     "configure_event", G_CALLBACK(cb_configure), NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "expose_event", G_CALLBACK(cb_expose), NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "button_press_event", G_CALLBACK(cb_mouse_press), NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "motion_notify_event", G_CALLBACK(cb_mouse_motion), NULL);
  }
  gtk_widget_realize (window);
  gtk_window_set_icon (GTK_WINDOW (window), teoeyes_icon);
  gdk_window_set_icon_name (window->window, _("TeoEyes Loope"));

  return window;
}

/* ****************************************************** End of loope.c *** */

