/* ************************************************************** main.c *** *
 * ᥤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/21 10:02:47 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "init.h"
#include "menu_callbacks.h"
#include "parse_args.h"
#include "plugin.h"

/* ꤵ줿طʲȤ褷λ **************************** */
static void
set_wallpaper (GList	*list,
	       gint	align) {
  /* ɻ */
  set_as_wallpaper (ti_get_uri(list), align-1);

  /* β */
  teoeyes_option_free (option);
  config_free (tc);
  g_list_foreach (list, (GFunc) teoeyes_image_free, NULL); 

  /* λ */
  exit (1);
}

/* ɥΥȥ (-gץ) ************************* */
static void
set_geometry (GtkWidget	*window,
	      TEOption	*to) {
  gint	rx, ry, rw, rh, rd;
    
  if (to->geometry->width  != UNDEF_VAL && to->geometry->height != UNDEF_VAL) {
    gtk_widget_set_size_request (window,
				 to->geometry->width, to->geometry->height);
  }
  if (to->geometry->x != UNDEF_VAL && to->geometry->y != UNDEF_VAL) {
    gdk_window_get_geometry (GDK_ROOT_PARENT (), &rx, &ry, &rw, &rh, &rd);
    to->geometry->x = (to->geometry->xsign > 0) ?
      to->geometry->x :
      rw - ((to->geometry->width == UNDEF_VAL) ? 
	    ti_get_width (image_list) :
	    to->geometry->width) - to->geometry->x;
    to->geometry->y = (to->geometry->ysign > 0) ?
      to->geometry->y :
      rh - ((to->geometry->height == UNDEF_VAL) ?
	    ti_get_height (image_list) :
	    to->geometry->height) - to->geometry->y;
    gtk_widget_set_uposition (window, to->geometry->x,  to->geometry->y);
  }
}

/* ꤵ줿եƥɤ ************************************** */
static void
load_all_images (GList	*list) {
  GtkWidget		*progress_window;
  GtkWidget		*progress_bar;
  GtkWidget		*vbox;
  GtkWidget		*align;
  GtkAdjustment		*adj;
  GList			*tmplist;
  gint			count;
  gint			max;
  gint			w, h;

  count = 0;
  max = g_list_length (list);

  /* ץ쥹Сɽ */
  {
    progress_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy (GTK_WINDOW (progress_window), FALSE, FALSE, TRUE);
    gtk_window_set_title (GTK_WINDOW (progress_window),
			  _("Now loading images..."));
    gtk_container_set_border_width (GTK_CONTAINER (progress_window), 0);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
    gtk_container_add (GTK_CONTAINER (progress_window), vbox);
    gtk_widget_show (vbox);

    align = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_box_pack_start (GTK_BOX (vbox), align, FALSE, FALSE, 1);
    gtk_widget_show (align);

    adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, (float) max, 0, 0, 0);
    progress_bar = gtk_progress_bar_new_with_adjustment (adj);
    gtk_progress_set_format_string (GTK_PROGRESS (progress_bar), "%p%%");
    gtk_progress_set_show_text (GTK_PROGRESS (progress_bar), 1);
    gtk_container_add (GTK_CONTAINER (align), progress_bar);
    gtk_widget_show (progress_bar);

    gdk_window_get_size (GDK_ROOT_PARENT (), &w, &h);
    w = w / 2 - 100;
    h = h / 2;
    gtk_widget_set_usize (progress_window, 200, -1);
    gtk_widget_set_uposition (progress_window, w, h);
    gtk_widget_show (progress_window);
  }
  /* Υ */
  while (list) {
    count++;
    gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar),
			     (float) count / max);
    while (gtk_events_pending ()) gtk_main_iteration ();

    if (!teoeyes_image_load (ti_get_image (list), image_loader, 0,
			     option->create_pixmap)) {
      tmplist		= list->prev;
      tmplist->next	= NULL;
      while (list) list = g_list_remove (list, (gpointer) (list->data));
      break;
    }
    list = g_list_next (list);
  }
  gtk_widget_hide    (progress_window);
  gtk_widget_destroy (progress_window);
}

/* ᥤؿ ************************************************************** */
int
main (int	argc,
      char	**argv) {
  TEImage	*image;
  
  /*  */
  program = teoeyes_init(argc, argv);

  /* եɤ߹ */
  tc = teoeyes_config_init(program, &gconf_client, &gconf_path);

  /* ν */
  image_loader = image_loader_init(tc->loader_list);
  if (!image_loader) {
    g_printerr(_("Image loader module initialization failed.\n"));
    config_free(tc);
    exit(1);
  }
  plugin_list = teoeyes_plugin_init(tc->plugin_list);
  
  /* Υå */
  option = teoeyes_option_new(tc);
  image_list = parse_args(argc, argv, &option);
  
  /* ǡɤ߹ */
  image = (TEImage *) image_list->data;
  if (!teoeyes_image_load(image, image_loader,
			  option->frame, option->create_pixmap)) {
    g_printerr(_("Image open failed.\n"));
    config_free(tc);
    teoeyes_option_free(option);
    image_loader_close(image_loader);
    exit(1);
  }
  /* طʤؤ (--wallpaperץ) */
  if (option->wallpaper != 0) set_wallpaper(image_list, option->wallpaper);

  /* ƥɤ߹ (-lץ) */
  if (option->load_all) load_all_images (image_list->next);

  /*  */
  teoeyes_icon = teoeyes_icon_new();

  /* ɥ */
  image_window = image_window_new(ti_get_filename(image_list),
				  image->width, image->height);

  /* ɥΥȥ (-g ץ) */
  if (option->geometry) set_geometry (image_window, option);
  
  /* ᥤ롼 */
  gdk_threads_enter();
  gtk_main();
  gdk_threads_leave();
  
  return 0;
}

/* ******************************************************* End of main.c *** */
