/* **************************************************** main_menu_item.h *** *
 * ᥤ˥塼ƥ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/05 20:12:44 sugaya>
 * ************************************************************************* */

/* ************************************************************************* *
 * ᥤ˥塼Τѿ
 *
 * menu_icon
 *   file_menu_icon
 *   view_menu_icon
 *     imagecontrol_menu_icon
 *     framecontrol_menu_icon
 *     planecontrol_menu_icon
 *     size_menu_icon
 *   edit_menu_icon
 *   window_menu_icon
 *
 * menu_uiinfo
 *   file_menu_uiinfo
 *   view_menu_uiinfo
 *     imagecontrol_menu_uiinfo
 *     framecontrol_menu_uiinfo
 *     planecontrol_menu_uiinfo
 *     size_menu_uiinfo
 *   edit_menu_uiinfo
 *   window_menu_uiinfo
 * ************************************************************************* */

/* ե˥塼ƥΥե ****************************** */
static gchar	*file_menu_icon[] = {
  NULL,
  "new.png",
  "folder.png",
  "save.png",
  "saveas.png",
  "print.png",
  NULL,
  "exit.png"
};

/* ɽ˥塼ƥΥե ********************************** */
static gchar	*view_menu_icon[] = {
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,  
  NULL,
  NULL,
  "wallpaper.png"
};

/* ˥塼Υե ************************************** */
static gchar	*imagecontrol_menu_icon[] = {
  NULL,
  "2uparrow_blue.png",
  "1uparrow_blue.png",
  "1downarrow_blue.png",
  "2downarrow_blue.png",
};

/* ե졼˥塼Υե ********************************** */
static gchar	*framecontrol_menu_icon[] = {
  NULL,
  "2uparrow_orange.png",
  "1uparrow_orange.png",
  "1downarrow_orange.png",
  "2downarrow_orange.png"
};

/* ץ졼˥塼Υե ********************************** */
static gchar	*planecontrol_menu_icon[] = {
  NULL,
  NULL,
  "2uparrow_red.png",
  "1uparrow_red.png",
  "1downarrow_red.png",
  "2downarrow_red.png"
};

/* ˥塼Υե **************************************** */
static gchar	*size_menu_icon[] = {
  NULL,
  "size_double.png",
  "size_half.png",
  "size_up.png",
  "size_down.png"
};

/* Խ˥塼Υե ****************************************** */
static gchar	*edit_menu_icon[] = {
  NULL,
  "undo.png",
  NULL,
  "reset.png",
  "grayscale.png",
  "reverse.png",
  "normalize.png",
  "hflip.png",
  "vflip.png",
  "rotate90.png",
  "rotate270.png"
};

/* ɥ˥塼Υե ************************************ */
static gchar	*window_menu_icon[] = {
  NULL,
  "list.png",
  "editor.png",
  "viewer.png",
  "player.png",
  NULL,
  "assistant.png"
};

/* Խ˥塼Υե ****************************************** */
static gchar	*property_menu_icon[] = {
  NULL,
  "property.png"
};

/* Խ˥塼Υե ****************************************** */
static gchar	*help_menu_icon[] = {
  NULL,
  "about.png",
  "help.png"
};

/* ե륵֥˥塼 **************************************************** */
static TeoeyesUIInfo file_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_New"),
    NULL,
    (gpointer) cb_new, NULL, (gpointer) 1,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Open"),
    NULL,
    (gpointer) cb_open, NULL, (gpointer) 2,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_O, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Save"),
    NULL,
    (gpointer) cb_save, NULL, (gpointer) 3,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_S, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Save _as"),
    NULL,
    (gpointer) cb_saveas, NULL, (gpointer) 4,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_S, (GdkModifierType) GDK_SHIFT_MASK | GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Print"),
    NULL,
    (gpointer) cb_print, NULL, (gpointer) 5,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_SEPARATOR,    
  {
    TEOEYES_UI_ITEM, N_("_Quit"),
    NULL,
    (gpointer) cb_quit, NULL, (gpointer) 42,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_Q, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ֥֥˥塼 ************************************************ */
static TeoeyesUIInfo imagecontrol_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Top Image"),
    NULL,
    (gpointer) cb_image_top, NULL, (gpointer) 6,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_T, (GdkModifierType) GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Previous Image"),
    NULL,
    (gpointer) cb_image_prev, NULL, (gpointer) 7,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Next Image"),
    NULL,
    (gpointer) cb_image_next, NULL, (gpointer) 8,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Bottom Image"),
    NULL,
    (gpointer) cb_image_bottom, NULL, (gpointer) 9,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_B, (GdkModifierType) GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ե졼֥֥˥塼 ******************************************** */
static TeoeyesUIInfo framecontrol_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Top Frame"),
    NULL,
    (gpointer) cb_frame_top, NULL, (gpointer) 10,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_T, (GdkModifierType) GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Previous Frame"),
    NULL,
    (gpointer) cb_frame_prev, NULL, (gpointer) 11,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Next Frame"),
    NULL,
    (gpointer) cb_frame_next, NULL, (gpointer) 12,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Bottom Frame"),
    NULL,
    (gpointer) cb_frame_bottom, NULL, (gpointer) 13,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_B, (GdkModifierType) GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ץ졼֥֥˥塼 ******************************************** */
static TeoeyesUIInfo planecontrol_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_TOGGLEITEM, N_("Show Plane"),
    NULL,
    (gpointer) cb_show_plane, NULL, (gpointer) 14,
    TEOEYES_PIXMAP_NONE, NULL,
    GDK_V, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Top Plane"),
    NULL,
    (gpointer) cb_plane_top, NULL, (gpointer) 15,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_T, (GdkModifierType) GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Previous Plane"),
    NULL,
    (gpointer) cb_plane_prev, NULL, (gpointer) 16,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Next Plane"),
    NULL,
    (gpointer) cb_plane_next, NULL, (gpointer) 17,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_SHIFT_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Bottom Plane"),
    NULL,
    (gpointer) cb_plane_bottom, NULL, (gpointer) 18,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_B, (GdkModifierType) GDK_SHIFT_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ֥֥˥塼 ************************************************** */
static TeoeyesUIInfo size_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Double Size"),
    NULL,
    (gpointer) cb_size_double, NULL, (gpointer) 19,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_period, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Half Size"),
    NULL,
    (gpointer) cb_size_half, NULL, (gpointer) 20,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_comma, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Scale Up 10%"),
    NULL,
    (gpointer) cb_size_up, NULL, (gpointer) 21,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_period, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Scale Down 10%"),
    NULL,
    (gpointer) cb_size_down, NULL, (gpointer) 22,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_comma, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END  
};

/* ֥֥˥塼 ************************************************** */
static TeoeyesUIInfo wallpaper_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Centered"),
    NULL,
    (gpointer) cb_wallpaper_centered, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Tiled"),
    NULL,
    (gpointer) cb_wallpaper_tiled, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Scaled"),
    NULL,
    (gpointer) cb_wallpaper_scaled, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Str_eched"),
    NULL,
    (gpointer) cb_wallpaper_stretched, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END  
};

/* ɽ֥˥塼 ******************************************************** */
static TeoeyesUIInfo view_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_SUBTREE, N_("Image Control"),
    NULL,
    imagecontrol_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("Frame Control"),
    NULL,
    framecontrol_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("Plane Control"),
    NULL,
    planecontrol_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("Size"),
    NULL,
    size_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_SEPARATOR,
  {
    TEOEYES_UI_TOGGLEITEM, N_("Show _Menubar"),
    NULL,
    (gpointer) cb_show_menubar, NULL, (gpointer) 23,
    TEOEYES_PIXMAP_NONE, NULL,
    GDK_M, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_SEPARATOR,
  {
    TEOEYES_UI_SUBTREE, N_("Set Image as _Wallpaper"),
    NULL,
    wallpaper_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END  
};

/* Խ֥˥塼 ******************************************************** */
static TeoeyesUIInfo edit_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Undo"),
    NULL,
    (gpointer) cb_undo, NULL, (gpointer) 24,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_U, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  TEOEYESUIINFO_SEPARATOR,  
  {
    TEOEYES_UI_ITEM, N_("_Original"),
    NULL,
    (gpointer) cb_original, NULL, (gpointer) 25,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_O, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Grayscale"),
    NULL,
    (gpointer) cb_grayscale, NULL, (gpointer) 26,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_G, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Reverse"),
    NULL,
    (gpointer) cb_reverse, NULL, (gpointer) 27,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_R, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Normalize"),
    NULL,
    (gpointer) cb_normalize, NULL, (gpointer) 28,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Flip _Horizontal"),
    NULL,
    (gpointer) cb_flip_horizontal, NULL, (gpointer) 29,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_H, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Flip _Vertical"),
    NULL,
    (gpointer) cb_flip_vertical, NULL, (gpointer) 30,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_V, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Rotate 90"),
    NULL,
    (gpointer) cb_rotate_90, NULL, (gpointer) 31,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Rotate 270"),
    NULL,
    (gpointer) cb_rotate_270, NULL, (gpointer) 32,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END  
};

/* Խ֥˥塼 ******************************************************** */
static TeoeyesUIInfo window_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("Image _List Viewer"),
    NULL,
    (gpointer) cb_list_viewer, NULL, (gpointer) 33,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_L, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Image _Editor"),
    NULL,
    (gpointer) cb_image_editor, NULL, (gpointer) 34,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_E, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Thumbnail Viewer"),
    NULL,
    (gpointer) cb_thumb_viewer, NULL, (gpointer) 35,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_B, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Image _Player"),
    NULL,
    (gpointer) cb_image_player, NULL, (gpointer) 36,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_C, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_SEPARATOR,  
  {
    TEOEYES_UI_ITEM, N_("_Assistant"),
    NULL,
    (gpointer) cb_assistant, NULL, (gpointer) 37,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_A, (GdkModifierType) GDK_MOD1_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ꥵ֥˥塼 ******************************************************** */
static TeoeyesUIInfo property_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_Property"),
    NULL,
    (gpointer) cb_property, NULL, (gpointer) 39,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_F, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* إץ֥˥塼 ****************************************************** */
static TeoeyesUIInfo help_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_About"),
    NULL,
    (gpointer) cb_about, NULL, (gpointer) 40,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_A, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Help"),
    NULL,
    (gpointer) cb_help, NULL, (gpointer) 41,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_H, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

/* ݥåץåץ˥塼 **************************************************** */
static TeoeyesUIInfo menu_uiinfo[] = {
  {
    TEOEYES_UI_SUBTREE, N_("_File"),
    NULL,
    file_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_View"),
    NULL,
    view_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Edit"),
    NULL,
    edit_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("Pl_ugin"),
    NULL,
    NULL, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Window"),
    NULL,
    window_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Property"),
    NULL,
    property_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Help"),
    NULL,
    help_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END
};

/* ********************************************* End of main_menu_item.h *** */
