/* **************************************************** menu_callbacks.c *** *
 * ˥塼Хåؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/21 10:03:47 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "assistant.h"
#include "edit.h"
#include "gnome-custom-filesel.h"
#include "image_info.h"
#include "init.h"
#include "list_window.h"
#include "open.h"
#include "operation.h"
#include "print-callbacks.h"
#include "property_dialog.h"
#include "player.h"
#include "save.h"
#include "teoeyes_browser.h"

#include "logo.icon"

#define	GNOME_BACKGROUND_FILENAME "/desktop/gnome/background/picture_filename"
#define	GNOME_BACKGROUND_OPTION   "/desktop/gnome/background/picture_options"

enum {
  WALLPAPER_ALIGN_TILED,
  WALLPAPER_ALIGN_CENTERED,
  WALLPAPER_ALIGN_STRETCHED,
  WALLPAPER_ALIGN_SCALED
};

/* ƥοư **************************************************** */
void
cb_new (GtkWidget	*widget,
	gpointer	data) {
  int	pid;

  if ((pid = fork()) == 0) {
    if (execlp(PACKAGE, PACKAGE, (char *) 0) == -1) perror(PACKAGE);
  }
}

/* եΥץ ****************************************************** */
void
cb_open (GtkWidget	*widget,
	 gpointer	data) {
  GtkWidget	*dialog;

  dialog = open_dialog_new(_("Open File Selection"));
  gtk_widget_show_all(dialog);
}

/* ¸ ************************************************************** */
void
cb_save (GtkWidget	*widget,
	 gpointer	data) {
  teoeyes_save_image (ti_get_uri(image_list),
		      tc->confirm_save, tc->confirm_overwrite);
}

/* ̾¸ ******************************************************** */
void
cb_saveas (GtkWidget	*widget,
	   gpointer	data) {
  save_dialog = save_dialog_new (_("Save File Selection"));
  gtk_widget_show_all (save_dialog);
}

/* ɽ **************************************************** */
void
cb_print (GtkWidget	*widget,
	  gpointer	data) {
  print_dialog_show(GTK_WINDOW(image_window), image_list);  
}

/* Ƭβɽ ********************************************************** */
void
cb_image_top (GtkWidget	*widget,
	      gpointer	data) {
  image_list = g_list_first(image_list);
  if (!ti_get_pixbuf(image_list)) {
    teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
		       option->create_pixmap);
  }
  gtk_window_set_title(GTK_WINDOW(image_window),
		       ti_get_filename(image_list));
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* βɽ ************************************************************ */
void
cb_image_prev (GtkWidget	*widget,
	       gpointer		data) {
  if (g_list_previous(image_list)) {
    image_list = g_list_previous(image_list);
    if (!ti_get_pixbuf(image_list)) {
      teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
			 option->create_pixmap);
    }
    gtk_window_set_title(GTK_WINDOW(image_window),
			 ti_get_filename(image_list));
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* βɽ ********************************************************** */
void
cb_image_next (GtkWidget	*widget,
	       gpointer		data) {
  if (g_list_next(image_list)) {
    image_list = g_list_next(image_list);
    if (!ti_get_pixbuf(image_list)) {
      teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
			 option->create_pixmap);
    }
    gtk_window_set_title(GTK_WINDOW(image_window),
			 ti_get_filename(image_list));
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* Ǹβɽ ******************************************************** */
void
cb_image_bottom (GtkWidget	*widget,
		 gpointer	data) {
  image_list = g_list_last(image_list);
  if (!ti_get_pixbuf(image_list)) {
    teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
		       option->create_pixmap);
  }
  gtk_window_set_title(GTK_WINDOW(image_window),
		       ti_get_filename(image_list));
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* ƬΥե졼ɽ **************************************************** */
void
cb_frame_top (GtkWidget	*widget,
	      gpointer	data) {
  int frame = 0;
  
  if (ti_get_nframes(image_list) > 1) {
    if (g_list_length (ti_get_pixbuf_list (image_list)) == 1) {
      ti_set_frame(image_list, frame);
      teoeyes_image_load (ti_get_image(image_list), image_loader,
			  ti_get_frame(image_list), FALSE);
    } else {
      ti_set_frame(image_list, frame);
      teoeyes_image_set(image_list, frame);
    }
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* Υե졼ɽ ****************************************************** */
void
cb_frame_prev (GtkWidget	*widget,
	       gpointer		data) {
  int frame = 0;
  
  if (ti_get_nframes(image_list) > 1) {
    frame = ti_get_frame(image_list) - 1;
    if (frame == -1) frame = 0;
    if (g_list_length (ti_get_pixbuf_list (image_list)) == 1) {
      ti_set_frame(image_list, frame);
      teoeyes_image_load (ti_get_image(image_list), image_loader,
			  ti_get_frame(image_list), FALSE);
    } else {
      ti_set_frame(image_list, frame);
      teoeyes_image_set(image_list, frame);
    }
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* Υե졼ɽ ****************************************************** */
void
cb_frame_next (GtkWidget	*widget,
	       gpointer		data) {
  int frame = 0;
  
  if (ti_get_nframes(image_list) > 1) {
    frame = ti_get_frame(image_list) + 1;
    if (frame == ti_get_nframes(image_list)) frame -= 1;
    if (g_list_length (ti_get_pixbuf_list (image_list)) == 1) {
      ti_set_frame(image_list, frame);
      teoeyes_image_load (ti_get_image(image_list), image_loader,
			  ti_get_frame(image_list), FALSE);
    } else {
      ti_set_frame(image_list, frame);
      teoeyes_image_set(image_list, frame);
    }
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* ǸΥե졼ɽ **************************************************** */
void
cb_frame_bottom	(GtkWidget	*widget,
		 gpointer	data) {
  int frame = 0;
  
  if (ti_get_nframes(image_list) > 1) {
    frame = ti_get_nframes(image_list) - 1;
    if (g_list_length (ti_get_pixbuf_list (image_list)) == 1) {
      ti_set_frame(image_list, frame);
      teoeyes_image_load (ti_get_image(image_list), image_loader,
			  ti_get_frame(image_list), FALSE);
    } else {
      ti_set_frame(image_list, frame);
      teoeyes_image_set(image_list, frame);
    }
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* ץ졼ɽ⡼ɤ ************************************************ */
void	cb_show_plane		(GtkWidget	*widget,
				 gpointer	data) {
  if (ti_get_channel(image_list) == -1) {
    ti_set_channel(image_list, 0);
  } else {
    ti_set_channel(image_list, -1);
  }
  draw_image(image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ************************************************************************* */
void	cb_plane_top		(GtkWidget	*widget,
				 gpointer	data) {
  if (ti_get_channel(image_list) == -1) return;
  ti_set_channel(image_list, 0);
  draw_image(image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ************************************************************************* */
void	cb_plane_prev		(GtkWidget	*widget,
				 gpointer	data) {
  gint	channel;
  
  if ((channel = ti_get_channel(image_list)) == -1) return;
  if (channel > 0) ti_set_channel(image_list, channel - 1);
  draw_image(image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ************************************************************************* */
void	cb_plane_next		(GtkWidget	*widget,
				 gpointer	data) {
  gint	channel;
  
  if ((channel = ti_get_channel(image_list)) == -1) return;
  if (channel < ti_get_nchannels(image_list) - 1) {
    ti_set_channel(image_list, channel + 1);
  }
  draw_image(image_list, ti_get_width(image_list), ti_get_height(image_list));
}

void	cb_plane_bottom		(GtkWidget	*widget,
				 gpointer	data) {
  if (ti_get_channel(image_list) == -1) return;
  ti_set_channel(image_list, ti_get_nchannels(image_list) - 1);
  draw_image(image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* 2ܤ˳ ********************************************************* */
void	cb_size_double		(GtkWidget	*widget,
				 gpointer	data) {
  do_backup (image_list);
  scaling_by_scale(image_list, 2.0, 2.0);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* 1/2˽̾ ********************************************************* */
void	cb_size_half		(GtkWidget	*widget,
				 gpointer	data) {
  do_backup (image_list);
  scaling_by_scale(image_list, 0.5, 0.5);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* 10% *********************************************************** */
void	cb_size_up		(GtkWidget	*widget,
				 gpointer	data) {
  do_backup (image_list);
  scaling_by_scale(image_list, 1.1, 1.1);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* 10%̾ *********************************************************** */
void	cb_size_down		(GtkWidget	*widget,
				 gpointer	data) {
  do_backup (image_list);
  scaling_by_scale(image_list, 0.9, 0.9);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* ɻ **************************************************************** */
void
set_as_wallpaper (const gchar	*uri,
		  gint		align) {
  TeoeyesImageModule	*module;
  GConfClient		*client;
  gchar			*options = NULL;
  gchar			*filename;
    
  module = ti_get_loader(image_list);

  if (strcmp(module->info->name, "PNG") != 0 &&
      strcmp(module->info->name, "JPEG") != 0) return;
  
  if (ti_get_location(image_list) != GNOME_VFS_FILE_LOCAL) return;

  filename = g_filename_from_uri(uri, NULL, NULL);

  client = gconf_client_get_default();
  gconf_client_set_string(client, GNOME_BACKGROUND_FILENAME, filename, NULL);

  switch (align) {
  case WALLPAPER_ALIGN_TILED:
    options = "wallpaper";
    break;
  case WALLPAPER_ALIGN_CENTERED:
    options = "centered";
    break;
  case WALLPAPER_ALIGN_STRETCHED:
    options = "stretched";
    break;
  case WALLPAPER_ALIGN_SCALED:
    options = "scaled";
    break;
  }
  gconf_client_set_string (client, GNOME_BACKGROUND_OPTION, options, NULL);
  g_object_unref (G_OBJECT (client));
  g_free(filename);
}

/* ɻ(濴) **************************************************** */
void
cb_wallpaper_centered (GtkWidget	*widget,
		       gpointer		data) {
  set_as_wallpaper (ti_get_uri(image_list), WALLPAPER_ALIGN_CENTERED);
}

/* ɻ() ************************************************ */
void
cb_wallpaper_tiled (GtkWidget	*widget,
		    gpointer	data) {
  set_as_wallpaper (ti_get_uri(image_list), WALLPAPER_ALIGN_TILED);
}

/* ɻ(礷) ************************************************** */
void
cb_wallpaper_scaled (GtkWidget	*widget,
		     gpointer	data) {
  set_as_wallpaper (ti_get_uri(image_list), WALLPAPER_ALIGN_SCALED);
}

/* ɻ(Ф) ********************************************** */
void
cb_wallpaper_stretched (GtkWidget	*widget,
			gpointer	data) {
  set_as_wallpaper (ti_get_uri(image_list), WALLPAPER_ALIGN_STRETCHED);
}

/* ˥塼Сɽؤ ************************************************ */
void
cb_show_menubar (GtkWidget	*widget,
		 gpointer	data) {
  GtkWidget	*menubar;

  menubar = G_GET_WIDGET(image_window, "menubar");
  if ((gboolean) G_GET_PARAMETER(image_window, "show_menubar")) {
    gtk_widget_hide(menubar);
    G_SET_PARAMETER(image_window, "show_menubar", FALSE);
  } else {
    gtk_widget_show(menubar);
    if (!((gboolean) G_GET_PARAMETER(image_window, "scrollable"))) {
      G_SET_PARAMETER(image_window, "forcescroll", TRUE);
      image_window_set_size(image_window,
			    ti_get_width  (image_list),
			    ti_get_height (image_list));
    }
    G_SET_PARAMETER(image_window, "show_menubar", TRUE);
  }
}

/* ɥ **************************************************************** */
void
cb_undo (GtkWidget	*widget,
	 gpointer	data) {
  restore_backup (image_list);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);  
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* ꥸʥ᤹ **************************************************** */
void
cb_original (GtkWidget	*widget,
	     gpointer	data) {
  original_image(image_list);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* 쥤 ********************************************************** */
void
cb_grayscale (GtkWidget	*widget,
	      gpointer	data) {
  do_backup (image_list);    
  grayscale_image (image_list);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ͤȿž ************************************************************ */
void
cb_reverse (GtkWidget	*widget,
	    gpointer	data) {
  do_backup (image_list);    
  reverse_image(image_list);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ͤ ********************************************************** */
void
cb_normalize (GtkWidget	*widget,
	      gpointer	data) {
  do_backup (image_list);    
  normalize_image(image_list, -1, -1);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* οʿȿž ********************************************************** */
void
cb_flip_horizontal (GtkWidget	*widget,
		    gpointer	data) {
  do_backup (image_list);    
  flip_horizontal(image_list);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* οľȿž ********************************************************** */
void	cb_flip_vertical	(GtkWidget	*widget,
				 gpointer	data) {
  do_backup (image_list);    
  flip_vertical(image_list);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* 򣹣ٲž ******************************************************** */
void
cb_rotate_90 (GtkWidget	*widget,
	      gpointer	data) {
  do_backup (image_list);
  rotate_90(image_list, FALSE);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* 򣲣ٲž ****************************************************** */
void
cb_rotate_270 (GtkWidget	*widget,
	       gpointer		data) {
  do_backup (image_list);
  rotate_90(image_list, TRUE);
  image_window_set_size(image_window,
			ti_get_width(image_list), ti_get_height(image_list));
}

/* ************************************************************************* */
void	cb_list_viewer		(GtkWidget	*widget,
				 gpointer	data) {
  if (!list_window) list_window = list_window_new();
  if (!GTK_WIDGET_VISIBLE(list_window)) gtk_widget_show_all(list_window);
}

/* ************************************************************************* */
void	cb_image_editor		(GtkWidget	*widget,
				 gpointer	data) {
  GtkWidget	*button;
  
  if (!edit_window) edit_window = edit_window_new();
  if (!GTK_WIDGET_VISIBLE(edit_window)) gtk_widget_show_all(edit_window);
  button = G_GET_WIDGET(edit_window, "channel_button0");
  if (button) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (button), TRUE);
  edit_draw_preview();  
}

/* ************************************************************************* */
void	cb_thumb_viewer		(GtkWidget	*widget,
				 gpointer	data) {
  gchar		*folder;
  
  browse_window = teoeyes_browser_new (tc->icon_folder,
				       tc->thumbnail_folder,
				       tc->thumbnail_width,
				       tc->thumbnail_height);
  folder = g_get_current_dir();
  teoeyes_browser_scan_folder (TEOEYES_BROWSER(browse_window), folder);
  gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW
			    (TEOEYES_BROWSER(browse_window)->folder_tree),
			    folder);
  gtk_entry_set_text(GTK_ENTRY(TEOEYES_BROWSER(browse_window)->folder_entry),
		     folder);
  g_free(folder);
  
  gtk_widget_show (browse_window);
}

/* ץ졼ɽ ****************************************************** */
void	cb_image_player		(GtkWidget	*widget,
				 gpointer	data) {
  if (!player) player = player_new(tc->player_skin);
  if (!GTK_WIDGET_VISIBLE(player)) gtk_widget_show_all(player);
  player_sync_to_skin(player);
  update_timer = gtk_timeout_add(50, (GtkFunction) player_update_window, NULL);
}

/* ************************************************************************* */
void	cb_assistant		(GtkWidget	*widget,
				 gpointer	data) {
  AssistantSkinData	*skin;
  int			rw, rh;

  if (!assistant) assistant = assistant_new (tc->assistant_skin);

  gtk_widget_show (assistant);

  gdk_window_get_size (GDK_ROOT_PARENT (), &rw, &rh);
  skin = (AssistantSkinData *)
    gtk_object_get_data (GTK_OBJECT (assistant), "skin");
  gtk_widget_set_uposition (assistant,
			    rw - skin->width - 50, rh - skin->height - 50);
}

/* ************************************************************************* */
void	cb_image_info		(GtkWidget	*widget,
				 gpointer	data) {
  if (!info_dialog) info_dialog = info_dialog_new ();
  info_dialog_set_info (info_dialog, image_list);
  if (!GTK_WIDGET_VISIBLE (info_dialog)) gtk_widget_show_all (info_dialog);
}

/* ************************************************************************* */
void	cb_property		(GtkWidget	*widget,
				 gpointer	data) {
  if (!config_dialog) config_dialog = config_dialog_new(tc);
  if (!GTK_WIDGET_VISIBLE (config_dialog)) gtk_widget_show(config_dialog);
}

/* ƥξɽؿ ******************************** */
void
cb_about (GtkWidget	*widget,
	  gpointer	data) {
  GtkWidget		*about;
  static GdkPixbuf	*pixbuf = NULL;
  
  const gchar	*authors[]
    = {"Yasuyuki Sugaya <sugaya@suri.it.okayama-u.ac.jp>", NULL};
  const gchar	*documents[]
    = {"Yasuyuki Sugaya <sugaya@suri.it.okayama-u.ac.jp>", NULL};
  const gchar	*translator
    = "Yasuyuki Sugaya <sugaya@suri.it.okayama-u.ac.jp>";

  if (!pixbuf) {
    pixbuf = gdk_pixbuf_new_from_inline (-1, logo_pixbuf, FALSE, NULL);
  }
  about = gnome_about_new (_("Teoeyes"),
			   VERSION,
			   _("Copyright (C) 1998-2005 Yasuyuki Sugaya"),
			   _("TEO Image Viewer\n"
			     "http://www.suri.it.okayama-u.ac.jp/~sugaya/teoeyes3/"),
			   authors,
			   documents,
			   translator,
			   pixbuf);
  
  gtk_window_set_icon (GTK_WINDOW (about), teoeyes_icon);
  gtk_widget_show (about);
}

/* إɽ ************************************************************** */
void	cb_help			(GtkWidget	*widget,
				 gpointer	data) {
  gchar	*url;

  if (!html_window) html_window = html_window_new ();
  gtk_widget_set_size_request (html_window, HTML_WINDOW_W, HTML_WINDOW_H);
  if (!GTK_WIDGET_VISIBLE (html_window)) gtk_widget_show_all (html_window);
  url = g_strconcat ("file://", TEOEYES_HTML_DIR, G_DIR_SEPARATOR_S,
		     "index.html", NULL);
  assistant_set_document ((DhHtml *)
			  g_object_get_data (G_OBJECT (html_window),
					     "document"),
			  url);
  g_free (url);
}

/* λ **************************************************************** */
void
cb_quit (GtkWidget	*widget,
	 gpointer	data) {
  GList	*list;
  
  if (image_list) {
    for (list = image_list; list; list = g_list_next(list)) {
      teoeyes_image_free(ti_get_image(list));
    }
    g_list_free(image_list);
  }
  if (tc) config_free(tc);
  if (option) teoeyes_option_free(option);  
  if (image_loader) image_loader_close(image_loader);
  
  gtk_main_quit();
}

/* **************************************************** menu_callbacks.c *** */
