/* *********************************************************** message.c *** *
 * åܥå
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/05/05 16:12:11 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "message.h"

/* åɥɽ ****************************************** */
void
message_box_show (const gchar	*title,
		  const gchar	*message) {
  GtkWidget	*dialog;
  GtkWidget	*label;
  GtkWidget	*button;

  /*  */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (dialog), 3);
  {
    /* ǥեѹ */
    gtk_box_set_child_packing (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			       GTK_WIDGET (GTK_DIALOG (dialog)->action_area),
			       FALSE, FALSE, 0, GTK_PACK_END);
    gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
			     FALSE);
    gtk_container_set_border_width (GTK_CONTAINER 
				    (GTK_DIALOG (dialog)->action_area), 5);
  }
  /* å٥ */
  label = gtk_label_new (message);
  gtk_misc_set_padding (GTK_MISC (label), 10, 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);

  /* OKܥ */
  button = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_signal_connect_object (GTK_OBJECT (button),
			     "clicked", G_CALLBACK (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  /* ɽ */
  gtk_widget_show (dialog);
}

/* ************************************************************************* *
 * ǧδؤؿ
 *
 * cb_yes
 * cb_no
 * confirm_box_show
 * ************************************************************************* */

/* YESܥ󤬲줿Ȥν ******************************************* */
static void
cb_yes (GtkWidget	*widget,
       gboolean		*flag) {
  *flag = TRUE;
}

/* NOܥ󤬲줿Ȥν ******************************************** */
static void
cb_no (GtkWidget	*widget,
       gboolean		*flag) {
  *flag = FALSE;
}

/* ǧɥɽ ************************************************ */
gboolean
confirm_box_show (GtkWidget	*parent,
		  const gchar	*title,
		  const gchar	*message) {
  GtkWidget	*dialog;
  GtkWidget	*label;
  GtkWidget	*button;
  gboolean	flag = FALSE;
  
  /*  */
  dialog = gtk_dialog_new ();
  gtk_window_set_title(GTK_WINDOW (dialog), _("Confirm"));
  gtk_window_position(GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER (dialog), 5);
  gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
  {
    /* ǥեѹ */
    g_signal_connect(G_OBJECT(dialog),
		     "delete_event", G_CALLBACK (gtk_false), NULL);
    g_signal_connect(G_OBJECT(dialog),
		     "destroy", G_CALLBACK (gtk_main_quit), NULL);
    gtk_box_set_child_packing(GTK_BOX (GTK_DIALOG (dialog)->vbox),
			      GTK_WIDGET(GTK_DIALOG (dialog)->action_area),
			      FALSE, FALSE, 0, GTK_PACK_END);
    gtk_box_set_homogeneous(GTK_BOX (GTK_DIALOG (dialog)->action_area), 
			    FALSE);
    gtk_container_set_border_width(GTK_CONTAINER 
				   (GTK_DIALOG (dialog)->action_area), 5);
  }
  /* å٥ */
  label = gtk_label_new (message);
  gtk_misc_set_padding (GTK_MISC (label), 20, 20);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),  label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);
  
  /* CANCELܥ */
  button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  gtk_widget_show (button);

  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (cb_no), &flag);
  gtk_signal_connect_object (GTK_OBJECT (button),
			     "clicked", G_CALLBACK (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  /* OKܥ */
  button = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
		    FALSE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (cb_yes), &flag);
  gtk_signal_connect_object (GTK_OBJECT (button),
			     "clicked", G_CALLBACK (gtk_widget_destroy),
			     GTK_OBJECT (dialog));

  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  if (parent) {
    gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (parent));
  }
  gtk_widget_show (dialog);
  gtk_main ();

  return flag;
}

/* **************************************************** End of message.c *** */
