/* ************************************************************** save.c *** *
 * ¸
 *
 * Copyright (C) 1998-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/20 11:34:07 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "glib-fileutil-extension.h"
#include "gnome-custom-filesel.h"
#include "gnome-file-list.h"
#include "message.h"
#include "save.h"
#include <dlfcn.h>

/* ؿ ************************************************************ */
static void	cb_set_format 		(GtkWidget		*widget,
					 gchar			*extension);
static void	cb_dialog_ok		(GtkWidget		*widget,
					 GnomeCustomFileSel	*dialog);
static void	cb_dialog_cancel 	(GtkWidget		*widget,
					 GtkWidget		*dialog);
static gboolean	cb_select_item 		(GnomeFileList		*flist,
					 GdkEventButton		*ev,
					 gpointer		data);

/* եޥåȤŪꤹ ****************************************** */
static void
cb_set_format (GtkWidget	*widget,
	       gchar		*extension) {
  gchar	*ext, *ptr, *filename;
  gchar	head[1024];
  gchar name[1024];

  /* ե̾ */  
  filename = (gchar *) gtk_entry_get_text
    (GTK_ENTRY(GNOME_CUSTOM_FILESEL(save_dialog)->file_entry));
  if (!filename) return;
  
  if (strcmp (filename, "") == 0) {
    sprintf (name, ".%s", extension);
    gtk_entry_set_text(GTK_ENTRY
		       (GNOME_CUSTOM_FILESEL(save_dialog)->file_entry), name);
  } else {
    /* ĥҤγ */
    ext = strrchr (filename, '.');
    /* ĥҤ˱ƥե̾ѹ */
    if (!ext) {	/* ĥҤʤ */
      sprintf (name, "%s.%s", filename, extension);
      gtk_entry_set_text(GTK_ENTRY
			 (GNOME_CUSTOM_FILESEL(save_dialog)->file_entry),
			 name);
    } else {	/* ĥҤ */
      ptr = head;
      while (filename < ext) *ptr++ = *filename++;
      *ptr = '\0';
      sprintf (name, "%s.%s", head, extension);
      gtk_entry_set_text(GTK_ENTRY
			 (GNOME_CUSTOM_FILESEL(save_dialog)->file_entry), 
			 name);
    }
  }
}

/* OKܥ󤬲줿ν ********************************************** */
static void
cb_dialog_ok (GtkWidget			*widget,
	      GnomeCustomFileSel	*dialog) {
  gchar	*filename;
  
  /* ե̾ */
  filename = (gchar *) 
    gnome_custom_file_selection_get_filename (GNOME_CUSTOM_FILESEL(dialog));
  if (!filename || strcmp (filename, "") == 0 ||
      (g_file_test(filename, G_FILE_TEST_EXISTS) && g_dir_is(filename))) {
    return;  
  }
  /* ¸ */
  if (teoeyes_save_image(filename, tc->confirm_save, tc->confirm_overwrite)){
    gtk_widget_destroy(save_dialog);
  }
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void 
cb_dialog_cancel (GtkWidget	*widget,
		  GtkWidget	*dialog) {
  gtk_widget_destroy(dialog);
}

/* ֥륯åȤν ********************************** */
static gboolean
cb_select_item (GnomeFileList		*flist,
		GdkEventButton		*ev,
		gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    cb_dialog_ok (NULL, GNOME_CUSTOM_FILESEL (data));
  }
  return FALSE;
}

/* Υ **************************************************** */
static void
save_dialog_destroy (GtkWidget	*widget,
		     gpointer	data) { 
  gtk_widget_destroy(widget);
}

/* ¸ ************************************************ */
GtkWidget*
save_dialog_new (const gchar	*title) {
  TeoeyesImageModule	*module;
  GtkWidget		*dialog;
  GtkWidget		*packbox;
  GtkWidget		*box;
  GtkWidget		*widget;
  GtkWidget		*menu;
  GtkWidget 		*option_menu;
  GtkWidget		*item;
  GList			*list;
  gchar 		format_str[] = N_("By Extension");
  
  /*  */
  dialog = gnome_custom_file_selection_new (title, tc->icon_folder);
  gtk_window_set_icon (GTK_WINDOW (dialog), teoeyes_icon);
  g_signal_connect (G_OBJECT (dialog),
		    "destroy", G_CALLBACK (save_dialog_destroy), NULL);
  g_signal_connect (G_OBJECT (dialog),
		    "delete_event", G_CALLBACK (save_dialog_destroy), NULL);

  /* եޥå˥塼ɲ */
  packbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (GNOME_CUSTOM_FILESEL(dialog)->custom_box),
		    packbox, FALSE, FALSE, 2);
  gtk_container_set_border_width (GTK_CONTAINER (packbox), 0);  
  G_SET_OBJECT(dialog, "packbox", packbox);
  {
    widget = gtk_label_new (_("Determine File Type :"));
    gtk_box_pack_start (GTK_BOX (packbox), widget, FALSE, FALSE, 0);

    box = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (packbox), box, TRUE, TRUE, 0);
    {
      option_menu = gtk_option_menu_new ();
      gtk_box_pack_start (GTK_BOX (box), option_menu, TRUE, TRUE, 0);
      G_SET_OBJECT(dialog, "option_menu", option_menu);
      {
	menu = gtk_menu_new ();
	gtk_widget_show (menu);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	G_SET_OBJECT(dialog, "menu", menu);
	{
	  item = gtk_menu_item_new_with_label (_(format_str));
	  gtk_menu_append (GTK_MENU (menu), item);
	  G_SET_OBJECT(dialog, "item", item);

	  
	  for (list = image_loader; list; list = g_list_next(list)) {
	    module = dlsym (list->data, "module");
	    if ((module->info->flags & IMAGE_FORMAT_WRITABLE) != 0) {
	      item = gtk_menu_item_new_with_label (_(module->info->name));
	      g_signal_connect (G_OBJECT (item),
				"activate", G_CALLBACK (cb_set_format), 
				(gpointer) module->info->extensions[0]);
	      gtk_menu_append (GTK_MENU (menu), item);
	    }
	  }
	}
      }
      gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);      
    }
  }
  gtk_widget_show_all(GNOME_CUSTOM_FILESEL(dialog)->custom_box);
  
  /* ٥Ȥ */
  g_signal_connect(G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->ok_button),
		   "clicked", G_CALLBACK(cb_dialog_ok), dialog);
  g_signal_connect(G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->cancel_button),
		   "clicked", G_CALLBACK(cb_dialog_cancel), dialog);
  g_signal_connect(G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->file_list),
		   "button_press_event", G_CALLBACK(cb_select_item), dialog);
  return dialog;
}

/* ¸ ************************************************************** */
gboolean
teoeyes_save_image (const gchar	*filename,
		    gboolean	flag_confirm,
		    gboolean	flag_overwrite) {
  TeoeyesImageModule	*module;  
  gchar			*ext;
  
  if (!filename || strcmp(filename, "") == 0) return FALSE;
  
  /* ¸ǧ */
  if (flag_confirm &&
      confirm_box_show(image_window,
		       _("Confirm"),
		       _("Are you sure you want to save it ?")) == FALSE) {
    return FALSE;
  }
  /* 񤭳ǧ */
  if (g_file_test(filename, G_FILE_TEST_EXISTS) &&
      confirm_box_show(image_window,
		       _("Confirm"),
		       _("Already same filename exists.\n"
			 "Are you sure you want to overwrite it ?"))
      == FALSE) {
    return FALSE;
  }
  /* ¸ */

  /* ĥҤ */
  ext = strrchr (filename, '.');
  if (!ext || *(ext+1) == '\0') return FALSE;
  ext++;

  /* ĥҤǥ⥸塼 */
  module = teoeyesloader_select_from_extension(image_loader, filename);

  if (!module || !(module->info->flags & IMAGE_FORMAT_WRITABLE)) return FALSE;
  
  if (strcmp (module->info->name, "TEO") == 0) {
    return module->save(filename, ti_get_image(image_list));
  } else {
    return module->save(filename, ti_get_pixbuf(image_list));
  }
}


/* ******************************************************* End of save.c *** */
