/* ********************************************************* teo_pixel.c *** *
 * TEOͤηꤷʤǲͤؿ
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/04/15 17:14:34 sugaya>
 * ************************************************************************* */
#include <teo.h>

/* ************************************************************************* *
   TeoGetPixel
 * ************************************************************************* */
double
TeoGetAnyPixel (TEOIMAGE	*img,
		int 		col, 
		int 		row,
		int 		p) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    switch (TeoBit (img)) {
    case 1:
      return (double) TeoGetBit (img, col, row, p);
      break;
    case 8:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT8);
      break;
    case 16:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT16);
      break;
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_UINT32);
      break;
    }
    break;
  case (TEO_SIGNED):
    switch (TeoBit (img)) {
    case 8:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT8);
      break;
    case 16:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT16);
      break;
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_SINT32);
      break;
    }
    break;
  case (TEO_FLOAT):
    switch (TeoBit (img)) {
    case 32:
      return (double) TeoGetPixel (img, col, row, p, TEO_FLOAT32);
      break;
    case 64:
      return (double) TeoGetPixel (img, col, row, p, TEO_FLOAT64);
      break;
    }
    break;
  }
  return 0.0;
}

/* ********************************************************* teo_pixel.c *** */
