/* ********************************************************* teo_range.c *** *
 * ͤϰϤʤɤĴ٤ؿ
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/03/21 18:10:12 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>
#include "teo_range.h"

/* ************************************************************************* *
   ϰˤ뤫å (TEOFILE)
 * ************************************************************************* */
int 
TeoCheckRangeFile (TEOFILE	*teo,
		   int 		col,
		   int 		row) {
  if ((TeoYstart (teo) <= row) && (TeoYend (teo) >= row) &&
      (TeoXstart (teo) <= col) && (TeoXend (teo) >= col)) {
    return 1;
  } else {
    return 0;
  }
}

/* ************************************************************************* *
   ϰˤ뤫å (TEOIMAGE)
 * ************************************************************************* */
int 
TeoCheckRangeImage (TEOIMAGE	*teo,
		    int		col,
		    int 	row) {
  if ((TeoYstart (teo) <= row) && (TeoYend (teo) >= row) &&
      (TeoXstart (teo) <= col) && (TeoXend (teo) >= col)) {
    return 1;
  } else {
    return 0;
  }
}

/* ************************************************************************* *
   κǾͤĴ٤
 * ************************************************************************* */
void
B_TeoGetPixelRange (TEOIMAGE	*img,
		    double 	*min,
		    double 	*max) {
  TEO_BIT       pixel;
  TEO_BIT	*ptr;
  int           n;

  *min = 1;
  *max = 0;
  ptr  = (TEO_BIT *) img->data;
  
  for (n = TeoFsize (img); n > 0; n--) {
    pixel = *ptr++;
    if (*max < pixel) *max = (double) pixel;
    if (*min > pixel) *min = (double) pixel;
  }
}

/* ************************************************************************* */
void
U_TeoGetPixelRange (TEOIMAGE 	*img,
		    double 	*min,
		    double 	*max) {
  double	pixel;
  int		n, size;

  switch (TeoBit (img)) {
  case (8):
    {
      TEO_UINT8 *ptr;
      ptr  = (TEO_UINT8 *) img->data;
      size = TeoFsize (img);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  case (16):
    {
      TEO_UINT16 *ptr;
      ptr  = (TEO_UINT16 *) img->data;
      size = TeoFsize (img) / 2;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  case (32):
    {
      TEO_UINT32 *ptr;
      ptr  = (TEO_UINT32 *) img->data;
      size = TeoFsize (img) / 4;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  }
}

/* ************************************************************************* */
void
S_TeoGetPixelRange (TEOIMAGE	*img,
		    double 	*min,
		    double 	*max) {
  double	pixel;
  int		n, size;

  switch (TeoBit (img)) {
  case (8):
    {
      TEO_SINT8 *ptr;
      ptr  = (TEO_SINT8 *) img->data;
      size = TeoFsize (img);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  case (16):
    {
      TEO_SINT16 *ptr;
      ptr  = (TEO_SINT16 *) img->data;
      size = TeoFsize (img) / 2;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  case (32):
    {
      TEO_SINT32 *ptr;
      ptr  = (TEO_SINT32 *) img->data;
      size = TeoFsize (img) / 4;
      *min = *max = (double) *ptr;
      for (n = 0; n < size; n++) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  }
}

/* ************************************************************************* */
void
F_TeoGetPixelRange (TEOIMAGE	*img,
		    double 	*min,
		    double 	*max) {
  double        pixel;
  int		n, size;

  switch (TeoBit (img)) {
  case (32):
    {
      TEO_FLOAT32 *ptr;
      ptr  = (TEO_FLOAT32 *) img->data;
      size = TeoFsize (img) / 4;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  case (64):
    {
      TEO_FLOAT64 *ptr;
      ptr  = (TEO_FLOAT64 *) img->data;
      size = TeoFsize (img) / 8;
      *min = *max = (double) *ptr;
      for (n = 0; n < size; n++) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
      break;
    }
  }
}

/* ************************************************************************* */
void
TeoGetPixelRange (TEOIMAGE	*img,
		  double 	*min,
		  double 	*max) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    if (TeoBit (img) == 1)
      B_TeoGetPixelRange (img, min, max);
    else
      U_TeoGetPixelRange (img, min, max);
    break;
  case (TEO_SIGNED):
    S_TeoGetPixelRange (img, min, max);
    break;
  case (TEO_FLOAT):
    F_TeoGetPixelRange (img, min, max);
    break;
  }
}

/* ************************************************************************* *
   κǾͤĴ٤
 * ************************************************************************* */
void 
B_TeoGetPixelRangePlane (TEOIMAGE	*img,
			 int 		p,
			 double 	*min,
			 double 	*max) {
  TEO_BIT       pixel;
  int           row, col;

  *min = 1;
  *max = 0;

  for (row = TeoYstart (img); row <= TeoYend (img); row++) {
    for (col = TeoXstart (img); col <= TeoXend (img); col++) {
      pixel = TeoGetBit (img, col, row, p);
      if (*max < pixel) *max = (double) pixel;
      if (*min > pixel) *min = (double) pixel;
    }
  }
  return;
}

/* ************************************************************************* */
void
U_TeoGetPixelRangePlane (TEOIMAGE	*img, 
			 int 		p,
			 double 	*min,
			 double 	*max) {
  double	pixel;
  int		n, size, plane;

  plane = TeoPlane (img);
  switch (TeoBit (img)) {
  case (8):
    {
      TEO_UINT8 *ptr;
      ptr  = (TEO_UINT8 *) img->data + p;
      size = TeoFsize (img) / plane;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
  break;
  case (16):
    {
      TEO_UINT16 *ptr;
      ptr  = (TEO_UINT16 *) img->data + p;
      size = TeoFsize (img) / (plane * 2);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  case (32):
    {
      TEO_UINT32 *ptr;
      ptr  = (TEO_UINT32 *) img->data + p;
      size = TeoFsize (img) / (plane * 4);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  }
  return;
}

/* ************************************************************************* */
void
S_TeoGetPixelRangePlane (TEOIMAGE	*img,
			 int 		p,
			 double 	*min,
			 double 	*max) {
  double        pixel;
  int		n, size, plane;

  plane = TeoPlane (img);
  switch (TeoBit (img)) {
  case (8):
    {
      TEO_SINT8 *ptr;
      ptr  = (TEO_SINT8 *) img->data + p;
      size = TeoFsize (img) / plane;
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
  break;
  case (16):
    {
      TEO_SINT16 *ptr;
      ptr  = (TEO_SINT16 *) img->data + p;
      size = TeoFsize (img) / (plane * 2);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  case (32):
    {
      TEO_SINT32 *ptr;
      ptr  = (TEO_SINT32 *) img->data + p;
      size = TeoFsize (img) / (plane * 4);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr += plane;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  }
  return;
}

/* ************************************************************************* */
void
F_TeoGetPixelRangePlane (TEOIMAGE	*img,
			 int 		p,
			 double 	*min,
			 double 	*max) {
  double        pixel;
  int		n, size, plane;

  plane = TeoPlane (img);
  switch (TeoBit (img)) {
  case (32):
    {
      TEO_FLOAT32 *ptr;
      ptr  = (TEO_FLOAT32 *) img->data + p;
      size = TeoFsize (img) / (plane * 4);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  case (64):
    {
      TEO_FLOAT64 *ptr;
      ptr  = (TEO_FLOAT64 *) img->data + p;
      size = TeoFsize (img) / (plane * 8);
      *min = *max = (double) *ptr;
      for (n = size; n > 0; n--) {
	pixel = (double) *ptr++;
	if (pixel < *min) *min = pixel;
	if (pixel > *max) *max = pixel;
      }
    }
    break;
  }
  return;
}

/* ************************************************************************* */
void
TeoGetPixelRangePlane (TEOIMAGE	*img,
		       int 	p,
		       double	*min,
		       double 	*max) {
  switch (TeoType (img)) {
  case (TEO_UNSIGNED):
    if (TeoBit (img) == 1)
      B_TeoGetPixelRangePlane (img, p, min, max);
    else
      U_TeoGetPixelRangePlane (img, p, min, max);
    break;
  case (TEO_SIGNED):
    S_TeoGetPixelRangePlane (img, p, min, max);
    break;
  case (TEO_FLOAT):
    F_TeoGetPixelRangePlane (img, p, min, max);
    break;
  }
}

/* ********************************************************* teo_range.c *** */
