/* *********************************************************** teoeyes.h *** *
 * ƥ إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/20 11:34:53 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gnome.h>
#include "teoeyes_loader.h"

#include "gettext.h"
#include "gdk-pixbuf-extension.h"
#include "gnome-vfs-extension.h"
#include "property.h"

/* ************************************************************************* */
#define	LOOPE_WINDOW_SIZE	256
#define	HTML_WINDOW_W		640
#define	HTML_WINDOW_H		600
#define	UNDEF_VAL		-1

/* ************************************************************************* */
#define	G_SET_OBJECT(parent,name,object) \
(g_object_set_data_full(G_OBJECT((parent)), (name), g_object_ref((object)), \
(GDestroyNotify) g_object_unref))

#define G_SET_PARAMETER(parent,name,param) \
(g_object_set_data(G_OBJECT((parent)), (name), (gpointer) (param)))

#define	G_GET_OBJECT(parent,name) \
(G_OBJECT(g_object_get_data(G_OBJECT((parent)), (name))))

#define	G_GET_WIDGET(parent,name) \
(GTK_WIDGET(g_object_get_data(G_OBJECT((parent)), (name))))

#define G_GET_PARAMETER(parent,name) \
(g_object_get_data(G_OBJECT((parent)), (name)))

/* TEImage¤ *********************************************************** */
typedef struct _TEImage {
  /* Υץѥƥ */
  gchar			*uri;                                  /* ե̾ */
  gint			xoffset;                              /* Xեå */
  gint			yoffset;                              /* Yեå */
  gint			width;                                   /*  */
  gint			height;                                /* ι⤵ */
  gint			nframes;                               /* ե졼 */
  gint			nchannels;                             /* ͥ */
  guchar		type;                                  /* ͤη */
  guchar		bit;                                       /* ǥץ */
  GnomeVFSFileLocation	location;                  /* եΥ */
  gboolean		has_alpha;               /* ץ졼󤬤뤫ɤ */

  /* ǡ */
  GdkPixbuf		*pixbuf;                    /* GdkPixbufǡ */
  GdkPixbufModifier 	*mod;                                /* ǡ */
  GList			*pixbuf_list;                    /* ǡꥹ */
  GdkPixmap		*pixmap;
  GList			*pixmap_list;
  
  /* ѥ᡼ */
  gint			frame;                       /* ɽΥե졼ֹ */
  gint			channel;                     /* ɽΥֹͥ */
  gdouble		min;
  gdouble		max;
  
  /* TEOΤѿ */
  gpointer		fp;                    /* եݥ (for TEO) */
  GList			*original_list;    /* ꥸʥǡ (for TEO) */

  /*  */
  TeoeyesImageModule	*loader;                               /*  */
  
  /* ɥѥǡ */
  GdkPixbuf		*backup;                       /* Хååץǡ */

  gboolean		user_data[2];
} TEImage;

/* ************************************************************************* */
typedef enum {
  MOUSE_BUTTON_NONE,
  MOUSE_BUTTON_LEFT,
  MOUSE_BUTTON_CENTER,
  MOUSE_BUTTON_RIGHT,
  MOUSE_WHEEL_DOWN,
  MOUSE_WHEEL_UP
} MouseButtonType;

typedef enum {
  TI_PIXEL_SIGNED,
  TI_PIXEL_UNSIGNED,
  TI_PIXEL_FLOAT
} TeoeyesPixelType;

typedef enum {
  PIXEL_INFO_TYPE_CURRENT,
  PIXEL_INFO_TYPE_ORIGINAL
} PixelInfoType;

/* ȥ ********************************************************** */
typedef struct _WindowGeometry {
  gint			width;		/* ɥ */
  gint			height;		/* ɥι⤵ */
  gint			x;		/* ɥXɸ */
  gint			y;		/* ɥYɸ */
  gint			xsign;		/* Xɸδ */
  gint			ysign;		/* Yɸδ */
} WindowGeometry;

/* ץ¤ ******************************************************** */
typedef struct _TEOption {
  gboolean		load_all;	/* ɥץ */
  gboolean		normalize;	/* ץ */
  gboolean		create_pixmap;
  gint			frame;		/* ɽե졼ֹ */
  gint			wallpaper;	/* ɻ楿 */
  gdouble		min;		/* Ǿ */
  gdouble		max;		/*  */
  WindowGeometry	*geometry;	/* ȥ */
} TEOption;  

/* ************************************************************************* */
#include "image.h"
#include "image_window.h"
#include "image_loader.h"
#include "draw.h"

/* Хѿ ********************************************************** */
GnomeProgram	*program;
GList		*image_loader;
GList		*image_list;
GList		*plugin_list;
GtkWidget	*image_window;
GtkWidget	*pixel_window;
GtkWidget	*list_window;
GtkWidget	*edit_window;
GtkWidget	*browse_window;
GtkWidget	*html_window;
GtkWidget	*player;
GtkWidget	*loope;
GtkWidget	*assistant;
GtkWidget	*save_dialog;
GtkWidget	*info_dialog;
GtkWidget	*config_dialog;
GdkPixbuf	*teoeyes_icon;

/* ե˴ؤѿ */
TEConfig	*tc;
TEOption	*option;
GConfClient	*gconf_client;
gchar		*gconf_path;

/* ¾ѿ */
gint		update_timer;

/* **************************************************** End of teoeyes.h *** */
