/* *********************************************************** browser.c *** *
 * $B2hA|%V%i%&%6(B
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/12 13:50:33 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "teoeyes_menu.h"
#include "teoeyes_browser.h"
#include "menu_callbacks.h"
#include "message.h"
#include "dnd.h"
#include "open.h"
#if 0
#include "new.icon"
#include "open.icon"
#include "close.icon"
#include "exit.icon"
#include "home.icon"
#include "prof.icon"
#include "reload.icon"
#include "clean.icon"
#include "icon_list.icon"
#include "file_list.icon"
#endif
#define	STOCK_ICON_DIR		"stock"
#define	FOLDER_ICON_DIR		"folder"
#define	DIR_TREE_WIDTH		180
#define	DIR_TREE_HEIGHT		400
#define	LIST_WINDOW_WIDTH	620
#define	LIST_WINDOW_HEIGHT	400
#define	PROGRESSBAR_WIDTH	100
#ifndef	COMBO_LIST_LIMIT
#define	COMBO_LIST_LIMIT	20
#endif

enum {
  COLUMN_TERMINATOR = -1,
  COLUMN_FILENAME,
  COLUMN_FILESIZE,
  COLUMN_IMAGESIZE,
  COLUMN_UPDATETIME,
  N_COLUMN
};

enum {
  VIEW_MODE_ICON,
  VIEW_MODE_DETAIL
};

/* $B%m!<%+%k4X?t(B ************************************************************ */
static GtkWidget* component_menubar_new    (TeoeyesBrowser	*browser,
					    const gchar		*icon_folder);
static GtkWidget* component_toolbar_new    (TeoeyesBrowser	*browser);
static GtkWidget* component_folderbar_new  (TeoeyesBrowser	*browser);
static GtkWidget* component_foldertree_new (TeoeyesBrowser	*browser,
					    const gchar		*icon_folder);
static GtkWidget* component_iconview_new   (TeoeyesBrowser	*browser);
static GtkWidget* component_fileview_new   (TeoeyesBrowser	*browser);

static void       cb_close                 (GtkWidget		*widget,
					    gpointer		data);
static void       cb_show_icon_list        (GtkWidget		*widget,
					    gpointer		data);
static void       cb_show_file_list        (GtkWidget		*widget,
					    gpointer		data);
static void       cb_show_hidden_folder    (GtkWidget		*widget,
					    gpointer		data);
static void       cb_go_home               (GtkWidget		*widget,
					    gpointer		data);
static void       cb_reload                (GtkWidget		*widget,
					    gpointer		data);
static void       cb_clean                 (GtkWidget		*widget,
					    gpointer		data);
static void       cb_drag_data_get         (GtkWidget		*widget,
					    GdkDragContext	*context,
					    GtkSelectionData   *selection_data,
					    guint		info,
					    guint		time,
					    gpointer		data);
static gboolean	  cb_click_icon 	   (GtkWidget		*widget,
					    GdkEventButton	*event,
					    gpointer		data);
static void       cb_folder_changed        (GtkWidget		*widget,
					    TeoeyesBrowser	*browser);
static gboolean   cb_folder_entry_press    (GtkWidget		*widget,
					    GdkEventKey		*key,
					    TeoeyesBrowser	*browser);
static gboolean   cb_folder_select         (GtkWidget		*widget,
					    GdkEventButton	*ev,
					    TeoeyesBrowser	*browser);

static GList*     ls_image                 (const gchar		*folder);
static gchar*     create_thumbnail         (const gchar		*icon_folder,
					    const gchar		*filename,
					    gint		icon_width,
					    gint		icon_height);
static void       add_icon                 (GnomeIconList	*iconlist,
					    const gchar		*icon_folder,
					    const gchar		*filename,
					    const gchar		*label,
					    gint		icon_width,
					    gint		icon_height);
static void       add_file                 (GtkListStore	*store,
					    const gchar		*filename,
					    const gchar		*label);
static void       folder_combo_prepend     (TeoeyesBrowser	*browser,
					    const gchar		*folder);


/* $B%a%K%e!<%"%$%F%`(B ******************************************************** */
static gchar *file_menu_icon[] = {
  NULL,
  "new.png", "folder.png", "save.png", "saveas.png", NULL,
  "close.png", "exit.png"
};

static gchar *view_menu_icon[] = {
  NULL,
  "icon_list.png", "file_list.png", NULL, NULL, "reload.png", "clean.png"
};

static gchar *property_menu_icon[] = {
  NULL,
  "property.png"
};

static gchar *help_menu_icon[] = {
  NULL,
  "about.png",
  "help.png"
};

static TeoeyesUIInfo file_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_New"),
    NULL,
    (gpointer) cb_new, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_N, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Open"),
    NULL,
    (gpointer) cb_open, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_O, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Save"),
    NULL,
    (gpointer) cb_save, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_S, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Save _as"),
    NULL,
    (gpointer) cb_saveas, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_S, (GdkModifierType) GDK_SHIFT_MASK | GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_SEPARATOR,  
  {
    TEOEYES_UI_ITEM, N_("_Close"),
    NULL,
    (gpointer) cb_close, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Quit"),
    NULL,
    (gpointer) cb_quit, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_P, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

static TeoeyesUIInfo view_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("Show Icon List"),
    NULL,
    (gpointer) cb_show_icon_list, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Show File List"),
    NULL,
    (gpointer) cb_show_file_list, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_SEPARATOR,  
  {
    TEOEYES_UI_TOGGLEITEM, N_("Show Hidden Folders"),
    NULL,
    (gpointer) cb_show_hidden_folder, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Reload List"),
    NULL,
    (gpointer) cb_reload, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_R, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("Clean up Icons"),
    NULL,
    (gpointer) cb_clean, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_C, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END
};

static TeoeyesUIInfo property_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("Property"),
    NULL,
    (gpointer) cb_property, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_F, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

static TeoeyesUIInfo help_menu_uiinfo[] = {
  TEOEYESUIINFO_TEAROFF,
  {
    TEOEYES_UI_ITEM, N_("_About"),
    NULL,
    (gpointer) cb_about, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_A, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  {
    TEOEYES_UI_ITEM, N_("_Help"),
    NULL,
    (gpointer) cb_help, NULL, NULL,
    TEOEYES_PIXMAP_FILENAME, NULL,
    GDK_H, (GdkModifierType) GDK_CONTROL_MASK, NULL
  },
  TEOEYESUIINFO_END  
};

static TeoeyesUIInfo menu_uiinfo[] = {
  {
    TEOEYES_UI_SUBTREE, N_("_File"),
    NULL,
    file_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_View"),
    NULL,
    view_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Property"),
    NULL,
    property_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    TEOEYES_UI_SUBTREE, N_("_Help"),
    NULL,
    help_menu_uiinfo, NULL, NULL,
    TEOEYES_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  TEOEYESUIINFO_END
};

/* $B%&%#%8%'%C%H=i4|2=4X?t(B ************************************************** */
static void teoeyes_browser_class_init 	(TeoeyesBrowserClass	*klass);
static void teoeyes_browser_init	(TeoeyesBrowser		*browser);

static GtkWindowClass	*parent_class	    = NULL;
#if 0
static gboolean		combo_callback_flag = TRUE;
#endif

/* $B%?%$%W<hF@4X?t(B ********************************************************** */
GType
teoeyes_browser_get_type (void) {
  static GType	browser_type = 0;

  if (!browser_type) {
    static const GTypeInfo browser_info = {
      sizeof (TeoeyesBrowserClass),
      NULL,
      NULL,
      (GClassInitFunc) teoeyes_browser_class_init,
      NULL,
      NULL,
      sizeof (TeoeyesBrowser),
      0,
      (GInstanceInitFunc) teoeyes_browser_init,
      NULL
    };
    browser_type
      = g_type_register_static (GTK_TYPE_WINDOW,
				"TeoeyesBrowser", &browser_info, 0);
  }
  return browser_type;
}

/* $B%/%i%9=i4|2=4X?t(B ******************************************************** */
static void
teoeyes_browser_class_init (TeoeyesBrowserClass	*klass) {
  parent_class = gtk_type_class (teoeyes_browser_get_type());
}

/* $B%&%#%8%'%C%H=i4|2=4X?t(B ************************************************** */
static void
teoeyes_browser_init (TeoeyesBrowser	*browser) {
}

/* ************************************************************************* *
 * $B%3%s%]!<%M%s%H:n@.4X?t(B
 *
 * set_icon
 * component_menubar_new
 * component_toolbar_new
 * component_folderbar_new
 * component_foldertree_new
 * component_iconview_new
 * component_fileview_new
 * ************************************************************************* */

/* $B%a%K%e!<%"%$%3%s$N@_Dj(B ************************************************** */
static void
set_icon (TeoeyesUIInfo		uiinfo[],
	  const gchar		*icon_folder,
	  gchar			*icon_file[],
	  int			nitems) {
  int	n;
  gchar	*name;
  
  for (n = 0; n < nitems; n++) {
    if (icon_file[n]) {
      name = g_build_filename (icon_folder,
			       STOCK_ICON_DIR, icon_file[n], NULL);
      uiinfo[n].pixmap_info = name;
    }
  }
}

/* $B%a%K%e!<%P!<$N@8@.4X?t(B ************************************************** */
static GtkWidget*
component_menubar_new (TeoeyesBrowser	*browser,
		       const gchar	*icon_folder) {
  GtkWidget	*handlebox;
  GtkWidget	*menubar;
  GtkAccelGroup	*accel;

  set_icon(file_menu_uiinfo, icon_folder, file_menu_icon,
	   sizeof(file_menu_icon) / sizeof(file_menu_icon[0]));
  set_icon(view_menu_uiinfo, icon_folder, view_menu_icon,
	   sizeof(view_menu_icon) / sizeof(view_menu_icon[0]));
  set_icon(property_menu_uiinfo, icon_folder, property_menu_icon,
	   sizeof(property_menu_icon) / sizeof(property_menu_icon[0]));
  set_icon(help_menu_uiinfo, icon_folder, help_menu_icon,
	   sizeof(help_menu_icon) / sizeof(help_menu_icon[0]));
  
  handlebox = gtk_handle_box_new();
  accel     = gtk_accel_group_new();    
  menubar   = gtk_menu_bar_new();
  gtk_container_add (GTK_CONTAINER(handlebox), menubar);
  teoeyes_fill_menu (GTK_MENU_SHELL(menubar), accel, menu_uiinfo);

  return handlebox;
}

/* $B%D!<%k%P!<$N@8@.4X?t(B **************************************************** */
static GtkWidget*
component_toolbar_new (TeoeyesBrowser	*browser) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GdkPixbuf	*pixbuf;
  gchar		*name;
  
  handlebox = gtk_handle_box_new();
  toolbar   = gtk_toolbar_new();
  gtk_container_add (GTK_CONTAINER(handlebox), toolbar);
  {
    /* TeoEyes$B$N5/F0%\%?%s(B */    
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, new_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "new.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("New"), 
				_("Run TeoEyes"),
				_("Run TeoEyes"),
				icon,
				G_CALLBACK (cb_new),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B!V3+$/!W%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, open_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "folder.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("Open"), 
				_("Open a new file"),
				_("Open a new file"),
				icon,
				G_CALLBACK (cb_open),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B%V%i%&%6$rJD$8$k%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, close_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "close.png", NULL);

    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("Close"),
				_("Close the Image Browser"),
				_("Close the Image Browser"),
				icon,
				G_CALLBACK (cb_close),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B!V=*N;!W%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, exit_icon, FALSE, NULL);      
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "exit.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Exit"), 
				_("Exit TeoEyes"),
				_("Exit TeoEyes"),
				icon,
				G_CALLBACK (cb_quit),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B%;%Q%l!<%?(B */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

    /* $B%[!<%`$X0\F0%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, home_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "home.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Home"), 
				_("Go to home folder"),
				_("Go to home folder"),
				icon,
				G_CALLBACK (cb_go_home),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B%;%Q%l!<%?(B */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
      
    /* $B!V@_Dj!W%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, prof_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "property.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("Property"), 
				_("Configure TeoEyes property"),
				_("Configure TeoEyes property"),
				icon,
				G_CALLBACK (cb_property),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B%;%Q%l!<%?(B */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

    /* $B%G%#%l%/%H%j$N%j%m!<%I(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, reload_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "reload.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("Reload"),
				_("Reload the current folder"),
				_("Reload the current folder"),
				icon,
				G_CALLBACK (cb_reload),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B!V%/%j!<%s!W%\%?%s(B */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, clean_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "clean.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("Clean"), 
				_("Clean up the thumbnail files"),
				_("Clean up the thumbnail files"),
				icon,
				G_CALLBACK (cb_clean),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $B%;%Q%l!<%?(B */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

    /* $BI=<(@Z$jBX$(%\%?%s(B ($B%"%$%3%sI=<((B) */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, icon_list_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "icon_list.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,			       
				_("IconList"), 
				_("Switch view to the icon list"),
				_("Switch view to the icon list"),
				icon,
				G_CALLBACK (cb_show_icon_list),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* $BI=<(@Z$jBX$(%\%?%s(B ($B%j%9%HI=<((B) */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, file_list_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "file_list.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,
				_("FileList"), 
				_("Switch view to the file list"),
				_("Switch view to the file list"),
				icon,
				G_CALLBACK (cb_show_file_list),
				NULL);
    gdk_pixbuf_unref (pixbuf);
  }
  return handlebox;
}

/* ************************************************************************* */
static GtkWidget*
component_folderbar_new (TeoeyesBrowser	*browser) {
  GtkWidget	*handlebox;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  gchar		*label_text = _("Current Folder:");
  
  handlebox = gtk_handle_box_new();
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add (GTK_CONTAINER(handlebox), hbox);
  {
    widget = gtk_label_new (label_text);
    gtk_box_pack_start (GTK_BOX(hbox), widget, FALSE, FALSE, 2);

    browser->folder_combo = gtk_combo_box_entry_new_text();
    browser->folder_entry = GTK_BIN(browser->folder_combo)->child;
    g_signal_connect (G_OBJECT(browser->folder_combo), "changed",
		      G_CALLBACK(cb_folder_changed), browser);
    g_signal_connect (G_OBJECT(browser->folder_entry), "key_press_event",
		      G_CALLBACK(cb_folder_entry_press), browser);

    gtk_box_pack_start (GTK_BOX(hbox), browser->folder_combo, TRUE, TRUE, 0);
  }
  return handlebox;
}

/* ************************************************************************* */
static GtkWidget*
component_foldertree_new (TeoeyesBrowser	*browser,
			  const gchar		*icon_folder) {
  GtkWidget	*scrollwindow;
  gchar		*folder[5];
  gint		n;
  
  scrollwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scrollwindow),
				       GTK_SHADOW_ETCHED_IN);

  if (!icon_folder) {
    browser->folder_tree = gtk_dir_tree_view_new(G_DIR_SEPARATOR_S, FALSE);
  } else {
    folder[0] = g_build_filename(icon_folder,
				 FOLDER_ICON_DIR, "folder.png", NULL);
    folder[1] = g_build_filename(icon_folder,
				 FOLDER_ICON_DIR, "folder_open.png", NULL);
    folder[2] = g_build_filename(icon_folder,
				 FOLDER_ICON_DIR, "folder_link.png", NULL);
    folder[3] = g_build_filename(icon_folder,
				 FOLDER_ICON_DIR, "folder_link_open.png",NULL);
    folder[4] = g_build_filename(icon_folder,
				 FOLDER_ICON_DIR, "folder_dennied.png", NULL);
    browser->folder_tree
      = gtk_dir_tree_view_new_from_file (G_DIR_SEPARATOR_S, FALSE,
					 folder[0], folder[1], folder[2],
					 folder[3], folder[4]);
    for (n = 0; n < 5; n++) g_free(folder[n]);
  }
  gtk_dir_tree_view_set_headers_visible (GTK_DIR_TREE_VIEW
					 (browser->folder_tree), FALSE);
  gtk_widget_set_size_request (browser->folder_tree,
			       DIR_TREE_WIDTH, DIR_TREE_HEIGHT);
  gtk_container_add (GTK_CONTAINER(scrollwindow), browser->folder_tree);
  g_signal_connect (G_OBJECT(browser->folder_tree), "button_release_event",
		    G_CALLBACK(cb_folder_select), browser);

  return scrollwindow;
}

/* $B%"%$%3%s%S%e!<$N@8@.4X?t(B ************************************************ */
static GtkWidget*
component_iconview_new (TeoeyesBrowser	*browser) {
  GtkWidget	*scrollwindow;
  
  scrollwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scrollwindow),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrollwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_size_request (scrollwindow,
			       LIST_WINDOW_WIDTH, LIST_WINDOW_HEIGHT);

  browser->iconview = gnome_icon_list_new(browser->icon_width,
					  NULL, GNOME_ICON_LIST_STATIC_TEXT);

  g_signal_connect (G_OBJECT(browser->iconview),
		    "drag_data_get", G_CALLBACK(cb_drag_data_get), browser);
  g_signal_connect (G_OBJECT(browser->iconview),
		    "button_press_event", G_CALLBACK(cb_click_icon), NULL);
  
  return scrollwindow;
}

/* $B%U%!%$%k%S%e!<$N@8@.4X?t(B ************************************************ */
static GtkWidget*
component_fileview_new (TeoeyesBrowser	*browser) {
  GtkWidget		*scrollwindow;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;

  /* $B%9%/%m!<%k%&%#%s%I%&$N@8@.(B */
  scrollwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scrollwindow),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrollwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_size_request (scrollwindow,
			       LIST_WINDOW_WIDTH, LIST_WINDOW_HEIGHT);

  /* $B%U%!%$%k%S%e!<$N@8@.(B */
  store = gtk_list_store_new (N_COLUMN,
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_STRING);
  model = GTK_TREE_MODEL (store);
  browser->fileview = gtk_tree_view_new_with_model (model);
#if 0
  g_signal_connect (G_OBJECT (browser->fileview), "button_press_event",
		    G_CALLBACK (cb_fileview_button_press), browser);
#endif
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (browser->fileview), TRUE);
  
  /* $B%U%!%$%kL>(B */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("FileName"),
						     renderer,
						     "text",
						     COLUMN_FILENAME,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILENAME);
  gtk_tree_view_append_column (GTK_TREE_VIEW (browser->fileview), column);

  /* $B%U%!%$%k%5%$%:(B */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("FileSize"),
						     renderer,
						     "text",
						     COLUMN_FILESIZE,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILESIZE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (browser->fileview), column);

  /* $B2hA|%5%$%:(B */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("ImageSize"),
						     renderer,
						     "text",
						     COLUMN_IMAGESIZE,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_IMAGESIZE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (browser->fileview), column);
  
  /* $B99?7F|;~(B */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("UpdateTime"),
						     renderer,
						     "text",
						     COLUMN_UPDATETIME,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_UPDATETIME);
  gtk_tree_view_append_column (GTK_TREE_VIEW (browser->fileview), column);
  
  return scrollwindow;
}

/* ************************************************************************* *
 * $B2hA|%V%i%&%6$N:n@.(B
 * ************************************************************************* */
GtkWidget*
teoeyes_browser_new (const gchar	*stock_folder,
		     const gchar	*icon_folder,
		     gint		icon_width,
		     gint		icon_height) {
  TeoeyesBrowser	*browser;
  GtkWidget		*window;
  GtkWidget		*vbox;
  GtkWidget		*hbox;  
  GtkWidget		*widget;
  GtkWidget		*paned;
  
  window = gtk_widget_new (teoeyes_browser_get_type(), NULL);
  gtk_window_set_title (GTK_WINDOW (window), _("TeoEyes Image Browser"));
  gtk_container_set_border_width (GTK_CONTAINER (window), 2);
  gtk_widget_realize(window);  
  gtk_window_set_icon (GTK_WINDOW (window), teoeyes_icon);
  gdk_window_set_icon_name (GTK_WIDGET(window)->window,
			    _("TeoEyes Image Browser"));

  browser = TEOEYES_BROWSER(window);
  browser->icon_folder = g_strdup (icon_folder);
  browser->icon_width  = icon_width;
  browser->icon_height = icon_height;
  browser->folder      = NULL;
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER(browser), vbox);
  gtk_widget_show (vbox);
  
  /* $B%a%K%e!<$N@8@.(B */
  widget = component_menubar_new(browser, stock_folder);
  gtk_box_pack_start (GTK_BOX(vbox), widget, FALSE, FALSE, 0);
  gtk_widget_show_all (widget);
  
  /* $B%D!<%k%P!<$N@8@.(B */
  widget = component_toolbar_new(browser);
  gtk_box_pack_start (GTK_BOX(vbox), widget, FALSE, FALSE, 0);
  gtk_widget_show_all (widget);
  
  /* $B%U%)%k%@%P!<$N@8@.(B */
  widget = component_folderbar_new(browser);
  gtk_box_pack_start (GTK_BOX(vbox), widget, FALSE, FALSE, 0);
  gtk_widget_show_all (widget);
  
  /* $B%Q%s%&%#%s%I%&$N@8@.(B */
  paned = gtk_hpaned_new();
  gtk_box_pack_start (GTK_BOX(vbox), paned, TRUE, TRUE, 0);
  gtk_widget_show (paned);
  
  /* $B%U%)%k%@!<%D%j!<$N@8@.(B */  
  widget = component_foldertree_new(browser, stock_folder);
  gtk_paned_pack1 (GTK_PANED(paned), widget, TRUE, TRUE);
  gtk_widget_show_all (widget);
  
  widget = gtk_vbox_new(FALSE, 0);
  gtk_paned_pack2 (GTK_PANED(paned), widget, TRUE, TRUE);
  gtk_widget_show (widget);
  
  /* $B%"%$%3%s%j%9%H$N@8@.(B */
  browser->icon_window = component_iconview_new(browser);
  gtk_box_pack_start (GTK_BOX(widget), browser->icon_window, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER(browser->icon_window), browser->iconview);
  gtk_widget_show_all (browser->icon_window);
  
  /* $B%U%!%$%k%j%9%H$N@8@.(B */
  browser->file_window = component_fileview_new(browser);
  gtk_box_pack_start (GTK_BOX(widget), browser->file_window, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER(browser->file_window), browser->fileview);
  
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  
  /* $B%W%m%0%l%9%P!<$N@8@.(B */
  browser->progressbar = gtk_progress_bar_new();
  gtk_widget_set_size_request (browser->progressbar, PROGRESSBAR_WIDTH, -1);  
  gtk_box_pack_start (GTK_BOX(hbox), browser->progressbar, FALSE, FALSE, 0);  
  
  /* $B%i%Y%k$N@8@.(B */
  widget = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME(widget), GTK_SHADOW_IN);
  gtk_box_pack_start (GTK_BOX(hbox), widget, TRUE, TRUE, 0);
  {
    browser->state_label = gtk_label_new ("Now loading...");
    gtk_misc_set_alignment (GTK_MISC(browser->state_label), 0.01, 0.5);    
    gtk_container_add (GTK_CONTAINER(widget), browser->state_label);
  }
  gtk_widget_show_all (hbox);
  
  return window;
}

/* ************************************************************************* *
 * $B%3!<%k%P%C%/4X?t(B
 *
 * cb_close
 * cb_show_icon_list
 * cb_show_file_list
 * cb_show_hidden_folder
 * cb_go_home
 * cb_reload
 * cb_clean
 * cb_drag_data_get
 * cb_select_icon
 *
 * ************************************************************************* */

/* $B%V%i%&%6%&%#%8%'%C%H$rJD$8$k(B ******************************************** */
static void cb_close			(GtkWidget	*widget,
					 gpointer	data) {
  TeoeyesBrowser	*browser = TEOEYES_BROWSER(browse_window);
  
  if (browser->folder)      g_free (browser->folder);
  if (browser->icon_folder) g_free (browser->icon_folder);
  if (browser->combolist)   g_list_foreach (browser->combolist,
					    (GFunc) g_free, NULL);
  gtk_widget_destroy (browse_window);
}

/* $B%"%$%3%s%j%9%H$NI=<((B **************************************************** */
static void cb_show_icon_list		(GtkWidget	*widget,
					 gpointer	data) {
  TeoeyesBrowser	*browser = TEOEYES_BROWSER(browse_window);
  
  if (!GTK_WIDGET_VISIBLE(browser->icon_window)) {
    gtk_widget_hide (browser->file_window);
    gtk_widget_show_all (browser->icon_window);    
  }
}

/* $B%U%!%$%k%j%9%H$NI=<((B **************************************************** */
static void cb_show_file_list		(GtkWidget	*widget,
					 gpointer	data) {
  TeoeyesBrowser	*browser = TEOEYES_BROWSER(browse_window);
  
  if (!GTK_WIDGET_VISIBLE(browser->file_window)) {
    gtk_widget_hide (browser->icon_window);
    gtk_widget_show_all (browser->file_window);    
  }
}

/* $B1#$7%U%)%k%@$NI=<(@ZBX$((B ************************************************ */
static void cb_show_hidden_folder	(GtkWidget	*widget,
					 gpointer	data) {
  gboolean show_hidden;
  
  show_hidden = gtk_dir_tree_view_get_show_hidden
    GTK_DIR_TREE_VIEW((TEOEYES_BROWSER(browse_window)->folder_tree));
  gtk_dir_tree_view_set_show_hidden
    (GTK_DIR_TREE_VIEW((TEOEYES_BROWSER(browse_window)->folder_tree)),
     !show_hidden);
  gtk_dir_tree_view_refresh_tree (GTK_DIR_TREE_VIEW
				  ((TEOEYES_BROWSER
				    (browse_window)->folder_tree)));
}

/* $B%[!<%`$X$N0\F0(B ********************************************************** */
static void cb_go_home			(GtkWidget	*widget,
					 gpointer	data) {
  gchar	*utf8_path;
  
  teoeyes_browser_scan_folder(TEOEYES_BROWSER(browse_window), g_get_home_dir());
  gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW
			    (TEOEYES_BROWSER(browse_window)->folder_tree),
			    TEOEYES_BROWSER(browse_window)->folder);
  utf8_path = g_filename_to_utf8(g_get_home_dir(), -1, NULL, NULL, NULL);
  gtk_entry_set_text(GTK_ENTRY(TEOEYES_BROWSER(browse_window)->folder_entry),
		     utf8_path);
  g_free(utf8_path);
}

/* $B%U%)%k%@$N%j%m!<%I(B ****************************************************** */
static void cb_reload			(GtkWidget	*widget,
					 gpointer	data) {
  teoeyes_browser_scan_folder (TEOEYES_BROWSER(browse_window), NULL);
}

/* $B%5%`%M%$%k$N:o=|(B ******************************************************** */
static void cb_clean			(GtkWidget	*widget,
					 gpointer	data) {
  gchar	*msg;

  msg = g_strconcat (_("Are you sure you want to remove"), " ",
		     TEOEYES_BROWSER(browse_window)->icon_folder, NULL);
  if (confirm_box_show (image_window, _("Confirm"), msg) == FALSE) {
    g_free (msg);
    return;
  }
  g_dir_remove (TEOEYES_BROWSER(browse_window)->icon_folder);
  g_free (msg);
}

/* ************************************************************************* */
static void
cb_drag_data_get (GtkWidget		*widget,
		  GdkDragContext	*context,
		  GtkSelectionData	*selection_data,
		  guint			info,
		  guint			time,
		  gpointer		data) {
#if 0
  GList	*selection = NULL;
  gchar	*url, *filename;
  gchar	*src_ptr, *dst_ptr;
  gchar	header[] = "file:\r\n\0";
  gint	n;

  selection = gnome_icon_list_get_selection (GNOME_ICON_LIST(widget));
  if (!selection) return;
  filename = (gchar *)
    gnome_icon_list_get_icon_data (GNOME_ICON_LIST(widget),
				   (gint) selection->data);
  url = g_new (gchar, strlen (filename) + 8);
  src_ptr = filename;
  dst_ptr = url;

  for (n = 0; n < 5; n++) *dst_ptr++ = header[n];
  for (n = 0; n < strlen (filename); n++) *dst_ptr++ = *src_ptr++;
  for (n = 5; n < 8; n++) *dst_ptr++ = header[n];

  gtk_selection_data_set (selection_data, selection_data->target, 8,
			  (gchar *) url, strlen (url) + 1);
  g_free (url);
#endif
}

/* ************************************************************************* */
static gboolean
cb_click_icon (GtkWidget	*widget,
		GdkEventButton	*event,
		gpointer	data) {
  GList	*selection;
  gchar	*filename;
  gint	pos;

  if (event->type == GDK_2BUTTON_PRESS) {  
    selection = gnome_icon_list_get_selection(GNOME_ICON_LIST(widget));
    if (selection) {
      pos = (gint) selection->data;
      filename = (gchar *) 
	gnome_icon_list_get_icon_data (GNOME_ICON_LIST(widget), pos);
      if (event->state == 4) {
	teoeyes_open_image_on_new_window (filename);
      } else {
	teoeyes_open_image_on_same_window (filename);
      }
    }
  }
  return FALSE;
}

/* ************************************************************************* */
static void
cb_folder_changed (GtkWidget		*widget,
		   TeoeyesBrowser	*browser) {
  gchar	*folder;

  folder =
    g_filename_from_utf8(gtk_entry_get_text(GTK_ENTRY(browser->folder_entry)),
			 -1, NULL, NULL, NULL);
  if (folder && strcmp (folder, "") != 0) {
    teoeyes_browser_scan_folder (browser, folder);
    gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(browser->folder_tree), folder);
    g_free(folder);
  }			    
}

/* $B%U%)%k%@%3%s%\%(%s%H%j$N%3!<%k%P%C%/4X?t(B ********************************* */
static gboolean
cb_folder_entry_press (GtkWidget	*widget,
		       GdkEventKey	*key,
		       TeoeyesBrowser	*browser) {
  gchar	*folder;
  
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  folder = g_filename_from_utf8(gtk_entry_get_text(GTK_ENTRY(widget)),
				-1, NULL, NULL, NULL);
  if (!g_dir_is(folder)) {
    g_free(folder);
    return FALSE;
  }
  teoeyes_browser_scan_folder (browser, folder);
  gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(browser->folder_tree), folder);
  
  g_free(folder);

  return FALSE;
}

/* $B%U%)%k%@%D%j!<$N%3!<%k%P%C%/4X?t(B ***************************************** */
static gboolean
cb_folder_select (GtkWidget		*widget,
		  GdkEventButton	*ev,
		  TeoeyesBrowser	*browser) {
  gchar		*path, *utf8_path = NULL;
  
  /* $BA*Br$7$?%U%)%k%@%Q%9$N<hF@(B */
  path = gtk_dir_tree_view_get_selected_path(GTK_DIR_TREE_VIEW(widget));
  if (path) utf8_path = g_locale_to_utf8(path, -1, NULL, NULL, NULL);

  if (utf8_path) {
    /* $B%3%s%\%\%C%/%9$N%3!<%k%P%C%/$r%V%m%C%/(B */
#if 0
    combo_callback_flag = FALSE;
#endif
    teoeyes_browser_scan_folder (TEOEYES_BROWSER(browse_window), path);
    gtk_entry_set_text(GTK_ENTRY(TEOEYES_BROWSER(browse_window)->folder_entry),
		       utf8_path);
    
    /* $B%3%s%\%\%C%/%9$N%3!<%k%P%C%/$r%V%m%C%/$r2r=|(B */
#if 0
    combo_callback_flag = TRUE;
#endif
    g_free(utf8_path);
  }  
  return FALSE;
}

/* ************************************************************************* *
 *$B!!Jd=u4X?t(B
 *
 * ls_image
 * create_thumbnail
 * add_icon
 * add_file
 * ************************************************************************* */

/* ************************************************************************* */
static GList*
ls_image (const gchar	*folder) {
  TeoeyesImageModule	*loader;
  GList			*folder_list = NULL;
  GList			*image_list = NULL;
  GList			*list;
  gchar			*filename;
  
  folder_list = gnome_vfs_ext_ls_dir(folder);
  for (list = folder_list; list; list = g_list_next (list)) {
    filename = g_build_filename (folder,
				 (gchar *)
				 ((GnomeVFSFileInfo *) list->data)->name,
				 NULL);
    loader = teoeyesloader_select_from_extension(image_loader, filename);
    if (loader) {
      image_list
	= g_list_append (image_list,
			 g_strdup (((GnomeVFSFileInfo *) list->data)->name));
    }
  }
  gnome_vfs_file_info_list_free (folder_list);

  return image_list;
}

/* ************************************************************************* */
static gchar*
create_thumbnail (const gchar	*icon_folder,
		  const gchar	*filename,
		  gint		icon_width,
		  gint		icon_height) {
  TeoeyesImageModule	*loader;  
  GdkPixbuf		*pixbuf1, *pixbuf2, *background;
  gchar			*icon_name = NULL;
  gchar			*jpeg_name, *ptr, *ext, *work;
  gint			length, w, h;
  guint64		date1, date2;

  ptr = (gchar *) filename;
  ext = strrchr (filename, '.');
  if (ext) {
    length = strlen(filename) - strlen(ext) + 5;
  } else {
    length = strlen(filename) + 5;
  }
  work = jpeg_name = g_new0(gchar, length);
  if (ext) {
    while (ptr < ext) *work++ = *ptr++;
  } else {
    while (*ptr) *work++ = *ptr++;
  }
  *work++ = '.';
  *work++ = 'j';
  *work++ = 'p';
  *work++ = 'g';
  *work++ = '\0';
  
  icon_name = g_build_filename (icon_folder, jpeg_name, NULL);
  g_free(jpeg_name);

  if (g_file_test (icon_name, G_FILE_TEST_EXISTS)) {
    date1 = g_file_get_moddate (filename);
    date2 = g_file_get_moddate (icon_name);
    if (date1 < date2) {
      pixbuf1 = gdk_pixbuf_new_from_file (icon_name, NULL);
      if (gdk_pixbuf_get_width (pixbuf1) == icon_width ||
	  gdk_pixbuf_get_height(pixbuf1) == icon_height) {
	gdk_pixbuf_unref (pixbuf1);
	return icon_name;
      } else {
	gdk_pixbuf_unref (pixbuf1);	
      }
    }
  }
  loader = teoeyesloader_select_from_extension(image_loader, filename);  
  if (loader) {
    pixbuf1 = loader->load (filename, NULL);
    if (pixbuf1) {
      w = gdk_pixbuf_get_width  (pixbuf1);
      h = gdk_pixbuf_get_height (pixbuf1);
      if (w > icon_width || h > icon_height) {
	h = (icon_width * h) / w;
	w = icon_width;
      }
      if (h == 0) h = 2;
      if (h > icon_height) {
	w = (icon_height * gdk_pixbuf_get_width (pixbuf1)) /
	  gdk_pixbuf_get_height (pixbuf1);
	h = icon_height;
	if (w == 0) w = 2;
      }
      pixbuf2
	= gdk_pixbuf_scale_simple (pixbuf1, w, h, GDK_INTERP_BILINEAR);
      background = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
      gdk_pixbuf_composite_color(pixbuf2, background,
				 0, 0, w, h, 0, 0, 1.0, 1.0,
				 GDK_INTERP_TILES,
				 255, 0, 0, 16, 0xaaaaaa, 0x555555);
      work = g_strdup (icon_name);
      ext = strrchr (work, '/');
      *ext = '\0';
      if (!g_file_test (work, G_FILE_TEST_EXISTS)) g_dir_mkdirs (work);
      *ext = '/';
      g_free (work);
      gdk_pixbuf_save (background, icon_name, "jpeg", NULL, NULL);
      gdk_pixbuf_unref (pixbuf1);
      gdk_pixbuf_unref (pixbuf2);
      gdk_pixbuf_unref (background);
      
      return icon_name;
    }
  }
  g_free (icon_name);
  return NULL;
}

/* $B%"%$%3%s%j%9%H$K%"%$%3%s$rDI2C$9$k4X?t(B ********************************** */
static void
add_icon (GnomeIconList	*iconlist,
	  const gchar	*icon_folder,
	  const gchar	*filename,
	  const gchar	*label,
	  gint		icon_width,
	  gint		icon_height) {
  gchar	*icon_name;
  gint	n;
  
  icon_name = create_thumbnail (icon_folder,
				filename, icon_width, icon_height);
  if (icon_name) {
    n = gnome_icon_list_append (iconlist, icon_name, label);
    gnome_icon_list_set_icon_data (iconlist,
				   n, (gpointer) g_strdup (filename));
    g_free(icon_name);
  }
}

/* $B%U%!%$%k%j%9%H$K%"%$%3%s$rDI2C$9$k4X?t(B ********************************** */
static void
add_file (GtkListStore	*store,
	  const gchar	*filename,
	  const gchar	*label) {
  TeoeyesImageModule	*loader;
  GtkTreeIter		iter;
  GdkPixbuf		*pixbuf;
  gchar			isize[1024];
  
  loader = teoeyesloader_select_from_extension(image_loader, filename);
  if (loader) {
    pixbuf = loader->load(filename, NULL);
    if (pixbuf) {
      sprintf (isize, "%dx%d",
	       gdk_pixbuf_get_width (pixbuf), gdk_pixbuf_get_height (pixbuf));
      gtk_list_store_append (store, &iter);
      gtk_list_store_set(store, &iter,
			 COLUMN_FILENAME,  g_strdup (label),
			 COLUMN_FILESIZE,  g_file_get_size_string (filename),
			 COLUMN_IMAGESIZE, g_strdup (isize),
			 COLUMN_UPDATETIME,g_file_get_moddate_string(filename),
			 COLUMN_TERMINATOR);
      gdk_pixbuf_unref (pixbuf);
    }
  }
}

/* ************************************************************************* */
static void
folder_combo_prepend (TeoeyesBrowser	*browser,
		      const gchar	*folder) {
  GList		*list;
  gboolean	exist_flag = FALSE;

  for (list = browser->combolist; list; list = g_list_next(list)) {
    if (strcmp(folder, (gchar *) list->data) == 0) {
      exist_flag = TRUE;
      break;
    }
  }
  if (!exist_flag) {
    browser->combolist = g_list_prepend(browser->combolist, g_strdup(folder));
    gtk_combo_box_prepend_text(GTK_COMBO_BOX(browser->folder_combo),
			       g_strdup(folder));
    if (g_list_length(browser->combolist) > COMBO_LIST_LIMIT) {
      browser->combolist
	= g_list_remove(browser->combolist,
			g_list_last(browser->combolist)->data);
      gtk_combo_box_remove_text(GTK_COMBO_BOX(browser->folder_combo),
				COMBO_LIST_LIMIT);
    }
  }
}

/* ************************************************************************* *
 * TeoeyesBrowser$B$K4X$9$k%0%m!<%P%k4X?t(B
 *
 * teoeyes_browser_scan_folder
 *
 * ************************************************************************* */

/* $B%-%c%s%P%9$N99?7(B ******************************************************** */
void
teoeyes_browser_scan_folder (TeoeyesBrowser	*browser,
			     const gchar	*folder) {
  GtkListStore	*store;
  GList		*imagelist, *list;
  gchar		*file, *label, *filename;
  gint		n, inums;

  if (folder && browser->folder) {
    g_free (browser->folder);
    browser->folder = g_strdup (folder);
  }
  if (!browser->folder) browser->folder = g_strdup (folder);
  gnome_icon_list_freeze (GNOME_ICON_LIST(browser->iconview));
  gnome_icon_list_clear  (GNOME_ICON_LIST(browser->iconview));

  store = GTK_LIST_STORE(gtk_tree_view_get_model
			 (GTK_TREE_VIEW(browser->fileview)));
  imagelist = ls_image (browser->folder);

  gdk_threads_enter();

  for (n = 1, inums = g_list_length(imagelist),
	 list = imagelist; list; list = g_list_next (list)) {
    /* $B%U%!%$%kL>(B */
    file = g_locale_to_utf8 ((gchar *) list->data, -1, NULL, NULL, NULL);

    /* $B2hA|FI$_9~$_Cf$N%i%Y%k(B */
    label = g_strconcat (_("Now Loading"), " ", file, NULL);
    gtk_label_set (GTK_LABEL(browser->state_label), label);

    /* $B%W%m%0%l%9%P!<$N99?7(B */
    gtk_progress_bar_update (GTK_PROGRESS_BAR(browser->progressbar),
			     (1.0 * n++) / inums);
    while (gtk_events_pending()) gtk_main_iteration();

    /* $B%"%$%3%s$NEPO?(B */
    filename = g_build_filename (browser->folder, (gchar *) list->data, NULL);
    add_icon (GNOME_ICON_LIST(browser->iconview),
	      browser->icon_folder, filename, file,
	      browser->icon_width, browser->icon_height);
    add_file (store, filename, file);

    g_free (file);
    g_free (label);
    g_free (filename);
  }
  /* $B%W%m%0%l%9%P!<$N99?7(B */
  gtk_progress_bar_update (GTK_PROGRESS_BAR(browser->progressbar), 0.0);
  while (gtk_events_pending()) gtk_main_iteration();

  /* $B2hA|FI$_9~$_Cf$N%i%Y%k(B */
  gtk_label_set (GTK_LABEL(browser->state_label), "");

  /* $B%j%9%H$N8e;OKv(B */
  g_list_foreach (imagelist, (GFunc) g_free, NULL);
  
  gdk_threads_leave();
  gnome_icon_list_thaw (GNOME_ICON_LIST(browser->iconview));

  if (folder) folder_combo_prepend(browser, folder);
}

/* **************************************************** End of browser.c *** */
