/* ****************************************************** teoeyes_menu.h *** *
 * ˥塼˴ؤؿ إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/05 20:17:36 sugaya>
 * ************************************************************************* */
#ifndef	__TEOEYES_MENU_H__
#define	__TEOEYES_MENU_H__

/* ************************************************************************* *
 * GnomeUIInfoType:
 * @TEOEYES_UI_ENDOFINFO  : ˥塼ƥνü
 * @TEOEYES_UI_ITEM       : ̤Υ˥塼ƥ
 * @TEOEYES_UI_TOGGLEITEM : å˥塼ƥ
 * @TEOEYES_UI_RADIOITEMS : 饸˥塼ƥ
 * @TEOEYES_UI_SUBTREE    : ֥˥塼ƥ
 * @TEOEYES_UI_SEPARATOR  : ѥ졼ƥ
 * @TEOEYES_UI_TEAROFF    : ƥեƥ
 * ************************************************************************* */
typedef enum {
  TEOEYES_UI_ENDOFINFO,
  TEOEYES_UI_ITEM,
  TEOEYES_UI_TOGGLEITEM,
  TEOEYES_UI_RADIOITEMS,
  TEOEYES_UI_SUBTREE,
  TEOEYES_UI_SEPARATOR,
  TEOEYES_UI_TEAROFF,
} TeoeyesUIInfoType;

/* ************************************************************************* *
 * GnomeUIPixmapType:
 * @TEOEYES_PIXMAP_NONE     : ʤ
 * @TEOEYES_PIXMAP_STOCK    : ȥåƥफ饢ǡ
v * @TEOEYES_PIXMAP_DATA     : 饤XPMǡ饢ǡ
 * @TEOEYES_PIXMAP_FILENAME : ե뤫饢ǡ
 * ************************************************************************* */
typedef enum {
  TEOEYES_PIXMAP_NONE,
  TEOEYES_PIXMAP_STOCK,
  TEOEYES_PIXMAP_DATA,
  TEOEYES_PIXMAP_FILENAME
} TeoeyesUIPixmapType;

/* ************************************************************************* *
 * ˥塼ƥ๽¤
 * ************************************************************************* */
typedef struct _TeoeyesUIInfo {
  TeoeyesUIInfoType	type;
  const gchar		*label;
  const gchar		*hint;
  gpointer		moreinfo;
  gpointer		user_data;
  gpointer		unused_data;
  TeoeyesUIPixmapType	pixmap_type;
  gconstpointer		pixmap_info;
  guint			accelerator_key;
  GdkModifierType	ac_mods;
  GtkWidget		*widget;
} TeoeyesUIInfo;

#define TEOEYESUIINFO_SEPARATOR {TEOEYES_UI_SEPARATOR, NULL, NULL, NULL, NULL, NULL, (TeoeyesUIPixmapType) 0, NULL, 0, (GdkModifierType) 0, NULL}
  
#define TEOEYESUIINFO_TEAROFF {TEOEYES_UI_TEAROFF, NULL, NULL, NULL, NULL, NULL, (TeoeyesUIPixmapType) 0, NULL, 0, (GdkModifierType) 0, NULL}
  
#define	TEOEYESUIINFO_END {TEOEYES_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL, (TeoeyesUIPixmapType) 0, NULL, 0, (GdkModifierType) 0, NULL}

/* ************************************************************************* */
void	teoeyes_fill_menu	(GtkMenuShell		*menu,
				 GtkAccelGroup		*accel,
				 TeoeyesUIInfo		*ui);

#endif	/* __TEOEYES_MENU_H__ */

/* *********************************************** End of teoeyes_menu.h *** */
