//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOUTILIMAGE_H_
#define _TEOPP_TEOUTILIMAGE_H_
// $B2hA|%/%i%9(B
template <class ETYPE> class TeoUtilImage :public TeoImage<ETYPE> {
public:
  TeoUtilImage();
  TeoUtilImage(const TeoUtilImage<ETYPE> &image);
  TeoUtilImage(const TeoImage<ETYPE> &image);
  TeoUtilImage(const TeoAnyImage &image);
  TeoUtilImage(int width, int height, int xoffset, int yoffset ,int plane);
  TeoUtilImage(const char *file_name, int num_of_frame=0);

  TeoUtilImage<ETYPE> &operator=(const TeoUtilImage<ETYPE> &image);
  TeoUtilImage<ETYPE> &operator=(ETYPE value);

  ETYPE MaxPixel()const;
  ETYPE MinPixel()const;

  TeoUtilImage<TeoFloat64> Range(TeoFloat64 smin, TeoFloat64 smax,
				 TeoFloat64 dmin, TeoFloat64 dmax)const;

  TeoUtilImage<TeoBin> Binarize(ETYPE threshold)const;
  TeoUtilImage<TeoFloat64> Convolution(const TeoUtilImage<TeoFloat64> &mask)const;

  // $B1i;;;R$NDj5A(B
  TeoUtilImage<ETYPE> &operator|=(const TeoUtilImage<ETYPE> &image);
  TeoUtilImage<ETYPE> &operator&=(const TeoUtilImage<ETYPE> &image);

  TeoUtilImage<ETYPE> operator|(const TeoUtilImage<ETYPE> &image)const;
  TeoUtilImage<ETYPE> operator&(const TeoUtilImage<ETYPE> &image)const;

  TeoAnyImage operator+(const TeoUtilImage<ETYPE> &image)const;
  TeoAnyImage operator-(const TeoUtilImage<ETYPE> &image)const;
  TeoAnyImage operator+(ETYPE val)const;
  TeoAnyImage operator-(ETYPE val)const;

  TeoAnyImage operator*(TeoFloat64 val)const;
  TeoAnyImage operator/(TeoFloat64 val)const;
};
// $B%$%s%i%$%s4X?t$NDj5A(B
#include <teopp/teoutilimage_inline.h>
#endif
