//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOBIT_INLINE_H_
#define _TEOPP_TEOBIT_INLINE_H_
inline TeoBit::TeoBit():data(0),mask(0x01),ptr(&data){}
inline TeoBit::TeoBit(const TeoBit &b):data(b.data),mask(b.mask),ptr(b.ptr){}
inline TeoBit::TeoBit(TeoUint8 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoSint8 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoUint16 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoSint16 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoUint32 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoSint32 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoFloat32 b):mask(0x01){
  data = (b == 0.0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(TeoFloat64 b):mask(0x01){
  data = (b == 0.0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBit::TeoBit(char d,int s):data(d),mask(0x01),ptr(&data){
  mask <<= s;
}
inline TeoBit::TeoBit(char *d,int s):data(*d),mask(0x01),ptr(d){
  mask <<= s;
}
inline TeoBit::TeoBit(const char *d,int s):data(*d),mask(0x01),ptr(&data){
  mask <<= s;
}
inline TeoBit::~TeoBit(){}

inline bool TeoBit::IsSetBit()const{
  return ((mask & (*ptr)) != 0);
}
inline TeoBit &TeoBit::Set(){
  (*ptr) |= mask;
}
inline TeoBit &TeoBit::Unset(){
  (*ptr) &= (~mask);
}
inline TEO_BIT TeoBit::GetBit()const{
  return (IsSetBit())? (TEO_BIT)1:(TEO_BIT)0;
}

inline TeoBit &TeoBit::operator()(const TeoBit &b){
  data  = b.data;
  ptr   = b.ptr;
  mask  = b.mask;
  return *this;
}

// $BBeF~1i;;;R(B
inline TeoBit &TeoBit::operator=(const TeoBit &b){
  if(b.IsSetBit()) Set();
  else Unset();
  return *this;
}
inline TeoBit &TeoBit::operator=(TEO_BIT b){
  if(b==0) Unset();
  else Set();
  return *this;
}
inline TeoBit &TeoBit::operator|=(const TeoBit &b){
  if(b.IsSetBit()) Set();
  return *this;
}
inline TeoBit &TeoBit::operator+=(const TeoBit &b){
  if(b.IsSetBit()) Set();
  return *this;
}
inline TeoBit &TeoBit::operator&=(const TeoBit &b){
  if(!b.IsSetBit()) Unset();
  return *this;
}
inline TeoBit &TeoBit::operator*=(const TeoBit &b){
  if(!b.IsSetBit()) Unset();
  return *this;
}
inline TeoBit &TeoBit::operator-=(const TeoBit &b){
  if(b.IsSetBit()) Unset();
  return *this;
}
inline TeoBit &TeoBit::operator/=(const TeoBit &b){
  return *this;
}

// $BC19`1i;;;R(B
inline TeoBit TeoBit::operator~()const{
  if(IsSetBit()) return TeoBit(0);
  else return TeoBit(1);
}
inline TeoBit TeoBit::operator-()const{
  if(IsSetBit()) return TeoBit(0);
  else return TeoBit(1);
}

// $B;MB'1i;;(B
inline TeoBit TeoBit::operator|(const TeoBit &x)const{
  if(IsSetBit()||x.IsSetBit()) return TeoBit(1);
  else return TeoBit(0);
}
inline TeoBit TeoBit::operator+(const TeoBit &x)const{
  if(IsSetBit()||x.IsSetBit()) return TeoBit(1);
  else return TeoBit(0);
}
inline TeoBit TeoBit::operator&(const TeoBit &x)const{
  if(IsSetBit()&&x.IsSetBit()) return TeoBit(1);
  else return TeoBit(0);
}
inline TeoBit TeoBit::operator*(const TeoBit &x)const{
  if(IsSetBit()&&x.IsSetBit()) return TeoBit(1);
  else return TeoBit(0);
}
inline TeoBit TeoBit::operator-(const TeoBit &x)const{
  if(x.IsSetBit()) return TeoBit(1);
  else return GetBit();
}
inline TeoBit TeoBit::operator/(const TeoBit &x)const{
  return GetBit();
}

// $BHf3S1i;;;R(B
inline bool TeoBit::operator==(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return ((x&&y) || (!x&&!y));
}
inline bool TeoBit::operator!=(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return ((!x&&y) || (!x&&y));
}
inline bool TeoBit::operator<(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (!x&&y);
}
inline bool TeoBit::operator<=(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (!x||y);
}
inline bool TeoBit::operator>(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (x&&!y);
}
inline bool TeoBit::operator>=(const TeoBit &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (x||!y);
}

// $B%-%c%9%H1i;;;R(B
inline TeoBit::operator TeoUint8()const{
  return (TeoUint8)(GetBit());
}
inline TeoBit::operator TeoSint8()const{
  return (TeoSint8)(GetBit());
}
inline TeoBit::operator TeoUint16()const{
  return (TeoUint16)(GetBit());
}
inline TeoBit::operator TeoSint16()const{
  return (TeoSint16)(GetBit());
}
inline TeoBit::operator TeoUint32()const{
  return (TeoUint32)(GetBit());
}
inline TeoBit::operator TeoSint32()const{
  return (TeoSint32)(GetBit());
}
inline TeoBit::operator TeoFloat32()const{
  return (TeoFloat32)(GetBit());
}
inline TeoBit::operator TeoFloat64()const{
  return (TeoFloat64)(GetBit());
}
#endif
