//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOIMAGE_H_
#define _TEOPP_TEOIMAGE_H_
#include <teopp/error.h>
extern "C++" {
  // $B2hA|%/%i%9(B
  template <class ETYPE> class TeoImage :public TeoAnyImage{
  public:
    class Error : public TeoErr {
    public:
      Error();
    };

    TeoImage();
    TeoImage(const TeoImage<ETYPE> &image);
    TeoImage(const TeoAnyImage &image);
    TeoImage(int width, int height, int xoffset, int yoffset ,int plane);
    TeoImage(const char *file_name, int num_of_frame=0);

    ETYPE *Data()const;

    ETYPE &operator()(int x,int y,int p=0)const;
    ETYPE &GetPixel(int x,int y,int p=0)const;
    void SetPixel(int x,int y,int p,ETYPE value);
    void SetPixel(int x,int y,ETYPE value);

    virtual TeoImage<ETYPE> &operator=(ETYPE value);

    ETYPE MaxPixel()const;
    ETYPE MinPixel()const;
    
  protected:
    bool TypeCheck()const;
    void Conversion();
  };
} // extern "C++"

// $B%$%s%i%$%s4X?t$NDj5A(B
#include <teopp/teoimage_inline.h>
#endif
