//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOIMAGE_INLINE_H_
#define _TEOPP_TEOIMAGE_INLINE_H_

template <class ETYPE>
inline TeoImage<ETYPE>::TeoImage():TeoAnyImage(){}
template <class ETYPE>
inline TeoImage<ETYPE>::TeoImage(const TeoImage<ETYPE> &img):TeoAnyImage(img){
  if(!TypeCheck()){
    Conversion();
  }
}
template <class ETYPE>
inline TeoImage<ETYPE>::TeoImage(const TeoAnyImage &img):TeoAnyImage(img){
  if(!TypeCheck()){
    Conversion();
  }
}

template <class ETYPE>
inline TeoImage<ETYPE>::TeoImage(const char *fname,int fnum=0):TeoAnyImage(fname,fnum){
  if(!TypeCheck()){
    Conversion();
  }
}

inline TeoImage<TeoBin>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_UNSIGNED,1,p){}
inline TeoImage<TeoUint8>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_UNSIGNED,8,p){}
inline TeoImage<TeoSint8>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_SIGNED,8,p){}
inline TeoImage<TeoUint16>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_UNSIGNED,16,p){}
inline TeoImage<TeoSint16>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_SIGNED,16,p){}
inline TeoImage<TeoUint32>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_UNSIGNED,32,p){}
inline TeoImage<TeoSint32>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_SIGNED,32,p){}
inline TeoImage<TeoFloat32>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_FLOAT,32,p){}
inline TeoImage<TeoFloat64>::TeoImage(int w,int h,int x,int y,int p)
  :TeoAnyImage(w,h,x,y,TEO_FLOAT,64,p){}

template <class ETYPE>
inline ETYPE *TeoImage<ETYPE>::Data()const{return (ETYPE *)TeoData(teoimage);}

template <class ETYPE>
inline ETYPE &TeoImage<ETYPE>::GetPixel(int x,int y,int p=0)const{
  return (*this)(x,y,p);
}
template <class ETYPE>
inline void TeoImage<ETYPE>::SetPixel(int x,int y,int p,ETYPE val){
  (*this)(x,y,p) = val;
}
template <class ETYPE>
inline void TeoImage<ETYPE>::SetPixel(int x,int y,ETYPE val){
  (*this)(x,y,0) = val;
}

inline TeoBin &TeoImage<TeoBin>::operator()(int x,int y,int p)const{
  static TeoBin bit;
  return bit(TeoBin(((char *)Data() +
		     ((y*((Width()-1)/8+1) + (x/8))*Plane() + p))
		    ,(7-(x%8))));
}
inline TeoUint8 &TeoImage<TeoUint8>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoUint8);
}
inline TeoSint8 &TeoImage<TeoSint8>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoSint8);
}
inline TeoUint16 &TeoImage<TeoUint16>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoUint16);
}
inline TeoSint16 &TeoImage<TeoSint16>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoSint16);
}
inline TeoUint32 &TeoImage<TeoUint32>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoUint32);
}
inline TeoSint32 &TeoImage<TeoSint32>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoSint32);
}
inline TeoFloat32 &TeoImage<TeoFloat32>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoFloat32);
}
inline TeoFloat64 &TeoImage<TeoFloat64>::operator()(int x,int y,int p)const{
  return TeoGetPixel(teoimage,x,y,p,TeoFloat64);
}
#endif
