#!/usr/local/bin/ruby -I/usr/local/lab/lib/ruby
require 'teo'
require 'teoutil/draw'
require 'getopts'
def usage
  STDERR.print <<EOF
teodraw.rb [-f] [-o output.teo] [line|rect|arc] input.teo x1 y1 x2 y2 c1 [c2 [...]]
EOF
end

unless getopts("fw",'o:')
  usage
  exit 1
end
if(ARGV.size<7)
  usage
  exit 1
end

fill = $OPT_f

command = ARGV.shift.to_s

input = TEO::File.open(ARGV.shift.to_s)
if($OPT_o)
  output = TEO::File.create($OPT_o,input)
else
  output = TEO::File.create("-",input)
end

x1 = ARGV.shift.to_i
y1 = ARGV.shift.to_i
x2 = ARGV.shift.to_i
y2 = ARGV.shift.to_i
color = Array.new
ARGV.each {|d|
  color.push(d.to_f)
}

input.each{|image|
  case command
  when /^line/i
    image.drawline(x1,y1,x2,y2,color,fill)
  when /^rect/i
    if $OPT_w
      x2 += x1
      y2 += y1
    end 
    image.drawrect(x1,y1,x2,y2,color,fill)
  when /^arc/i
    x = x1
    y = y1
    width = x2
    height = y2
    image.drawarc(x,y,width,height,color,fill)
  end
  output.write_frame(image)
}
exit 0
