#include "avi.h"
extern "C" {
#include<stdio.h>
	   }
avi_stream::avi_stream(const char *fname,int w,int h,int f,int fps)
  :width(w),height(h),frame(f),frame_per_second(fps)
{
  if(strcmp(fname,"-")==0){
    file = stdout;
  } else {
    file = fopen(fname,"wb");
  }

  dword_check = (4-(width*3)%4)%4;
  print_str("RIFF");
  print_uint32(0x800+(width*height*3+8+dword_check*height)*frame-8+frame*16+8);
  
  print_str("AVI ");

  print_str("LIST");
  print_uint32(0xc0);
  print_str("hdrl");

  print_str("avih");
  print_uint32(0x38);
  make_mainaviheader();
  
  print_str("LIST");
  print_uint32(0x74);
  print_str("strl");

  print_str("strh");

  print_uint32(0x38);
  make_avistreamheader();

  print_str("strf");
  print_uint32(0x28);
  make_bitmapinfo();
  
  print_str("JUNK");
  print_uint32(0x7f4-0xdc);
  for(int i=0xdc;i<0x7f4;i+=4)
    print_uint32(0);
  
  print_str("LIST");
  print_uint32((width*height*3+8+dword_check*height)*frame+4);
  print_str("movi");
}


void avi_stream::write_frame(const TeoImage<TeoUint8> &imgIn, int i){
  print_str("00db");
  print_uint32(width*height*3+dword_check*height);
  if(imgIn.Plane()>=3){
    for(int y=height-1;y>=0;y--){
      for(int x=0;x<width;x++)
	{
	  int r=(char)TeoGetPixel(imgIn,x,y,0,TEO_UINT8);
	  int g=(char)TeoGetPixel(imgIn,x,y,1,TEO_UINT8);
	  int b=(char)TeoGetPixel(imgIn,x,y,2,TEO_UINT8);
	  print_byte(b);
	  print_byte(g);
	  print_byte(r);
	}
      for(int counter=0;counter<dword_check;counter++)
	print_byte(0);
    }
  } else {
    for(int y=height-1;y>=0;y--){
      for(int x=0;x<width;x++)
	{
	  int p=(char)TeoGetPixel(imgIn,x,y,0,TEO_UINT8);
	  print_byte(p);
	  print_byte(p);
	  print_byte(p);
	}
      for(int counter=0;counter<dword_check;counter++)
	print_byte(0);
    }
  }    
}

avi_stream::~avi_stream(){
  print_str("idx1");
  print_uint32(frame*16);
  for(int i=0;i<frame;i++)
    {
      print_str("00db");
      print_uint32(0);
      print_uint32((width*height*3+8+dword_check*height)*i+4);
      print_uint32(width*height*3+dword_check*height);
    }
  fclose(file);
}

void avi_stream::print_byte(int n){
  putc(n,file);
}

void avi_stream::print_str(const char *str){
  fprintf(file,str);
}

void avi_stream::print_uint32(unsigned int n)
{
  for(int i=0;i<4;i++)
    {
      print_byte((char)(n % 256));
      n >>= 8;
    }
}

void avi_stream::make_mainaviheader()
{
  print_uint32((int)(1000.0*1000.0/(double)frame_per_second));
  print_uint32(0);
  print_uint32(0);
  print_uint32(0x610);

  print_uint32(frame);
  print_uint32(0);
  print_uint32(0x01);
  print_uint32(0);

  print_uint32(width);
  print_uint32(height);
  print_uint32(0);
  print_uint32(0);

  print_uint32(0);
  print_uint32(0);
}


void avi_stream::make_avistreamheader()
{
  print_str("vids");
  print_uint32(0);
  print_uint32(0);
  print_uint32(0);
  
  print_uint32(0);
  print_uint32(1);
  print_uint32(frame_per_second);
  print_uint32(0);

  print_uint32(frame);
  print_uint32(0);
  print_uint32(0x2710);
  print_uint32(0);

  print_uint32(0);
  print_uint32(width+height*65536);
}

void avi_stream::make_bitmapinfo()
{
  print_uint32(0x28);
  print_uint32(width);
  print_uint32(height);
  print_uint32(0x00180001);

  print_uint32(0);
  print_uint32(0);
  print_uint32(0);
  print_uint32(0);
  
  print_uint32(0);
  print_uint32(0);
}
