#!/bin/sh
#  Shimaki Matsubara <shimaki@bb.mbn.or.jp> 1998/09/16
#                            Last modified: 1999/08/06
#
# autoconf/automake/gettext ưȽ autogen.sh 
#
# Х
#   1ĤΥѥåʣ configure.in ޤޤΤˤ
#   бƤޤ
#
#   ŤС gettext ѤΥѥåˤбƤޤ
#   gettext 0.10.35 ʹߤ˾ޤǤ
#============================================================
# conf_flags ѿ
#   configure ץȤϤȯѤΥե饰ꤷޤ
#   :
#     --enable-maintainer-mode
#     --enable-compile-warnings
#     --enable-debug=yes
conf_flags=

# configure.in ̵лϤޤޤ
(test -f configure.in) || 
{
  #echo "**Error**: You must write 'configure.in', first."
  echo "**顼**: ǽ 'configure.in' Ƥ"
  exit 1
}

FILE=`sed 's/^.*AC_INIT.*(\(.*\)).*$/\1/;t;d' configure.in`
PACKAGE=`sed 's/^.*PACKAGE=\(.*\)$/\1/;t;d' configure.in`
# gettext Ѥ뤫Ƚ̤ޤ
ALL_LINGUAS=`sed 's/^.*ALL_LINGUAS="\?\([^"]*\)"\?$/\1/;t;d' configure.in`
# automake Ѥ뤫Ƚ̤ޤ
(test -f Makefile.am) && { ENABLE_AUTOMAKE=yes; }
# aclocal Ѥ include ǥ쥯ȥ꤬ꤵƤ뤫Ĵ٤ޤ
MACRODIRS=`sed 's/^.*AM_ACLOCAL_INCLUDE(\(.*\)).*$/\1/;t;d' configure.in`
DIE=0

# AC_INIT ɬܤǤ
(test -f $FILE) ||
{
  #echo "**Error**: You must run this script in the top-level '$PACKAGE' directory"
  echo "**顼**: '$PACKAGE' ȥåץǥ쥯ȥǤΥץȤ¹ԤƤ"
  exit 1
}

# automake ǤϡPACKAGE ̾ɬܤǤ
(test "$ENABLE_AUTOMAKE" = "yes") && (test -z "$PACKAGE") && 
{
  PACKAGE=`sed 's/^.*AM_INIT_AUTOMAKE.*(\([^,]*\),[^)]*).*$/\1/;t;d' configure.in`
  (test -z "$PACKAGE") &&
  {
    #echo "**Error**: You must set PACKAGE variable to your package name in configure.in"
    echo "**顼**: 'configure.in'  PACKAGE ѿ򤢤ʤΥѥå̾Ƥ "
    exit 1
  }
}


# autoconf 󥹥ȡ뤵Ƥ뤫Ĵ٤ޤ
(autoconf --version) < /dev/null > /dev/null 2>&1 ||
{
  #echo
  #echo "**Error**: You must have autoconf installed to compile '$PACKAGE'."
  #echo "Download the appropriate package for your distribution,"
  #echo "or get the source at ftp://ftp.gnu.org/pub/gnu/"
  echo
  echo "**顼**: '$PACKAGE' 򥳥ѥ뤹뤿ˤ autoconf 򥤥󥹥ȡ뤹ɬפޤ"
  echo "            ʤΥǥȥӥ塼Ѥ autoconf 򥤥󥹥ȡ뤹뤫"
  echo "            ftp://ftp.gnu.org/pub/gnu/ 饽ꡢѥ뤷Ƥ"
  echo "        : (Debian GNU/Linux 桼)"
  echo "            $ apt-get -fy install autoconf"
  DIE=1
}
# automake 󥹥ȡ뤵Ƥ뤫Ĵ٤ޤ
(test "$ENABLE_AUTOMAKE" = "yes") &&
{
  (automake --version) < /dev/null > /dev/null 2>&1 ||
  {
    #echo
    #echo "**Error**: You must have automake installed to compile '$PACKAGE'."
    #echo "Download the appropriate package for your distribution,"
    #echo "or get the source at ftp://ftp.gnu.org/pub/gnu/"
  echo
  echo "**顼**: '$PACKAGE' 򥳥ѥ뤹뤿ˤ automake 򥤥󥹥ȡ뤹ɬפޤ"
    echo "          ʤΥǥȥӥ塼Ѥ automake 򥤥󥹥ȡ뤹뤫"
    echo "          ftp://ftp.gnu.org/pub/gnu/ 饽ꡢѥ뤷Ƥ"
    echo "      : (Debian GNU/Linux 桼)"
    echo "          $ apt-get -fy install automake"
    DIE=1
  }
}
# gettext 󥹥ȡ뤵Ƥ뤫Ĵ٤ޤ
(grep "^AM_GNU_GETTEXT" configure.in > /dev/null) &&
{
  (gettext --version) < /dev/null > /dev/null 2>&1 ||
  {
    #echo
    #echo "**Error**: You must have gettext installed to compile '$PACKAGE'."
    #echo "           Download the appropriate package for your distribution,"
    #echo "           or get the source at ftp://ftp.gnu.org/pub/gnu/"
    echo
    echo "**顼**: '$PACKAGE' 򥳥ѥ뤹뤿ˤ gettext 򥤥󥹥ȡ뤹ɬפޤ"
    echo "            ʤΥǥȥӥ塼Ѥ gettext 򥤥󥹥ȡ뤹뤫"
    echo "            ftp://ftp.gnu.org/pub/gnu/ 饽ꡢѥ뤷Ƥ"
    echo "        : (Debian GNU/Linux 桼)"
    echo "            $ apt-get -fy install gettext"
    DIE=1
  }
}
(grep "^AM_GNOME_GETTEXT" configure.in > /dev/null) &&
{
  (gettext --version) < /dev/null > /dev/null 2>&1 ||
  {
    #echo
    #echo "**Error**: You must have gettext installed to compile '$PACKAGE'."
    #echo "           Download the appropriate package for your distribution,"
    #echo "           or get the source at ftp://ftp.gnu.org/pub/gnu/"
    echo
    echo "**顼**: '$PACKAGE' 򥳥ѥ뤹뤿ˤ gettext 򥤥󥹥ȡ뤹ɬפޤ"
    echo "            ʤΥǥȥӥ塼Ѥ gettext 򥤥󥹥ȡ뤹뤫"
    echo "            ftp://ftp.gnu.org/pub/gnu/ 饽ꡢѥ뤷Ƥ"
    echo "        : (Debian GNU/Linux 桼)"
    echo "            $ apt-get -fy install gettext"
    DIE=1
  }
}

# libtool 󥹥ȡ뤵Ƥ뤫Ĵ٤ޤ
(grep "^AM_PROG_LIBTOOL" configure.in > /dev/null) &&
{
  (libtool --version) < /dev/null > /dev/null 2>&1 ||
  {
    #echo
    #echo "**Error**: You must have libtool installed to compile '$PACKAGE'."
    #echo "Download the appropriate package for your distribution,"
    #echo "or get the source at ftp://ftp.gnu.org/pub/gnu/"
    echo
    echo "**顼**: '$PACKAGE' 򥳥ѥ뤹뤿ˤ libtool 򥤥󥹥ȡ뤹ɬפޤ"
    echo "            ʤΥǥȥӥ塼Ѥ libtool 򥤥󥹥ȡ뤹뤫"
    echo "            ftp://ftp.gnu.org/pub/gnu/ 饽ꡢѥ뤷Ƥ"
    echo "        : (Debian GNU/Linux 桼)"
    echo "            $ apt-get -fy install libtool"
    DIE=1
  }
}

(test "$DIE" -eq 1) && exit 1

(test -z "$*") &&
{
    #echo "**Warning**: I am going to run ./configure with no arguments."
    #echo "             if you wish to pass any to it, please specify them on the "
    #echo "             '$0' command line."
    echo "**ٹ**: ./configure ̵Ǽ¹Ԥޤ"
    echo "          ⤷ꤷΤǤС"
    echo "          '$0' ΰ˻ꤷƤ"
}

#echo processing...
echo ...

# ¸ط򵭽Ҥǥ쥯ȥ꤬ȤϺ롣
files=`find -name .deps`
#echo "Cleaning .deps/ directories ..."
echo "... .deps/ ǥ쥯ȥ ..."
for d in $files; do
  echo -n "   $d"
  if test -d $d; then
    if (rm -r $d); then
      #echo "...removed...OK"
      echo "......λ"
    else
      #echo "...failed to remove...Why..."
      echo ".........ʤ..."
    fi
  else
    #echo "...not found...Why..."
    echo "...ޤ...ʤ..."
  fi
done

# automake ɬפʥե뤬̵Ϥ automake 롣
#
# NEWS README AUTHORS ChangeLog Τɤ⸫Ĥʤϡ
# --foreign  automake Ϥ
#
requires="NEWS README AUTHORS ChangeLog"
#echo -n "Checking document files ..."
echo -n "ǧ... ɥȥե ..."
req_flag=0
for f in $requires; do
  test -f $f && test -s $f && req_flag=1
done

if test "$req_flag" -eq 1 ; then
  echo ""
  for f in $requires; do
    if test ! -f $f; then
      #echo "Creating $f..."
      echo "... $f..."
      touch $f
    elif test ! -s $f; then
      #echo "Checking $f ...empty...should be written...OK?"
      echo "ǧ... $f... ǤɬȤƤ"
    else
      #echo "Checking $f ...OK"
      echo "ǧ... $f...λ"
    fi
  done
else
  #echo " skiped"
  echo " Фޤ"
  automake_flags="--foreign"
fi

# gettext Ѥγĥʬ
# ɬפ .po եåޤ
# po/POTFILES.in ĤʤХץޤ
(test -n "$ALL_LINGUAS") &&
{
  ((test -d po) && (test -d intl)) || 
  {
    (test -r aclocal.m4) ||
    {
      #echo "Creating aclocal.m4 ..."
      echo "... aclocal.m4 ..."
      touch aclocal.m4
    }
    #echo "Running gettextize..."    
    echo "¹... gettextize..."    
    echo "no" | gettextize --force --copy
    (test -r aclocal.m4) && chmod u+w aclocal.m4
  }

  #echo "Checking po files ..."
  echo "ǧ... po ե ..."
  for l in $ALL_LINGUAS; do
    po=po/$l.po
    if test ! -f $po; then
      #echo "Creating $po ..."
      echo "... $po ..."
      touch $po
    else
      #echo "Checking $po ...OK"
      echo "ǧ... $po ...λ"
    fi
  done

  # po/POTFILES.in Υץޤ
  (test ! -f po/POTFILES.in) && 
  {
    rm -f po/POTFILES.in.example
     # ե餷*.c ե󤷤ޤ
    # intl/, po/ ǥ쥯ȥΥϽޤ
    src=`find -type f -name '*.c' | sed '/\/intl\//d; /\/po\//d'`
    # ե椫 "_(" 򸡺ޤ
    # ʸ󤬤...
    for f in $src; do
      (grep \_\( $f > /dev/null 2>&1) && echo $f >> po/POTFILES.in.example
    done
    # po/POTFILES.in.example ʤäȤϡ
    # Υեޤ
    if test ! -f po/POTFILES.in.example; then
      touch po/POTFILES.in.example
    fi
    cp po/POTFILES.in.example po/POTFILES.in
    #echo "**Warning**: po/POTFILES.in was generated automaticaly."
    echo "**ٹ**: po/POTFILES.in ưŪ˺ޤ"
  }
}

# /usr/share/aclocal  /usr/local/share/aclocal ¸ߤȤϡ
# ˤĤĤޤ򤢤碌ޤ
(test "$ENABLE_AUTOMAKE" = "yes") && 
  (test -d /usr/share/aclocal) && 
  (test -d /usr/local/share/aclocal) &&
{
  # ǥ쥯ȥ̾ϤǻꤷƤޤ
  macros=m4

  # aclocal  path Ĵ١.m4 ɤɤफĴ٤ޤ
  if test -f /usr/local/bin/aclocal; then
    acl_path1=/usr/local/share/aclocal
    acl_path2=/usr/share/aclocal
  elif test -f /usr/bin/aclocal; then
    acl_path1=/usr/share/aclocal
    acl_path2=/usr/local/share/aclocal
  fi

  (test -n "$acl_path1") &&
  {
    # ¾Υǥ쥯ȥˤʤ .m4 ɤߤޤʤΤǡ
    # $macros/ إԡޤ
    echo ""

    MACRODIRS="$MACRODIRS $macros"
    pwd=`pwd`
    cd $acl_path2
    files=`find -type f -name '*.m4'`
    # aclocal åʤ .m4 ɤߤ褦ˤޤ
    for f in $files; do
      # Ʊե̾ $acl_path1 ˤСϾͤΤ
      # Фޤ
      ff=$acl_path1/$f
      if test ! -f $ff; then
        # $f ϡaclocal ɤߤޤʤ .m4 Ǥ
	# 桼ꤹ $MACRODIRS ˤ뤫ɤĴ٤ޤ
	FLAG=0
	for d in $MACRODIRS; do
	  if test -f $pwd/$d/`basename $f`; then
	    FLAG=1
	    break
	  fi
	done
	if test $FLAG -eq 0; then
	  # $MACRODIRS ˤ⸫ĤʤäΤǥԡޤ
	  mkdir $pwd/$macros > /dev/null 2>&1
          cp $f $pwd/$macros
          #echo "  " `basename $f` " ... imported from $acl_path2"
          echo "  " `basename $f` " ... $acl_path2 ߤޤ"
	else
	  #echo "  " `basename $f` " ... already imported"
	  echo "  " `basename $f` " ... ˼ޤƤޤ"
	fi
      fi
    done
    cd $pwd
  }
}

if grep "^AM_PROG_LIBTOOL" configure.in > /dev/null; then
  #echo "Running libtoolize..."
  echo "¹... libtoolize..."
  libtoolize --force --copy
fi

# 衢configure script ޤǤϡ
# ޥɤ1ĤǤ⼺Ԥߤޤޤ
#
# acinclude.m4 ɤ߹ߡaclocal.m4 롣
if test "$ENABLE_AUTOMAKE" = "yes"; then
  # aclocal ˰ꤷɤߤޤޤ
  for d in $MACRODIRS; do
    if test -d $d; then
      aclocal_include="$aclocal_include -I $d"
    fi
  done

  # GNOME_INIT Ȥϡgnome Ѥ m4 ɤߤ
  (grep "^GNOME_INIT" configure.in > /dev/null) &&
  {
    (echo $ACLOCAL_FLAGS | grep "gnome" > /dev/null) ||
    (echo $aclocal_include | grep "gnome" > /dev/null) || 
    aclocal_include="$aclocal_include -I $acl_path1/gnome"
  }

  #echo "Running aclocal $ACLOCAL_FLAGS $aclocal_include..." &&
  echo "¹... aclocal $ACLOCAL_FLAGS $aclocal_include..." &&
  aclocal $ACLOCAL_FLAGS $aclocal_include
fi &&
# configure.in ɤ߹ߡconfigure 롣
#echo "Running autoconf..." &&
echo "¹... autoconf..." &&
autoconf &&
# acconfig.h ɤ߹ߡconfig.h.in 롣
if grep "^AM_CONFIG_HEADER" configure.in > /dev/null; then
  #echo "Running autoheader..." &&
  echo "¹... autoheader..." &&
  autoheader
fi &&
# Makefile.am ɤ߹ߡMakefile.in 롣
if test "$ENABLE_AUTOMAKE" = "yes"; then
  #echo "Running automake --add-missing $automake_flags..." &&
  echo "¹... automake --add-missing $automake_flags..." &&
  automake --add-missing $automake_flags
fi &&
# configure μ¹ԡautogen.sh ץȤΰΤޤϤ롣
# config.cache ȤϺ롣
rm -f config.cache &&
#echo "Running configure $conf_flags $@..." &&
echo "¹... configure $conf_flags $@..." &&
./configure $conf_flags "$@" &&

echo &&
#echo "Now type 'make' to compile '$PACKAGE'." &&
echo "'$PACKAGE' ڤि 'make' ¹Ԥ褦" &&

# gettext Ѥγĥʬ
(test -f po/POTFILES.in.example) &&
{
  #echo
  #echo "**Warning**: 'po/POTFILES.in' is probably generated by autogen.sh."
  #echo "If it is correct, You must check 'po/POTFILES.in'."
  echo
  echo "**ٹ**: 'po/POTFILES.in' Ϥ餯 '$0' ˤä"
  echo "          ưŪ˺ޤ"
  echo "          ɬ 'po/POTFILES.in' ǧƤ"
}

(test -f po/$PACKAGE.pot) &&
{
  echo
  for l in $ALL_LINGUAS; do
    po=po/$l.po
    if test ! -s $po; then
      #echo "**ٹ**: '$po' is empty. You have to edit this file from '$PACKAGE.pot'."
      echo "**ٹ**: '$po' Ǥ"
      echo "          $PACKAGE.pot' ɬפޤ"
    fi
  done
}

exit 0

#------------------------------------------------------------
#
