/* **************************************************** teo2gdk-pixbuf.c *** *
 * teogdk-pixbuf֤Ѵ饤֥
 * teogdk-pixbufؤѴؿ
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA, <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-20 08:21:42 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include "intl.h"
#include "teo_convert.h"
#include "teo_copy.h"
#include "teo_normal.h"
#include "teo_range.h"
#include "teo_pixel.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

/* ǡΰβ ******************************************************** */
static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  free (pixels);
}

/* TEOե뤫GdkPixbuf ********************************** */
GdkPixbuf*
teo2gdk_pixbuf_new_from_file (char	*filename,
			      int	frame,
			      double	min,
			      double	max,
			      int	has_alpha) {
  GdkPixbuf	*pbuf;
  TEOFILE	*teo;
  TEOIMAGE	*img;
  TEOIMAGE      *tmp;
  unsigned char	*src_ptr;
  unsigned char *dst_ptr;
  unsigned char *data;
  int           n, w, h, src_p, dst_p;

  /* TEOΥץ */
  teo = TeoOpenFile (filename);
  if (!teo) {
    fprintf (stderr, _("Can not open file : %s\n"), filename);
    return NULL;
  }
  
  /* TEOΰγ */
  img = TeoAllocSimilarImage (teo);
  if (!img) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    TeoCloseFile (teo);
    return NULL;
  }

  /* TEOǡɤ߹ */
  if (TeoFrame (teo) > frame) TeoSetAbsFrame (teo, frame);
  TeoReadFrame (teo, img);

  /* γ */
  w = TeoWidth  (img);
  h = TeoHeight (img);

  /* ǡ */
  if (TeoBit (img) == 1) {		       /* 2Ͳξ0,255Ѵ */
    tmp = TeoCreateBin2Gray (img);
  } else if (min == -1 && max == -1) {		       /* Ŭͤ */
    TeoGetPixelRange (img, &min, &max);
    tmp = TeoCreateNormalImage (img, min, max);
  } else if (min == 0 && max == 0) {			     /* ʤ */
    if (TeoType (img) == TEO_UNSIGNED && TeoBit (img) == 8) {
      tmp = TeoCreateCopyImage (img);
    } else {
      TeoGetPixelRange (img, &min, &max);
      tmp = TeoCreateNormalImage (img, min, max);
    }
  } else {					 /* Ϳ줿ͤ */
    if (min == max) TeoGetPixelRange (img, &min, &max);	
    tmp = TeoCreateNormalImage (img, min, max);
  }

  /* ץ졼 */
  src_p = TeoPlane (tmp);
  dst_p = (src_p > 3 && has_alpha) ? 4 : 3;

  /* ϥǡؤΥݥ */
  data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * dst_p);
  src_ptr = (unsigned char *) tmp->data;
  dst_ptr = (unsigned char *) data;
  
  switch (src_p) {
  case 1:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;
    }
    break;
  case 2:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr++;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 3:
    for (n = w * h * 3; n > 0; n--) *dst_ptr++ = *src_ptr++;
    break;
  default:
    if (dst_p == 3) {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	src_ptr	+= src_p - 3;
      }
    } else {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 4;
      }
    }
    break;
  }

  /* GdkPixbuf */
  pbuf = gdk_pixbuf_new_from_data (data,
				  GDK_COLORSPACE_RGB,
				  (dst_p == 4) ? TRUE : FALSE,
				  8, w, h, w * dst_p, free_buffer, NULL);
  if (!pbuf) {
    fprintf (stderr, _("Can not create GdkPixbuf.\n"));
    TeoFreeImage (img);
    TeoCloseFile (teo);
    free (data);
    return NULL;
  }
  
  /* TEOΥ */
  TeoCloseFile (teo);
  TeoFreeImage (img);
  TeoFreeImage (tmp);
  
  return pbuf;
}

/* TEOFILEGdkPixbuf ****************************************** */
GdkPixbuf*
teo2gdk_pixbuf_new_from_teofile (TEOFILE	*teo,
				 int		frame,
				 double		min,
				 double		max,
				 int		has_alpha) {
  GdkPixbuf	*pbuf;
  TEOIMAGE	*img;
  TEOIMAGE      *tmp;
  unsigned char *src_ptr;
  unsigned char *dst_ptr;
  unsigned char *data;  
  int           n, w, h, src_p, dst_p;

  /* TEOΰγ */
  img = TeoAllocSimilarImage (teo);
  if (!img) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    return NULL;
  }

  /* TEOǡɤ߹ */
  if (TeoFrame (teo) > frame) TeoSetAbsFrame (teo, frame);
  TeoReadFrame (teo, img);

  /* γ */
  w = TeoWidth  (img);
  h = TeoHeight (img);

  /* ǡ */
  if (TeoBit (img) == 1) {		       /* 2Ͳξ0,255Ѵ */
    tmp = TeoCreateBin2Gray (img);
  } else if (min == -1 && max == -1) {		       /* Ŭͤ */
    TeoGetPixelRange (img, &min, &max);
    tmp = TeoCreateNormalImage (img, min, max);
  } else if (min == 0 && max == 0) {			     /* ʤ */
    if (TeoType (img) == TEO_UNSIGNED && TeoBit (img) == 8) {
      tmp = TeoCreateCopyImage (img);
    } else {
      TeoGetPixelRange (img, &min, &max);
      tmp = TeoCreateNormalImage (img, min, max);
    }
  } else {					 /* Ϳ줿ͤ */
    if (min == max) TeoGetPixelRange (img, &min, &max);	
    tmp = TeoCreateNormalImage (img, min, max);
  }

  /* ץ졼 */
  src_p = TeoPlane (tmp);
  dst_p = (src_p > 3 && has_alpha) ? 4 : 3;

  /* ϥǡؤΥݥ */  
  data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * dst_p);
  src_ptr = (unsigned char *) tmp->data;
  dst_ptr = (unsigned char *) data;

  switch (src_p) {
  case 1:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 2:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr++;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 3:
    for (n = w * h * 3; n > 0; n--) *dst_ptr++ = *src_ptr++;
    break;
  default:
    if (dst_p == 3) {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	src_ptr	+= src_p - 3;
      }
    } else {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	*dst_ptr++ = *src_ptr++;
	src_ptr	+= src_p - 4;
      }
    }
    break;
  }

  /* GdkPixbuf */
  pbuf = gdk_pixbuf_new_from_data (data,
				  GDK_COLORSPACE_RGB,
				  (dst_p == 4) ? TRUE : FALSE,
				  8, w, h, w * dst_p, free_buffer, NULL);
  if (!pbuf) {
    fprintf (stderr, _("Can not create GdkPixbuf.\n"));
    TeoFreeImage (img);
    free (data);
    return NULL;
  }
  
  /* TEOΥ */
  TeoFreeImage (img);
  TeoFreeImage (tmp);
  
  return pbuf;
}

/* TEOIMAGEGdkPixbuf ***************************************** */
GdkPixbuf*
teo2gdk_pixbuf_new_from_teoimage (TEOIMAGE	*img,
				  double	min,
				  double	max,
				  int		has_alpha) {
  GdkPixbuf	*pbuf;
  TEOIMAGE      *tmp;
  unsigned char *src_ptr;
  unsigned char *dst_ptr;
  unsigned char *data;  
  int           n, w, h, src_p, dst_p;

  /* γ */
  w = TeoWidth  (img);
  h = TeoHeight (img);

  /* ǡ */
  if (TeoBit (img) == 1) {		       /* 2Ͳξ0,255Ѵ */
    tmp = TeoCreateBin2Gray (img);
  } else if (min == -1 && max == -1) {		       /* Ŭͤ */
    TeoGetPixelRange (img, &min, &max);
    tmp = TeoCreateNormalImage (img, min, max);
  } else if ((int) min == 0 && (int) max == 0) {	     /* ʤ */
    if (TeoType (img) == TEO_UNSIGNED && TeoBit (img) == 8) {
      tmp = TeoCreateCopyImage (img);
    } else {
      TeoGetPixelRange (img, &min, &max);
      tmp = TeoCreateNormalImage (img, min, max);
    }
  } else {					 /* Ϳ줿ͤ */
    if (min == max) TeoGetPixelRange (img, &min, &max);	
    tmp = TeoCreateNormalImage (img, min, max);
  }

  /* ץ졼 */
  src_p = TeoPlane (tmp);
  dst_p = (src_p > 3 && has_alpha) ? 4 : 3;

  /* ϥǡؤΥݥ */
  data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * dst_p);
  src_ptr = (unsigned char *) tmp->data;
  dst_ptr = (unsigned char *) data;

  switch (src_p) {
  case 1:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;
    }
    break;
  case 2:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr++;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 3:
    for (n = w * h * 3; n > 0; n--) *dst_ptr++ = *src_ptr++;
    break;
  default:
    if (dst_p == 3) {    
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 3;
      }
    } else {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 4;
      }
    }
    break;
  }

  /* GdkPixbuf */
  pbuf = gdk_pixbuf_new_from_data (data,
				  GDK_COLORSPACE_RGB,
				  (dst_p == 4) ? TRUE : FALSE,
				  8, w, h, w * dst_p, free_buffer,NULL);
  if (!pbuf) {
    fprintf (stderr, _("Can not create GdkPixbuf.\n"));
    TeoFreeImage (img);
    free (data);
    return NULL;
  }

  TeoFreeImage (tmp);
  
  return pbuf;
}

/* TEOIMAGEǡGdkPixbuf˥ԡ *********************************** */
void
teo2gdk_pixbuf_copy_to_pixbuf (TEOIMAGE		*img,
			       GdkPixbuf	*pbuf,
			       double		min,
			       double		max,
			       int		has_alpha) {
  TEOIMAGE      *tmp;
  unsigned char *src_ptr;
  unsigned char *dst_ptr;
  unsigned char *data;  
  int           n, w, h, src_p, dst_p;

  /* γ */
  w = TeoWidth  (img);
  h = TeoHeight (img);

  /* ǡ */
  if (TeoBit (img) == 1) {		       /* 2Ͳξ0,255Ѵ */
    tmp = TeoCreateBin2Gray (img);
  } else if (min == -1 && max == -1) {		       /* Ŭͤ */
    TeoGetPixelRange (img, &min, &max);
    tmp = TeoCreateNormalImage (img, min, max);
  } else if ((int) min == 0 && (int) max == 0) {	     /* ʤ */
    if (TeoType (img) == TEO_UNSIGNED && TeoBit (img) == 8) {
      tmp = TeoCreateCopyImage (img);
    } else {
      TeoGetPixelRange (img, &min, &max);
      tmp = TeoCreateNormalImage (img, min, max);
    }
  } else {					 /* Ϳ줿ͤ */
    if (min == max) TeoGetPixelRange (img, &min, &max);	
    tmp = TeoCreateNormalImage (img, min, max);
  }

  /* ץ졼 */
  src_p = TeoPlane (tmp);
  dst_p = gdk_pixbuf_get_rowstride (pbuf) / gdk_pixbuf_get_width (pbuf);

  /* ϥǡؤΥݥ */
  src_ptr = (unsigned char *) tmp->data;
  dst_ptr = (unsigned char *) gdk_pixbuf_get_pixels (pbuf);
  
  switch (src_p) {
  case 1:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;
    }
    break;
  case 2:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr++;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 3:
    for (n = w * h * 3; n > 0; n--) *dst_ptr++ = *src_ptr++;
    break;
  default:
    if (dst_p == 3) {    
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 3;
      }
    } else {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 4;
      }
    }
    break;
  }
  TeoFreeImage (tmp);
}

/* ********************************************* End of teo2gdk_pixbuf.c *** */
