/* ******************************************************* teo_convert.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-09-19 23:40:18 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include "teo_pixel.h"
#include "teo_range.h"

/* Convert Binary to Gray (Original source comes from libteoutil) ********** */
TEOIMAGE*
TeoCreateBin2Gray (TEOIMAGE	*src) {
  int		row, col;
  TEOIMAGE	*dst;
  unsigned char	*src_ptr, *dst_ptr;
  
  dst = TeoAllocImage (TeoWidth   (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++){
      if (TeoGetBit (src, col, row, 0) == 0) {	
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 0);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, 255);	
      }
    }
  }     
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateRGB2Gray (TEOIMAGE	*src) {
  int           n;
  TEO_UINT8     r ,g ,b, pixel;
  TEO_UINT8	*src_ptr, *dst_ptr;
  TEOIMAGE      *dst;

  dst = TeoAllocImage (TeoWidth   (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);

  src_ptr = (TEO_UINT8 *) src->data;
  dst_ptr = (TEO_UINT8 *) dst->data;
  
  for (n = TeoFsize (src) / 3; n > 0; n--) {
    r = *src_ptr++;
    g = *src_ptr++;
    b = *src_ptr++;
    pixel = (TEO_UINT8) (0.299 * r + 0.587 * g + 0.114 * b);
    *dst_ptr++ = pixel;
    *dst_ptr++ = pixel;
    *dst_ptr++ = pixel;
  }

  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreate1PlaneTo3Plane (TEOIMAGE	*src) {
  TEOIMAGE	*dst;
  int		row, col;

  dst = TeoAllocImage (TeoWidth   (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);
  
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      TeoPutAnyPixel (dst, col, row, 0, TeoGetAnyPixel (src, col, row, 0));
      TeoPutAnyPixel (dst, col, row, 1, TeoGetAnyPixel (src, col, row, 0));
      TeoPutAnyPixel (dst, col, row, 2, TeoGetAnyPixel (src, col, row, 0));
    }
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreate3PlaneTo1Plane (TEOIMAGE	*src,
			 int		plane) {
  TEOIMAGE	*dst;
  int		row, col;

  dst = TeoAllocImage (TeoWidth   (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);
  
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      TeoPutAnyPixel (dst, col, row, 0, TeoGetAnyPixel (src, col, row, plane));
      TeoPutAnyPixel (dst, col, row, 1, TeoGetAnyPixel (src, col, row, plane));
      TeoPutAnyPixel (dst, col, row, 2, TeoGetAnyPixel (src, col, row, plane));
    }
  }
  return dst;
}

/* Convert Binary to Gray (Original source comes from libteoutil) ********** */
TEOIMAGE*
TeoBin2Gray (TEOIMAGE	*src,
	     TEOIMAGE	*dst) {
  int		row, col;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++){
      if (TeoGetBit (src, col, row, 0) == 0) {	
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 0);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, 255);	
      }
    }
  }     
  return dst;
}

/* ************************************************************************* */
void
TeoRGB2Gray (TEOIMAGE	*src,
	     TEOIMAGE	*dst) {
  int           n;
  TEO_UINT8     r, g, b, pixel;
  TEO_UINT8	*src_ptr, *dst_ptr;

  src_ptr = (TEO_UINT8 *) src->data;
  dst_ptr = (TEO_UINT8 *) dst->data;

  for (n = TeoFsize (src) / 3; n > 0; n--) {
    r = *src_ptr++;
    g = *src_ptr++;
    b = *src_ptr++;
    pixel = (TEO_UINT8) (0.299 * r + 0.587 * g + 0.114 * b);
    *dst_ptr++ = pixel;
    *dst_ptr++ = pixel;
    *dst_ptr++ = pixel;
  }     
}

/* ************************************************************************* */
void
Teo1PlaneTo3Plane (TEOIMAGE	*src,
		   TEOIMAGE	*dst) {
  int		row, col;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      TeoPutAnyPixel (dst, col, row, 0, TeoGetAnyPixel (src, col, row, 0));
      TeoPutAnyPixel (dst, col, row, 1, TeoGetAnyPixel (src, col, row, 0));
      TeoPutAnyPixel (dst, col, row, 2, TeoGetAnyPixel (src, col, row, 0));
    }
  }
}

/* ************************************************************************* */
void
Teo3PlaneTo1Plane (TEOIMAGE	*src,
		   TEOIMAGE	*dst,
		   int		plane) {
  int		row, col;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      TeoPutAnyPixel (dst, col, row, 0, TeoGetAnyPixel (src, col, row, plane));
      TeoPutAnyPixel (dst, col, row, 1, TeoGetAnyPixel (src, col, row, plane));
      TeoPutAnyPixel (dst, col, row, 2, TeoGetAnyPixel (src, col, row, plane));
    }
  }
}

/* ************************************************ End of teo_convert.c *** */
