/* ********************************************************** teo_copy.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-09-18 11:20:31 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

/* ************************************************************************* */
TEOIMAGE*
TeoCreateCopyImage (TEOIMAGE	*src) {
  TEOIMAGE	*dst;
  char		*src_ptr, *dst_ptr;
  int		n;

  dst     = TeoAllocSimilarImage (src);
  src_ptr = src->data;
  dst_ptr = dst->data;
  for (n = TeoFsize (src); n > 0; n--) *dst_ptr++ = *src_ptr++;

  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateCopyImageRegion (TEOIMAGE	*src,
			  int		cs,
			  int	 	ce,
			  int 		rs,
			  int 		re,
			  int		flg) {
  TEOIMAGE	*dst;
  int		n, cols, step;

  dst = TeoAllocImage (cols = ce - cs + 1, 
		       re - rs + 1, 
		       (flg == 0) ? cs : 0,
		       (flg == 0) ? rs : 0, 
		       TeoType	(src),
		       TeoBit	(src),
		       TeoPlane	(src));
  step  = (TeoWidth (src) - cols) * TeoPlane (src);
  cols *= TeoPlane (src);
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;      
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + TeoPlane (src) *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateCopyImagePlane (TEOIMAGE	*src,
			 int 		p) {
  TEOIMAGE	*dst;
  int		n, step;

  dst = TeoAllocImage (TeoWidth	  (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TeoType	  (src),
		       TeoBit	  (src),
		       1);
  step = TeoPlane (src);
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + p;
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + p;
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + p;
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + p;
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + p;
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + p;
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + p;
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break; 
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
TEOIMAGE*
TeoCreateCopyImagePlaneRegion (TEOIMAGE	*src,
			       int 	p,
			       int 	cs,
			       int 	ce,
			       int	rs, 
			       int	re,
			       int	flg) {
  TEOIMAGE	*dst;
  int		n, step, cols, plane;

  dst = TeoAllocImage (cols = ce - cs + 1, 
		       re - rs + 1, 
		       (flg == 0) ? cs : 0,
		       (flg == 0) ? rs : 0, 
		       TeoType	(src),
		       TeoBit	(src),
		       1);
  plane	= TeoPlane (src);
  step  = (TeoWidth (src) - cols) * plane;
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break; 
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  }
  return dst;
}

/* ************************************************************************* */
void 
TeoCopyImage (TEOIMAGE *src, TEOIMAGE *dst) {
  char		*src_ptr, *dst_ptr;
  int		n;

  src_ptr = src->data;
  dst_ptr = dst->data;
  for (n = TeoFsize (src); n > 0; n--) *dst_ptr++ = *src_ptr++;
}

/* ************************************************************************* */
void
TeoCopyImageRegion (TEOIMAGE	*src,
		    TEOIMAGE 	*dst,
		    int 	cs,
		    int 	ce,
		    int 	rs,
		    int 	re) {
  int		n, cols, step, plane;

  plane = TeoPlane (src);
  cols  = (ce - cs + 1);
  step  = (TeoWidth (src) - cols) * plane;
  cols *= plane;
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)));
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr++;
	}
      }
      break;
    }
    break;
  }
}

/* ************************************************************************* */
void 	
TeoCopyImagePlane (TEOIMAGE	*src,
		   TEOIMAGE	*dst,
		   int 		p) {
  int		n, step;

  step = TeoPlane (src);
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + p;
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + p;
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + p;
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + p;
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + p;
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + p;
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + p;
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + p;
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  *dst_ptr++ = *src_ptr;
	  src_ptr += step;
	}
      }
      break;
    }
    break;
  }
}

/* ************************************************************************* */
void 
TeoCopyImagePlaneRegion (TEOIMAGE	*src,
			 TEOIMAGE	*dst,
			 int 		p,
			 int		cs,
			 int 		ce,
			 int 		rs,
			 int 		re) {
  int		n, step, cols, plane;

  plane	= TeoPlane (src);
  cols  = (ce - cs + 1);
  step  = (TeoWidth (src) - cols) * plane;
  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8	*src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 16:
      {
	TEO_UINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 32:
      {
	TEO_UINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_UINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_UINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT8 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT8 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 16:
      {
	TEO_SINT16 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT16 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT16 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 32:
      {
	TEO_SINT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_SINT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_SINT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_FLOAT32 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    case 64:
      {
	TEO_FLOAT64 *src_ptr, *dst_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data + plane *
	  ((rs - TeoYstart (src)) * TeoWidth (src) + (cs - TeoXstart (src)))+p;
	dst_ptr = (TEO_FLOAT64 *) dst->data;
	for (n = TeoFsize (dst) * 8 / TeoBit (dst); n > 0; n--) {
	  if ((n % cols == 0) && (n != 0)) src_ptr += step;
	  *dst_ptr++ = *src_ptr;
	  src_ptr += plane;
	}
      }
      break;
    }
    break;
  }
}

/* *************************************************** End of teo_copy.c *** */
