/* **************************************************** teoeyes_loader.h *** *
 * ؿ ءե
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/14 20:47:16 sugaya>
 * ************************************************************************* */
#ifndef	__TEOEYES_LOADER_H__
#define	__TEOEYES_LOADER_H__

#include <gtk/gtk.h>

/* ************************************************************************* */
typedef enum {
  IMAGE_FORMAT_WRITABLE = 1 << 0
} ImageFormatFlags;

typedef struct _ImageFormatPattern {
  unsigned char		*prefix;
  unsigned char		*mask;
  int			relevance;
} ImageFormatPattern;

typedef	struct _ImageFormat {
  ImageFormatPattern	*signature;
  gchar			*name;
  gchar			*description;
  gchar			**mime_types;
  gchar			**extensions;
  guint32		flags;
} ImageFormat;

typedef struct _TeoeyesImageModule TeoeyesImageModule;
struct _TeoeyesImageModule {
  gchar			*module_name;
  ImageFormat		*info;
  GdkPixbuf		*icon;
  
  GdkPixbuf*		(* load)	(const gchar		*filename,
					 gpointer		data);
  gboolean		(* save)	(const gchar		*filename,
					 gpointer		data);
  void			(* load_info)	(TeoeyesImageModule	*module);
  
};

/* ؿ **************************************************************** */
GdkPixbuf*
gdk_pixbuf_remove_alpha			(const GdkPixbuf	*src);

GdkPixbuf*
gdk_pixbuf_align_rowstride		(GdkPixbuf		*src);


#endif /* __TEOEYES_LOADER_H__ */

/* ********************************************** End of teoyes_loader.h *** */
