/* ************************************************************ io-teo.c *** *
 * TEO⥸塼
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/25 23:06:38 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include "teoeyes.h"
#include "image_loader.h"
#include "teo2gdk-pixbuf.h"
#include "format_teo.icon"

/* ************************************************************************* */

GtkWidget*
teo_dialog_new 				(TEImage	*ti,
					 gchar		*filename);

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"TEO", NULL, 100},
  {"\x1f\x8b\x08", NULL, 100},  
  {NULL, NULL, 0}
};

static gchar *mime_types[] = {
  "image/teo",
  NULL
};
static gchar *extensions[] = {
  "teo",
  NULL
};

/* ************************************************************************* */
GdkPixbuf*
load_teo (const gchar	*filename,
	  gpointer	data) {
  TEOFILE	*teofp;
  TEOIMAGE	*teoimg;
  GdkPixbuf	*pixbuf;
  GList		*list, *root;
  gboolean	load_all;
  int		dtype, n;

  /* TEOեΥץ */
  if (!((TEImage *) data)->fp) {
    ((TEImage *) data)->fp = TeoOpenFile ((char *) filename);
  }
  if (!((TEImage *) data)->fp) {
    fprintf (stderr, "TEO-IO : Can not open %s.\n", filename);
    return NULL;
  }
  teofp    = (TEOFILE *)  ((TEImage *) data)->fp;
  load_all = (gboolean) ((TEImage *) data)->user_data2;

  /* ե졼ֹ */
  if (((TEImage *) data)->frame == -1) {
    ((TEImage *) data)->frame = TeoFrame (teofp) - 1;
  } else {
    ((TEImage *) data)->frame =
      (((TEImage *) data)->frame >= 0 &&
       ((TEImage *) data)->frame < 
       TeoFrame (teofp)) ? ((TEImage *) data)->frame : 0;
  }
  /* ե졼 */
  ((TEImage *) data)->nframes = TeoFrame (teofp);

  /* ͥ */
  ((TEImage *) data)->nchannels = TeoPlane (teofp);

  /* ǡ */
  switch (TeoType (teofp)) {
  case TEO_UNSIGNED:
    ((TEImage *) data)->type = TI_PIXEL_UNSIGNED;
    break;
  case TEO_SIGNED:
    ((TEImage *) data)->type = TI_PIXEL_SIGNED;
    break;
  case TEO_FLOAT:
    ((TEImage *) data)->type = TI_PIXEL_FLOAT;
    break;
  }
  /* ǡΥӥåȿ */
  ((TEImage *) data)->bit = TeoBit (teofp);

  /* եåȤ */
  ((TEImage *) data)->xoffset = TeoXoffset (teofp);
  ((TEImage *) data)->yoffset = TeoYoffset (teofp);

  if (load_all) {
    for (n = 0; n < TeoFrame (teofp); n++) {
      /* TEOIMAGEΰ */
      teoimg = TeoAllocSimilarImage (teofp);

      /* ǡɤ߹ */
      TeoReadFrame (teofp, teoimg);
    
      /* ꥹȤɲ */
      ((TEImage *) data)->original_data_list
	= g_list_append (((TEImage *) data)->original_data_list, teoimg);

      /* GdkPixbufǡ */
      pixbuf = teo2gdk_pixbuf_new_from_teoimage (teoimg, 
						 ((TEImage *) data)->min,
						 ((TEImage *) data)->max);
      ((TEImage *) data)->pixbuf_list 
	= g_list_append (((TEImage *) data)->pixbuf_list, pixbuf);
    }
    ((TEImage *) data)->original_data = 
      (gpointer) g_list_nth_data (((TEImage *) data)->original_data_list, 
				  ((TEImage *) data)->frame);

    return (GdkPixbuf *) g_list_nth_data (((TEImage *) data)->pixbuf_list, 
					  ((TEImage *) data)->frame);
  } else {
    /* TEOIMAGEΰ */
    teoimg = TeoAllocSimilarImage (teofp);

    /* ꤵ줿ե졼ǡΥå */
    TeoSetAbsFrame ((TEOFILE *) ((TEImage *) data)->fp,
		    ((TEImage *) data)->frame);
    
    /* ǡɤ߹ */
    TeoReadFrame (teofp, teoimg);
    
    /* ꥹȤɲ */
    ((TEImage *) data)->original_data_list 
      = g_list_append (((TEImage *) data)->original_data_list, teoimg);

    /* GdkPixbufǡ */
    pixbuf = teo2gdk_pixbuf_new_from_teoimage (teoimg, 
					       ((TEImage *) data)->min,
					       ((TEImage *) data)->max);
    ((TEImage *) data)->pixbuf_list 
      = g_list_append (((TEImage *) data)->pixbuf_list, pixbuf);

    if (((int) ((TEImage *) data)->user_data1) == 1) {
      TeoCloseFile ((TEOFILE *) ((TEImage *) data)->fp);
      TeoFreeImage (teoimg);
      ((TEImage *) data)->fp = NULL;
    } else {
      ((TEImage *) data)->original_data =
	(gpointer) g_list_nth_data (((TEImage *) data)->original_data_list, 0);
    }
    return (GdkPixbuf *) g_list_nth_data (((TEImage *) data)->pixbuf_list, 0);
  }
}

/* ************************************************************************* */
gboolean
save_teo (const gchar	*filename,
	  gpointer	data) {
  GtkWidget	*dialog;

  dialog = teo_dialog_new ((TEImage *) data, (gchar *) filename);
  gtk_widget_show_all (dialog);

  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "TEO";
  module->info->description	= "The TEO image format";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_teo, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "TEO",
  NULL,
  NULL,
  load_teo,
  save_teo,
  load_info
};

/* ***************************************************** End of io-teo.c *** */
