/* **************************************************** teo2gdk-pixbuf.c *** *
 * TEOgdk-pixbufؤѴؿ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA, <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/14 22:18:37 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include <gtk/gtk.h>
#include "teo_convert.h"
#include "teo_copy.h"
#include "teo_normal.h"
#include "teo_range.h"

#define gdk_pixbuf_get_pixel(pixbuf,x,y,p) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * (y) + \
 gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)))

/* ǡΰβ ******************************************************** */
static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  free (pixels);
}

/* TEOIMAGEGdkPixbuf ***************************************** */
GdkPixbuf*
teo2gdk_pixbuf_new_from_teoimage (TEOIMAGE	*img,
				  double	min,
				  double	max) {
  GdkPixbuf	*pbuf;
  TEOIMAGE      *tmp;
  unsigned char *src_ptr;
  unsigned char *dst_ptr;
  unsigned char *data;  
  int           n, w, h, src_p, dst_p;

  /* γ */
  w = TeoWidth  (img);
  h = TeoHeight (img);

  /* ǡ */
  if (TeoBit (img) == 1) {		       /* 2Ͳξ0,255Ѵ */
    tmp = TeoCreateBin2Gray (img);
  } else if (min == -1 && max == -1) {		       /* Ŭͤ */
    TeoGetPixelRange (img, &min, &max);
    tmp = TeoCreateNormalImage (img, min, max);
  } else if ((int) min == 0 && (int) max == 0) {	     /* ʤ */
    if (TeoType (img) == TEO_UNSIGNED && TeoBit (img) == 8) {
      tmp = TeoCreateCopyImage (img);
    } else {
      TeoGetPixelRange (img, &min, &max);
      tmp = TeoCreateNormalImage (img, min, max);
    }
  } else {					 /* Ϳ줿ͤ */
    if (min == max) TeoGetPixelRange (img, &min, &max);	
    tmp = TeoCreateNormalImage (img, min, max);
  }
  /* ץ졼 */
  src_p = TeoPlane (tmp);
  dst_p = 3;

  /* ϥǡؤΥݥ */
  data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * dst_p);
  src_ptr = (unsigned char *) tmp->data;
  dst_ptr = (unsigned char *) data;

  switch (src_p) {
  case 1:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;
    }
    break;
  case 2:
    for (n = w * h; n > 0; n--) {
      *dst_ptr++ = *src_ptr++;
      *dst_ptr++ = *src_ptr;
      *dst_ptr++ = *src_ptr++;      
    }
    break;
  case 3:
    for (n = w * h * 3; n > 0; n--) *dst_ptr++ = *src_ptr++;
    break;
  default:
    if (dst_p == 3) {    
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 3;
      }
    } else {
      for (n = w * h; n > 0; n--) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;	
	src_ptr	+= src_p - 4;
      }
    }
    break;
  }

  /* GdkPixbuf */
  pbuf = gdk_pixbuf_new_from_data (data,
				  GDK_COLORSPACE_RGB,
				  (dst_p == 4) ? TRUE : FALSE,
				  8, w, h, w * dst_p, free_buffer, NULL);
  if (!pbuf) {
    fprintf (stderr, "Can not create GdkPixbuf.\n");
    TeoFreeImage (img);
    free (data);
    return NULL;
  }
  TeoFreeImage (tmp);
  
  return pbuf;
}

/* ************************************************************************* */
TEOIMAGE*
teo2gdk_pixbuf_new_from_pixbuf (GdkPixbuf	*src, 
				gboolean	remove_alpha) {
  TEOIMAGE	*dst;
  guchar	*dst_ptr;
  int		channels, has_alpha, row, col;

  has_alpha = gdk_pixbuf_get_has_alpha (src);
  channels  = 3 + has_alpha - (remove_alpha * has_alpha);
  dst = TeoAllocImage (gdk_pixbuf_get_width  (src),
		       gdk_pixbuf_get_height (src),
		       0, 0, TEO_UNSIGNED, 8, channels);
  dst_ptr = (guchar *) dst->data;

  for (row = 0; row < TeoHeight (dst); row++) {
    for (col = 0; col < TeoWidth (dst); col++) {
      *dst_ptr++ = gdk_pixbuf_get_pixel (src, col, row, 0);
      *dst_ptr++ = gdk_pixbuf_get_pixel (src, col, row, 1);
      *dst_ptr++ = gdk_pixbuf_get_pixel (src, col, row, 2);
      if (has_alpha && !remove_alpha) {
	*dst_ptr++ = gdk_pixbuf_get_pixel (src, col, row, 3);
      }
    }
  }
  return dst;
}
				

/* ********************************************* End of teo2gdk_pixbuf.c *** */
