/* ****************************************************** pseudo_color.c *** *
 * Teoeyes Plugin Collection (顼)
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:46:39 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* */
static guint8
gray_to_pseudo_color (guchar	src,
		      int	plane) {
  switch (plane) {
  case 0:
    if (src < 128) {
      return 0;
    } else if (src > 192) {
      return 255;
    } else {
      return (guchar) ((src - 128) * 255 / 64);
    }
    break;
  case 1:
    if (src <= 64) {
      return (guchar) src * 255 / 64;
    } else if (src >= 192) {
      return (guchar) (255 - (guchar) (src - 192) * 255 / 63);
    } else {
      return (guchar) 255;
    }
    break;
  case 2:
    if (src < 64) {
      return (guchar) 255;
    } else if (src > 128) {
      return 0;
    } else {
      return (guchar) (255 - (guchar) (src - 64) * 255 / 64);
    }
    break;
  default:
    return (guchar) 0;
  }
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_pseudo (GdkPixbuf	*src,
	       GdkPixbuf	*dst) {
  guchar	y, r, g, b;
  int		row, col;
  
  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_width (src); col++) {
      r = gdk_pixbuf_get_pixel (src, col, row, 0);
      g = gdk_pixbuf_get_pixel (src, col, row, 1);
      b = gdk_pixbuf_get_pixel (src, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      gdk_pixbuf_put_pixel (dst, col, row, 0, gray_to_pseudo_color (y, 0));
      gdk_pixbuf_put_pixel (dst, col, row, 1, gray_to_pseudo_color (y, 1));
      gdk_pixbuf_put_pixel (dst, col, row, 2, gray_to_pseudo_color (y, 2));
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
  }
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {
  {N_("/Pseudo Color"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Pseudo Color Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.0",
  N_("This plugin converts the gray-scale image\n to the pseudo-color image."),
  1,
  plugin_pseudo
};

/* *********************************************** End of pseudo_color.c *** */
